<?php 

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use App\Models\DeviceTankMapping; 
use App\Models\DeviceMaster;
use App\Models\TankMaster;
use Illuminate\Http\Request;

class DeviceTankMappingController extends Controller  
{
     /**
     * Display a listing of the devices.
     */
    public function index()
    {
        $devices = DeviceTankMapping::all();  // Fetch all devices
        return view('device_tank_mapping.index', compact('devices'));
    }

    /**
     * Show the form for creating a new device.
     */
    public function create()
    {	
		$data['tanks'] = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name')->get();
		$data['cldevice'] = DeviceMaster::where('device_type_id', '1')->where('is_mapped', '0')->get();
		$data['phdevice'] = DeviceMaster::where('device_type_id','2')->where('is_mapped', '0')->get();
		$data['oprdevice'] = DeviceMaster::where('device_type_id','3')->where('is_mapped', '0')->get();
		$data['tdsdevice'] = DeviceMaster::where('device_type_id','4')->where('is_mapped', '0')->get();
		$data['turbiditydevice'] = DeviceMaster::where('device_type_id','5')->where('is_mapped', '0')->get();
		$data['tempdevice'] = DeviceMaster::where('device_type_id','6')->where('is_mapped', '0')->get();
		$data['waterdevice'] = DeviceMaster::where('device_type_id','7')->where('is_mapped', '0')->get();
        return view('device_tank_mapping.addmapping',$data); 
    }

    /**
     * Store a newly created device in the database. 
     */ 
    public function store(Request $request)  
    {
		$tank_id = $request->tank_id;
		$count = DB::table('device_tank_mappings')->where('tank_id', $tank_id)->count();
		
		if($count == 0){
        if($request->ph_sensor)
		{		
			$deviceTankMapping = DeviceTankMapping::create([
				'device_id' => $request->ph_sensor,
				'tank_id' => $tank_id,
				'device_type_id' => 2,
				'is_deleted' => 0,
				'created_at' => now(),
				'created_by' => auth()->id(),
			]);
			$lastInsertedId = $deviceTankMapping->id;
			$mapping_data = array( 'alpha_id' => md5($lastInsertedId) );
			$update_device = DeviceTankMapping::where('id','=',$lastInsertedId)->update($mapping_data);
			$device_data = array( 'is_mapped' => 1 );
			$updatedevice = DeviceMaster::where('id','=',$request->ph_sensor)->update($device_data);
		}
		if($request->tds_sensor)
		{		
			$deviceTankMapping = DeviceTankMapping::create([
				'device_id' => $request->tds_sensor,
				'tank_id' => $tank_id,
				'device_type_id' => 4,
				'is_deleted' => 0,
				'created_at' => now(),
				'created_by' => auth()->id(),
			]);
			$lastInsertedId = $deviceTankMapping->id;
			$mapping_data = array( 'alpha_id' => md5($lastInsertedId) );
			$update_device = DeviceTankMapping::where('id','=',$lastInsertedId)->update($mapping_data);
			$device_data = array( 'is_mapped' => 1 );
			$updatedevice = DeviceMaster::where('id','=',$request->tds_sensor)->update($device_data);
		}
		if($request->turbidity_sensor)
		{		
			$deviceTankMapping = DeviceTankMapping::create([
				'device_id' => $request->turbidity_sensor,
				'tank_id' => $tank_id,
				'device_type_id' => 5,
				'is_deleted' => 0,
				'created_at' => now(),
				'created_by' => auth()->id(),
			]);
			$lastInsertedId = $deviceTankMapping->id;
			$mapping_data = array( 'alpha_id' => md5($lastInsertedId) );
			$update_device = DeviceTankMapping::where('id','=',$lastInsertedId)->update($mapping_data);
			$device_data = array( 'is_mapped' => 1 );
			$updatedevice = DeviceMaster::where('id','=',$request->turbidity_sensor)->update($device_data);
		}
		if($request->cl_sensor)
		{		
			$deviceTankMapping = DeviceTankMapping::create([
				'device_id' => $request->cl_sensor,
				'tank_id' => $tank_id,
				'device_type_id' => 1,
				'is_deleted' => 0,
				'created_at' => now(),
				'created_by' => auth()->id(),
			]);
			$lastInsertedId = $deviceTankMapping->id;
			$mapping_data = array( 'alpha_id' => md5($lastInsertedId) );
			$update_device = DeviceTankMapping::where('id','=',$lastInsertedId)->update($mapping_data);
			$device_data = array( 'is_mapped' => 1 );
			$updatedevice = DeviceMaster::where('id','=',$request->cl_sensor)->update($device_data);
		}
		if($request->temp_sensor)
		{		
			$deviceTankMapping = DeviceTankMapping::create([
				'device_id' => $request->temp_sensor,
				'tank_id' => $tank_id,
				'device_type_id' => 6,
				'is_deleted' => 0,
				'created_at' => now(),
				'created_by' => auth()->id(),
			]);
			$lastInsertedId = $deviceTankMapping->id;
			$mapping_data = array( 'alpha_id' => md5($lastInsertedId) );
			$update_device = DeviceTankMapping::where('id','=',$lastInsertedId)->update($mapping_data);
			$device_data = array( 'is_mapped' => 1 );
			$updatedevice = DeviceMaster::where('id','=',$request->temp_sensor)->update($device_data);
		}
		if($request->opr_sensor)
		{		
			$deviceTankMapping = DeviceTankMapping::create([
				'device_id' => $request->opr_sensor,
				'tank_id' => $tank_id,
				'device_type_id' => 3,
				'is_deleted' => 0,
				'created_at' => now(),
				'created_by' => auth()->id(),
			]);
			$lastInsertedId = $deviceTankMapping->id;
			$mapping_data = array( 'alpha_id' => md5($lastInsertedId) );
			$update_device = DeviceTankMapping::where('id','=',$lastInsertedId)->update($mapping_data);
			$device_data = array( 'is_mapped' => 1 );
			$updatedevice = DeviceMaster::where('id','=',$request->opr_sensor)->update($device_data);
		}
		if($request->water_sensor)
		{		
			$deviceTankMapping = DeviceTankMapping::create([
				'device_id' => $request->water_sensor,
				'tank_id' => $tank_id,
				'device_type_id' => 7,
				'is_deleted' => 0,
				'created_at' => now(),
				'created_by' => auth()->id(),
			]);
			$lastInsertedId = $deviceTankMapping->id;
			$mapping_data = array( 'alpha_id' => md5($lastInsertedId) );
			$update_device = DeviceTankMapping::where('id','=',$lastInsertedId)->update($mapping_data);
			$device_data = array( 'is_mapped' => 1 );
			$updatedevice = DeviceMaster::where('id','=',$request->water_sensor)->update($device_data);
		}       
		
			return redirect()->route('mappingdetails')->with('message', 'Mapping added successfully!')->with('status', 'success');		
		}else{
			return redirect()->route('mappingdetails')->with('message', 'Tank Mapping Already Exist!.')->with('status', 'success');
		}       
    }

    /**
     * Display the specified device.
     */
    public function show()
    {
		//$devices = DeviceMaster::all();
		$sql = "SELECT 
				tm.tank_name,
				tm.id, 
				d.created_at,
				d.tank_id, 
				GROUP_CONCAT(
					CONCAT(
						'(', 
						CASE 
							WHEN dm.device_type_id = 1 THEN 'CL'
							WHEN dm.device_type_id = 2 THEN 'PH'
							WHEN dm.device_type_id = 3 THEN 'OPR'
							WHEN dm.device_type_id = 4 THEN 'TDS'
							WHEN dm.device_type_id = 5 THEN 'Turbidity'
							WHEN dm.device_type_id = 6 THEN 'Temperature'
							WHEN dm.device_type_id = 7 THEN 'Water'
							ELSE 'Unknown'
						END, 
						')', dm.device_uid, ' (', dm.device_brand, ')'
					) 
					ORDER BY dm.device_uid
				) AS device_details
			FROM 
				device_tank_mappings d
			JOIN 
				device_masters dm ON d.device_id = dm.id
			JOIN 
				tank_masters tm ON d.tank_id = tm.id
			GROUP BY 
				d.tank_id, tm.tank_name, tm.id, d.created_at, d.tank_id";
		$device_mapping = DB::select($sql);
				
        return view('device_tank_mapping.mappingdetails', compact('device_mapping'));
    }

    /**
     * Show the form for editing the specified device.
     */
    public function edit($encid)
    {
		$id = base64_decode(base64_decode($encid));
		$data['tanks'] = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name')->get();
		$data['cldevice'] = DeviceMaster::where('device_type_id', '1')->where('is_mapped', '0')->get();
		$data['phdevice'] = DeviceMaster::where('device_type_id','2')->where('is_mapped', '0')->get();
		$data['oprdevice'] = DeviceMaster::where('device_type_id','3')->where('is_mapped', '0')->get();
		$data['tdsdevice'] = DeviceMaster::where('device_type_id','4')->where('is_mapped', '0')->get();
		$data['turbiditydevice'] = DeviceMaster::where('device_type_id','5')->where('is_mapped', '0')->get();
		$data['tempdevice'] = DeviceMaster::where('device_type_id','6')->where('is_mapped', '0')->get();
		$data['waterdevice'] = DeviceMaster::where('device_type_id','7')->where('is_mapped', '0')->get();
		$data['tank_id'] = $id;
		$mapping = DB::table('device_tank_mappings')->where('tank_id', $id)->get();
		$mapped_device = array();
		foreach ($mapping as $result) {
			array_push($mapped_device,$result->device_id);
		}
		$data['mapped_device'] = $mapped_device;
		$sql = "SELECT GROUP_CONCAT( CONCAT( '(', CASE WHEN dm.device_type_id = 1 THEN 'CL' WHEN dm.device_type_id = 2 THEN 'PH' WHEN dm.device_type_id = 3 THEN 'OPR' WHEN dm.device_type_id = 4 THEN 'TDS' WHEN dm.device_type_id = 5 THEN 'Turbidity' WHEN dm.device_type_id = 6 THEN 'Temperature' WHEN dm.device_type_id = 7 THEN 'Water' ELSE 'Unknown' END, ')', dm.device_uid, ' (', dm.device_brand, ')' ) ORDER BY dm.device_uid ) AS device_details FROM device_tank_mappings d JOIN device_masters dm ON d.device_id = dm.id JOIN tank_masters tm ON d.tank_id = tm.id WHERE d.tank_id = '$id'";
		$device_mapping_data = DB::select($sql);
		$data['device_mapping_data'] = $device_mapping_data;
        return view('device_tank_mapping.editmapping', $data);
    }
	/**
     * Update the specified device in the database.
     */
    public function update(Request $request)
    {  
		//dd($request);
		$tank_id = $request->tank_id;	
        
		if($request->ph_sensor)
		{		
			$device_type_id = 2;
			$mapping_data = array( 'device_id' => $request->ph_sensor );
			$update_device = DeviceTankMapping::where('device_type_id', $device_type_id)->where('tank_id', $tank_id)->update($mapping_data);
			$device_data = array( 'is_mapped' => 1 );
			$updatedevice = DeviceMaster::where('id','=',$request->ph_sensor)->update($device_data);
		}
		if($request->tds_sensor)
		{		
			$device_type_id = 4;
			$mapping_data = array( 'device_id' => $request->tds_sensor );
			$update_device = DeviceTankMapping::where('device_type_id', $device_type_id)->where('tank_id', $tank_id)->update($mapping_data);
			$device_data = array( 'is_mapped' => 1 );
			$updatedevice = DeviceMaster::where('id','=',$request->tds_sensor)->update($device_data);
		}
		if($request->turbidity_sensor)
		{		
			$device_type_id = 5;
			$mapping_data = array( 'device_id' => $request->turbidity_sensor );
			$update_device = DeviceTankMapping::where('device_type_id', $device_type_id)->where('tank_id', $tank_id)->update($mapping_data);
			$device_data = array( 'is_mapped' => 1 );
			$updatedevice = DeviceMaster::where('id','=',$request->turbidity_sensor)->update($device_data);
		}
		if($request->cl_sensor)
		{		
			$device_type_id = 1;
			$mapping_data = array( 'device_id' => $request->cl_sensor );
			$update_device = DeviceTankMapping::where('device_type_id', $device_type_id)->where('tank_id', $tank_id)->update($mapping_data);
			$device_data = array( 'is_mapped' => 1 );
			$updatedevice = DeviceMaster::where('id','=',$request->cl_sensor)->update($device_data);
		}
		if($request->temp_sensor)
		{		
			$device_type_id = 6;
			$mapping_data = array( 'device_id' => $request->temp_sensor );
			$update_device = DeviceTankMapping::where('device_type_id', $device_type_id)->where('tank_id', $tank_id)->update($mapping_data);
			$device_data = array( 'is_mapped' => 1 );
			$updatedevice = DeviceMaster::where('id','=',$request->temp_sensor)->update($device_data);
		}
		if($request->opr_sensor)
		{		
			$device_type_id = 3;
			$mapping_data = array( 'device_id' => $request->opr_sensor );
			$update_device = DeviceTankMapping::where('device_type_id', $device_type_id)->where('tank_id', $tank_id)->update($mapping_data);
			$device_data = array( 'is_mapped' => 1 );
			$updatedevice = DeviceMaster::where('id','=',$request->opr_sensor)->update($device_data);
		}
		if($request->water_sensor)
		{		
			$device_type_id = 7;
			$mapping_data = array( 'device_id' => $request->water_sensor );
			$update_device = DeviceTankMapping::where('device_type_id', $device_type_id)->where('tank_id', $tank_id)->update($mapping_data);
			$device_data = array( 'is_mapped' => 1 );
			$updatedevice = DeviceMaster::where('id','=',$request->water_sensor)->update($device_data);
		} 
		
		return redirect()->route('mappingdetails')->with('message', 'Mapping Updated successfully.')->with('status', 'success');
    }
}
