<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use App\Models\WaterHealthMeasure;
use Illuminate\Http\Request;

class WaterHealthMeasureController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
        $this->middleware('permission:measures-list|measures-create|measures-edit|measures-delete', ['only' => ['index']]);
        $this->middleware('permission:measures-edit', ['only' => ['edit', 'update']]);
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $measures =  WaterHealthMeasure::all();
        return view('list_measures', ['measures' => $measures]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $alpha_id)
    {
        //$measure = WaterHealthMeasure::find($id);
        $measure = WaterHealthMeasure::where('alpha_id', $alpha_id)->firstOrFail();
        return view('edit_measure', compact('measure'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        $data = $request->all();
        $measureId = $request->measure_id;
        $request->validate([
            'param_min_value' => ['required', 'numeric'],
            'param_max_value' => ['required', 'numeric', function ($attribute, $value, $fail) use ($request) {
                if ($request->param_min_value > $value) {
                    $fail('The max value must be greater than the min value.');
                }
            }],
        ]);
        $measure_data = array(
            'param_max_value' => $data['param_max_value'],
            'param_min_value' => $data['param_min_value'],
            'updated_by' => Auth::id(),
            'updated_at' => date('Y-m-d H:i:s'),
        );
        WaterHealthMeasure::where('id', '=', $measureId)->update($measure_data);
        // Redirect back with a success message
        return redirect()->route('list_measure')->with('success', 'Parameter value updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
