<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDeviceMasterTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('device_masters', function (Blueprint $table) {
            $table->bigIncrements('id');  // BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY
            $table->string('device_uid')->unique();  // VARCHAR(255) UNIQUE
            $table->string('device_type_id');  // VARCHAR(255)
			$table->string('device_brand');  // VARCHAR(255)
            $table->dateTime('device_purchased_on')->nullable();  // DATETIME
            $table->tinyInteger('device_status')->nullable();  // TINYINT
            $table->tinyInteger('is_deleted');  // TINYINT
            $table->dateTime('created_at');  // DATETIME
            $table->unsignedBigInteger('created_by')->nullable();  // BIGINT UNSIGNED
            $table->dateTime('updated_at')->nullable();  // DATETIME, NULLABLE
            $table->unsignedBigInteger('updated_by')->nullable();  // BIGINT UNSIGNED, NULLABLE
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('device_masters');
    }
}

