@extends('layouts.main')

@section('content')
<main class="content">
        <div class="g-color"></div>
        <div class="position-relative">
          <div class="container-sec">
            <div class="cotainer-body p-4">
              <div class="page-hading">
                <a href="#" class="d-flex align-items-center">
                  <i class="ri-arrow-left-line"></i> Add Sensor
                </a>
              </div>
              <div class="add-tank">
                <form class="mt-5" action="{{ route('store_device') }}" method="post">
				@csrf
                  <div class="row">
                    <div class="col-md-4">
                      <div class="mb-3">
                        <label class="form-label"><b>Device Serial No</b> <span style="color:#FF0000;">*</span></label>
                        <input type="text" class="form-control" name="device_uid" id="device_uid" required>
						<div id='error-uid' style="color: red;"></div>
                      </div>
                    </div>
                    <div class="col-md-4">
                      <div class="mb-3">
                        <label class="form-label"><b>Device Type</b> <span style="color:#FF0000;">*</span></label>
						<select class="form-select" name="device_type_id" id="device_type_id" aria-label="Default select example">
                          <option value="">Select Device Type</option>
                          <option value="1">CL Sensor</option>
                          <option value="2">PH Sensor</option>
                          <option value="3">ORP Sensor</option>
						  <option value="4">TDS Sensor</option>
                          <option value="5">Turbidity Sensor</option>
                          <option value="6">Temperature Sensor</option>
						  <option value="7">Water Sensor</option>                          
                        </select>
						<div id='error-type' style="color: red;"></div>
                      </div>
                    </div>
					<div class="col-md-4">
                      <div class="mb-3">
                        <label class="form-label"><b>Device Brand</b> <span style="color:#FF0000;">*</span></label>
                        <input type="text" class="form-control" name="device_brand" id="device_brand" aria-describedby="">
                        <div id='error-brand' style="color: red;"></div>
                      </div>
                    </div>
                  </div>
				  <div class="row">				
                    <div class="col-md-4">
                      <div class="mb-3">
                        <label class="form-label"><b>Device Purchase Date</b> <span style="color:#FF0000;">*</span></label>
                        <input type="text" class="form-control" name="device_purchased_on" id="device_purchased_on" >
						<div id='error-pon' style="color: red;"></div>
                      </div>
                    </div>
					
                    <div class="col-md-4">
                      <div class="mb-3">
                        <label class="form-label"><b>Device Status</b> <span style="color:#FF0000;">*</span></label>
						<select class="form-select" name="device_status" id="device_status" aria-label="Default select example">
                          <option value="">Select Device Status</option>
                          <option value="1">Active</option>
                          <option value="0">Inactive</option>
                        </select>
						<div id='error-status' style="color: red;"></div>
                      </div>
                    </div>
                  </div>  
                  
                  <div class="row">
                    <input type="hidden" name="created_by" value="1" />
                  </div>
					
					<div class="btn-footer">
                  <div class="btn-sec m-2">
                    <button type="submit" class="btn btn-primary"  onClick="return validation();">Submit</button>
                  </div>
                </div>

                </form>

                

              </div>
            </div>
          </div>
        </div>

        
      </main>

@endsection	 
@push('scripts')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<script>
  $(function() {
    $("#device_purchased_on").datepicker({
      dateFormat: 'dd-mm-yy' // Example format
    });
  });
</script>
@endpush
  
<script>  
    function validation() {		
        if (document.getElementById('device_uid').value == "") {
            $('#error-uid').html('* Device Unique ID is required');
            $('#error-uid').css('color', 'red');
            $('#device_uid').focus();
            return false;
        }
		if (document.getElementById('device_type_id').value == "") {
            $('#error-type').html('* Device Type is required');
            $('#error-type').css('color', 'red');
            $('#device_type_id').focus();
            return false;
        }
		if (document.getElementById('device_brand').value == "") {
            $('#error-brand').html('* Brand is required');
            $('#error-brand').css('color', 'red');
            $('#device_brand').focus();
            return false;
        }
		if (document.getElementById('device_purchased_on').value == "") {
            $('#error-pon').html('* Purchase Date is required');
            $('#error-pon').css('color', 'red');
            $('#device_purchased_on').focus();
            return false;
        }
		if (document.getElementById('device_status').value == "") {
            $('#error-status').html('* Device Status is required');
            $('#error-status').css('color', 'red');
            $('#device_status').focus();
            return false;
        }		
        return true;
    }
</script>
