@extends('layouts.main')

@section('content')
<main class="content">
    <div class="g-color"></div>
    <div class="position-relative">
        <div class="container-sec">
            <div class="cotainer-body p-4">
                <div class="page-hading">
                    <a href="#" class="d-flex align-items-center">
                        <i class="ri-arrow-left-line"></i> Edit Config Settings
                    </a>
                </div>
                <div class="add-tank">
                    <form class="mt-5" action="{{ route('update_config') }}" method="post">
                        @csrf
                        <div class="row">
                            @if ($config->id==2)
                            <span class="alert-info font-italics">Please add multiple email addresses by separating them by comma (,)</span>
                            @elseif ($config->id==3)
                            <!-- Display if the first condition is false but the second is true -->
                            @else
                            <!-- Display if none of the conditions are true -->
                            @endif
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label"><b>Name</b></label>
                                    <input type="text" class="form-control" name="key" id="config_name" aria-describedby="" value="{{ $config->key }}" readonly>
                                    <!-- <div class=" form-text red-text">We'll never share your email with anyone else.
                                </div> -->
                                </div>
                            </div>
                            @if ($config->id==2 || $config->id==3)
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label"><b>Value</b></label>
                                    <input type="text" class="form-control" name="value" id="config_alpha" value="{{ $config->value }}" required>
                                    @error('value')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            @endif
                            @if ($config->id==5 || $config->id==4)
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label"><b>Select Tank</b></label>
                                    <!-- <input type="text" class="form-control" name="value" id="config_alpha" value="{{ $config->value }}" required> -->
                                    <select class="form-select" name="value" id="config_alpha" required>
                                        @foreach ($tanks as $tank)
                                        <option value="{{ $tank->id }}" @if($config->value == $tank->id){{'selected'}}@endif>
                                            {{ $tank->tank_name }}
                                        </option>
                                        @endforeach
                                    </select>
                                    @error('value')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            @endif
                        </div>
                        <input type="hidden" name="config_id" value="{{ $config->id }}" />
                        <div class="btn-footer">
                            <div class="btn-sec m-2">
                                <button type="submit" class="btn btn-brder">Cancel</button>
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>


</main>

@endsection
<?php
function generateSecureAlphanumericString($length = 10)
{
    // Generate random bytes and convert to hexadecimal
    $bytes = random_bytes($length);
    $hex = bin2hex($bytes);

    // Trim to the desired length
    return substr($hex, 0, $length);
}
?>