@extends('layouts.main')

@section('content')
<main class="content">
        <div class="g-color"></div>
		<div class="table-header position-relative">
        <div class="row justify-content-between">
            <form class="hd-date-input  mt-5" action="{{ route('tankDateReport') }}" method="post">
                @csrf
                <div class="col-md-12">
                    <ul class="d-flex align-items-center p-0">
                        <li class="">
                            <div class="date-input d-flex align-items-center position-relative"><b class="me-3">Date From:</b>
                                   <span class="date-inputbox position-relative w-50">
                                <input class="form-control" type="text" name="fromdate" value="<?php echo date('d-m-Y', strtotime($from_date)); ?>" id="from_date_input" autocomplete="off">
								<i class="ri-calendar-2-line"></i>
                            </span>
                            </div>
                        </li>
                        <li class="">
                            <div class=" date-input d-flex align-items-center position-relative"><b class="me-2">To :</b>
                                   <span class="date-inputbox position-relative w-75">
                                <input class="form-control" type="text" name="todate" value="<?php echo date('d-m-Y', strtotime($to_date)); ?>" id="to_date_input" autocomplete="off">
								<i class="ri-calendar-2-line"></i>
                            </span>
                            </div>
                        </li>
						<li class="">
                            <div class="d-flex align-items-center position-relative"><b class="me-2">Search By :</b>
                                <select class="form-select w-50" name="view_by" id="view_by"
                                    aria-label="Default select example">
                                    <!--<option value="">Select View Type</option>-->
                                    <option value="1" @if($view_by==1) {{'selected'}} @endif>Tank Wise</option>
                                    <option value="2" @if($view_by==2) {{'selected'}} @endif>KPI Wise</option>
                                </select>
                            </div>
                        </li>
                         <li class="" id="tank_wise" @if($view_by==2) style="display: none;" @endif>
							
                            <div class="d-flex align-items-center position-relative">
							<b class="me-2 w-50">Tank List :</b>
                                <select class="form-select w-50 me-2" name="tank_list" id="tank_list"
                                    aria-label="Default select example">
                                    <!--<option value="">Select Tank</option>-->
                                    @foreach ($all_tanks as $tank)
                                    <option value="{{ $tank->id }}">
                                        {{ $tank->tank_name }}
                                    </option>
                                    @endforeach
                                </select>
                            <button type="submit" class="btn btn-primary"
                                    onClick="return validation();">Submit</button>
                            </div>
                        </li>
						<li class=""  id="KPI_wise" @if($view_by==1) style="display: none;" @endif>
						
						 <div class="d-flex align-items-center position-relative"><b class="me-2">Parameter Type :</b>
                                <select class="form-select w-75 me-2" name="device_type_id" id="device_type_id"
                                    aria-label="Default select example">
                                    <!--<option value="">Select Parameter Type</option>-->
                                    <option value="chlrn" @if($param_val=='chlrn' ){{'selected'}}@endif>CL </option>
                                    <option value="ph" @if($param_val=='ph' ){{'selected'}}@endif>PH </option>
                                    <option value="opr" @if($param_val=='opr' ){{'selected'}}@endif>ORP </option>
                                    <option value="tds" @if($param_val=='tds' ){{'selected'}}@endif>TDS </option>
                                    <option value="tur" @if($param_val=='tur' ){{'selected'}}@endif>Turbidity </option>
                                    <!-- <option value="6">Temperature Sensor</option>-->
                                    <option value="water_lvl" @if($param_val=='water_lvl' ){{'selected'}}@endif>Water </option>
                                </select>
                            <button type="submit" class="btn btn-primary"
                                    onClick="return validation();">Submit</button>
							</div>
						</li>
                    </ul>
                </div>
            </form>
        </div>
    </div>
        <div class="position-relative">
          <div class="container-sec">
            <div class="cotainer-body p-4">
              <div class="page-hading">
				<div class="d-flex align-items-center position-relative d-sm-block d-md-flex">
					<a href="#" class="d-flex align-items-center">
					  <i class="ri-arrow-left-line"></i> Historical Data Chart
					</a>
					<div class="detasheet-graph-icon ms-auto">
						<a href="javascript:history.back()">Datasheet</a>
						<a href="#" class="active">Graph</a>
					</div>
				</div>
              </div>
			  <?php //echo "<pre>"; print_r($readings); die; ?>
              <div class="add-tank">
                <div class="row">
					@foreach ($readings as $tankId => $readingData)						
					<div class="col-md-6">
						<h4>Tank Name: {{$readingData['tank_name']}}</h4>
						@if(!empty($readingData['result']))
						<div id="container_{{ $tankId }}"></div>
						@else
						<div id="container">
							<p>No data available for this tank.</p>
						</div>
						@endif
					</div>						
					@endforeach
					
                </div>
				  
				               

              </div>
            </div>
          </div>
        </div>

        
      </main>

@endsection	 

<script src="https://code.highcharts.com/highcharts.js"></script>
@push('scripts')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<script>
        $(function() {
            // Initialize datepickers with format dd-mm-yy
            $('#from_date_input, #to_date_input').datepicker({
                dateFormat: 'dd-mm-yy'
            });

            // Event handler for fromdate selection
            $('#device_purchased_on').on('change', function() {
                var fromDate = $(this).datepicker('getDate');

                // Set maxDate on todate (fromDate + 7 days)
                if (fromDate) {
                    var maxDate = new Date(fromDate);
                    maxDate.setDate(maxDate.getDate() + 29);

                    $('#device_purchased_on').datepicker('option', 'minDate', fromDate);
                    $('#device_purchased_on1').datepicker('option', 'maxDate', maxDate);
                }
            });

            // Event handler for todate selection
            $('#device_purchased_on1').on('change', function() {
                var fromDate = $('#fromdate').datepicker('getDate');
                var toDate = $(this).datepicker('getDate');

                if (fromDate && toDate) {
                    var diffDays = (toDate - fromDate) / (1000 * 60 * 60 * 24); // Difference in days

                    if (diffDays > 29) {
                        alert('The date range cannot exceed 15 days.');
                        $(this).val(''); // Reset todate value
                    }
                }
            });
        });
</script>
@endpush
<script>
  	document.addEventListener('DOMContentLoaded', function() {
        // Get the elements
        var viewBy = document.getElementById('view_by');
        var tankWiseDiv = document.getElementById('tank_wise');
        var KPIWiseDiv = document.getElementById('KPI_wise');

        // Add event listener to the select element
        viewBy.addEventListener('change', function() {
            var selectedValue = this.value;

            // Reset both divs to hidden initially
            tankWiseDiv.style.display = 'none';
            KPIWiseDiv.style.display = 'none';

            // Show the relevant div based on the selected option
            if (selectedValue === '1') {
                tankWiseDiv.style.display = 'block'; // Show Tank Wise div
            } else if (selectedValue === '2') {
                KPIWiseDiv.style.display = 'block'; // Show KPI Wise div
            }
        });
    });
    
</script>
<script>
    function validation() {
        if (document.getElementById('device_purchased_on').value == "") {
            $('#error-fdt').html('* From Date Is Required');
            $('#error-fdt').css('color', 'red');
            $('#device_purchased_on').focus();
            return false;
        }
        if (document.getElementById('device_purchased_on1').value == "") {
            $('#error-tdt').html('* To Date Is Required');
            $('#error-tdt').css('color', 'red');
            $('#device_purchased_on1').focus();
            return false;
        }
        if (document.getElementById('view_by').value == "") {
            $('#error-vb').html('* Select Search By');
            $('#error-vb').css('color', 'red');
            $('#view_by').focus();
            return false;
        }
        if (document.getElementById('view_by').value == "1") {
            if (document.getElementById('tank_list').value == "") {
                $('#error-tl').html('* Select A Tank');
                $('#error-tl').css('color', 'red');
                $('#tank_list').focus();
                return false;
            }
        }
        if (document.getElementById('view_by').value == "2") {
            if (document.getElementById('device_type_id').value == "") {
                $('#error-dti').html('* Select A Parameter');
                $('#error-dti').css('color', 'red');
                $('#device_type_id').focus();
                return false;
            }
        }
        return true;
    }
</script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    // Set global Highcharts options
    Highcharts.setOptions({
        lang: {
            decimalPoint: '.',
            thousandsSep: ','
        }
    });

    @php $x = 1; @endphp
    @foreach ($readings as $tankId => $readingData)
        // Prepare the data for xAxis (dates) and yAxis (ph values)
        let dates{{ $x }} = [];
        let maxPhValues{{ $x }} = [];
        let minPhValues{{ $x }} = [];
        let avgPhValues{{ $x }} = [];

        @if (!empty($readingData['result']))
            @foreach ($readingData['result'] as $data)
                dates{{ $x }}.push('{{ \Carbon\Carbon::parse($data['created_date'])->format('d-m-Y') }}');
                maxPhValues{{ $x }}.push(parseFloat({{ $data['mxph'] ?? 0 }}));
                minPhValues{{ $x }}.push(parseFloat({{ $data['miph'] ?? 0 }}));
                avgPhValues{{ $x }}.push(parseFloat({{ $data['midph'] ?? 0 }}));
            @endforeach
        @endif

        // Check if there is no data for the tank
        if (dates{{ $x }}.length === 0) {
            console.log("No data for Tank ID: {{ $tankId }}");
        } else {
            // Render the Highcharts graph for tanks with data
            Highcharts.chart('container_{{ $tankId }}', {
                chart: {
                    type: 'column' // Vertical bar chart
                },
                title: {
                    text: 'pH Levels - Tank ID: {{ $tankId }}'
                },
                xAxis: {
                    categories: dates{{ $x }}, // Dates as categories
                    title: {
                        text: 'Date'
                    }
                },
                yAxis: {
                    title: {
                        text: 'pH Value'
                    },
                    allowDecimals: true
                },
                series: [
                    {
                        name: 'Max pH',
                        data: maxPhValues{{ $x }},
                        color: '#FF0000' // Red color
                    },
                    {
                        name: 'Avg pH',
                        data: avgPhValues{{ $x }},
                        color: '#028A0F' // Green color
                    },
                    {
                        name: 'Min pH',
                        data: minPhValues{{ $x }},
                        color: '#00FF00' // Light green color
                    }
                ]
            });
        }

        @php $x++; @endphp
    @endforeach
});
</script>

