@extends('layouts.main')

@section('content')
<main class="content">
    <div class="g-color"></div>
    <!-- <div class="table-header position-relative">
        <div class="row justify-content-between ">
            <div class="col-md-4">
                <ul class="row align-items-center p-0">
                    <li class="col"><b>Date :</b>04/09/2024</li>
                    <li class="col"><b>Last Phased :</b>12:00 PM</li>
                    <li class="col-6">
                        <div class="d-flex align-items-center position-relative"><b class="me-2">Search Tank :</b>
                            <div class="serach-ar d-flex align-items-center">
                                <input class="form-control" type="search" placeholder="Search" aria-label="Search">
                                <button class="search-icon" type="submit"><i class="ri-search-2-line"></i></button>
                            </div>
                        </div>
                    </li>
                </ul>
            </div>

        </div>
        <div class="row justify-content-between">
            <div class="col-md-6">
                <ul class="d-flex align-items-center p-0">
                    <li class="">
                        <div class="d-flex align-items-center position-relative"><b class="me-3">Date Range:</b>
                            <input class="form-control w-50" type="date">
                        </div>
                    </li>
                    <li class="">
                        <div class="d-flex align-items-center position-relative"><b class="me-2">To :</b>
                            <input class="form-control w-75" type="date" placeholder="Search" aria-label="Search">
                        </div>
                    </li>
                </ul>
            </div>
            <div class="col-md-4">
                <div class="d-flex align-items-center justify-content-end">
                    <div class="btn black-btn me-2"><i class="ri-base-station-fill"></i>Add Sensor</div>
                    <div class="d-flex align-items-center justify-content-end">
                        <span class="me-2 text-white w-100">Select Tank:</span>
                        <select class="form-select w-50" aria-label="Default select example">
                            <option selected>10</option>
                            <option value="1">One</option>
                            <option value="2">Two</option>
                            <option value="3">Three</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>
    </div> -->
    <div class="position-relative">
        <div class="container-sec">
            <div class="cotainer-body p-4">
                <div class="page-hading">
                    <a href="#" class="d-flex align-items-center">
                        Select Range
                    </a>
                </div>
                <div class="add-tank">
                    <form class="mt-5 hd-date-input" action="{{ route('tankDateReport') }}" method="post">
                        @csrf

                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label"><b>From Date</b> <span
                                            style="color:#FF0000;">*</span></label>
                                    <input type="text" class="form-control" name="fromdate" id="device_purchased_on">
                                    <div id='error-fdt' style="color: red;"></div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label"><b>To Date</b> <span
                                            style="color:#FF0000;">*</span></label>
                                    <input type="text" class="form-control" name="todate" id="device_purchased_on1">
                                    <div id='error-tdt' style="color: red;"></div>
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label"><b>Search By</b> <span
                                            style="color:#FF0000;">*</span></label>
                                    <select class="form-select" name="view_by" id="view_by"
                                        aria-label="Default select example">
                                        <option value="">Select View Type</option>
                                        <option value="1">Tank Wise</option>
                                        <option value="2">KPI Wise</option>
                                    </select>
                                    <div id='error-vb' style="color: red;"></div>
                                </div>
                            </div>
                        </div>

                        <!-- Tank Wise Section -->
                        <div class="row" id="tank_wise" style="display: none;">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label"><b>Tank List</b> <span
                                            style="color:#FF0000;">*</span></label>
                                    <select class="form-select" name="tank_list" id="tank_list"
                                        aria-label="Default select example">
                                        <option value="">Select Tank</option>
                                        @foreach ($tanks as $tank)
                                        <option value="{{ $tank->tank_uid }}">
                                            {{ $tank->tank_name.'('.$tank->tank_uid.')' }}
                                        </option>
                                        @endforeach
                                    </select>
                                    <div id='error-tl' style="color: red;"></div>
                                </div>
                            </div>
                        </div>

                        <!-- KPI Wise Section -->
                        <div class="row" id="KPI_wise" style="display: none;">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label"><b>Parameter Type</b> <span
                                            style="color:#FF0000;">*</span></label>
                                    <select class="form-select" name="device_type_id" id="device_type_id"
                                        aria-label="Default select example">
                                        <option value="">Select Parameter Type</option>
                                        <option value="chlrn">CL Sensor</option>
                                        <option value="ph">PH Sensor</option>
                                        <option value="opr">ORP Sensor</option>
                                        <option value="tds">TDS Sensor</option>
                                        <option value="tur">Turbidity Sensor</option>
                                        <!-- <option value="6">Temperature Sensor</option>-->
                                        <option value="water_lvl">Water Sensor</option>
                                    </select>
                                    <div id='error-dti' style="color: red;"></div>
                                </div>
                            </div>
                        </div>

                        <div class="btn-footer">
                            <div class="btn-sec m-2">
                                <button type="submit" class="btn btn-primary"
                                    onClick="return validation();">Submit</button>
                            </div>
                        </div>

                    </form>



                </div>
            </div>
        </div>
    </div>


</main>

@endsection
@push('scripts')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<script>
$(function() {
    $("#device_purchased_on").datepicker({
        dateFormat: 'dd-mm-yy' // Example format
    });
});

$(function() {
    $("#device_purchased_on1").datepicker({
        dateFormat: 'dd-mm-yy' // Example format
    });
});
</script>
@endpush

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Get the elements
    var viewBy = document.getElementById('view_by');
    var tankWiseDiv = document.getElementById('tank_wise');
    var KPIWiseDiv = document.getElementById('KPI_wise');

    // Add event listener to the select element
    viewBy.addEventListener('change', function() {
        var selectedValue = this.value;

        // Reset both divs to hidden initially
        tankWiseDiv.style.display = 'none';
        KPIWiseDiv.style.display = 'none';

        // Show the relevant div based on the selected option
        if (selectedValue === '1') {
            tankWiseDiv.style.display = 'block'; // Show Tank Wise div
        } else if (selectedValue === '2') {
            KPIWiseDiv.style.display = 'block'; // Show KPI Wise div
        }
    });
});
</script>

<script>
function validation() {
    if (document.getElementById('device_purchased_on').value == "") {
        $('#error-fdt').html('* From Date Is Required');
        $('#error-fdt').css('color', 'red');
        $('#device_purchased_on').focus();
        return false;
    }
    if (document.getElementById('device_purchased_on1').value == "") {
        $('#error-tdt').html('* To Date Is Required');
        $('#error-tdt').css('color', 'red');
        $('#device_purchased_on1').focus();
        return false;
    }
    if (document.getElementById('view_by').value == "") {
        $('#error-vb').html('* Select Search By');
        $('#error-vb').css('color', 'red');
        $('#view_by').focus();
        return false;
    }
    if (document.getElementById('view_by').value == "1") {
        if (document.getElementById('tank_list').value == "") {
            $('#error-tl').html('* Select A Tank');
            $('#error-tl').css('color', 'red');
            $('#tank_list').focus();
            return false;
        }
    }
    if (document.getElementById('view_by').value == "2") {
        if (document.getElementById('device_type_id').value == "") {
            $('#error-dti').html('* Select A Parameter');
            $('#error-dti').css('color', 'red');
            $('#device_type_id').focus();
            return false;
        }
    }
    return true;
}
</script>