@extends('layouts.main')

@section('content')
<main class="content">
    <div class="g-color"></div>
    <div class="table-header position-relative">

        <div class="row justify-content-between">
            <form class="hd-date-input mt-5" action="{{ route('tankDateReport') }}" method="post">
                @csrf
                <div class="col-md-12">
                    <ul class="d-flex align-items-center p-0">
                        <!--<li class="">
                            <div class="d-flex align-items-center position-relative"><b class="me-3">Date From:</b>
                                <input class="form-control w-50" type="text" name="fromdate" value="<?php echo date('d-m-Y', strtotime($from_date)); ?>" id="from_date_input">
                            </div>
                        </li>
                        <li class="">
                            <div class="d-flex align-items-center position-relative"><b class="me-2">To :</b>
                                <input class="form-control w-75" type="text" name="todate" value="<?php echo date('d-m-Y', strtotime($to_date)); ?>" id="to_date_input">
                            </div>
                        </li>-->
                        <li class="">
                            <div class="date-input d-flex align-items-center position-relative"><b class="me-3">Date
                                    From:</b>
                                <span class="date-inputbox position-relative w-50">
                                    <input class="form-control" type="text" name="fromdate"
                                        value="<?php echo date('d-m-Y', strtotime($from_date)); ?>" id="from_date_input"
                                        autocomplete="off">
                                    <i class="ri-calendar-2-line"></i>
                                </span>
                            </div>
                        </li>
                        <li class="">
                            <div class=" date-input d-flex align-items-center position-relative"><b class="me-2">To
                                    :</b>
                                <span class="date-inputbox position-relative w-75">
                                    <input class="form-control" type="text" name="todate"
                                        value="<?php echo date('d-m-Y', strtotime($to_date)); ?>" id="to_date_input"
                                        autocomplete="off">
                                    <i class="ri-calendar-2-line"></i>
                                </span>
                            </div>
                        </li>
                        <li class="">
                            <div class="d-flex align-items-center position-relative"><b class="me-2">Search By :</b>
                                <select class="form-select w-50" name="view_by" id="view_by"
                                    aria-label="Default select example">
                                    <!--<option value="">Select View Type</option>-->
                                    <option value="1" @if($view_by==1) {{'selected'}} @endif>Tank Wise</option>
                                    <option value="2" @if($view_by==2) {{'selected'}} @endif>KPI Wise</option>
                                </select>
                            </div>
                        </li>
                        <li class="" id="tank_wise" @if($view_by==2) style="display: none;" @endif>

                            <div class="d-flex align-items-center position-relative">
                                <b class="me-2">Tank List :</b>
                                <select class="form-select w-50 me-2" name="tank_list" id="tank_list"
                                    aria-label="Default select example">
                                    <!--<option value="">Select Tank</option>-->
                                    @foreach ($all_tanks as $tank)
                                    <option value="{{ $tank->id }}" @if($tank->id==$tank_uid){{'selected'}}@endif>
                                        {{ $tank->tank_name }}
                                    </option>
                                    @endforeach
                                </select>
                                <button type="submit" class="btn btn-primary"
                                    onClick="return validation();">Submit</button>
                            </div>
                        </li>
                        <li class="" id="KPI_wise" @if($view_by==1) style="display: none;" @endif>

                            <div class="d-flex align-items-center position-relative"><b class="me-2">Parameter Type
                                    :</b>
                                <select class="form-select w-75 me-2" name="device_type_id" id="device_type_id"
                                    aria-label="Default select example">
                                    <!--<option value="">Select Parameter Type</option>-->
                                    <option value="chlrn">CL </option>
                                    <option value="ph">PH </option>
                                    <option value="iron_lvl">IRON </option>
                                    <option value="tds">TDS </option>
                                    <option value="tur">Turbidity </option>
                                    <!-- <option value="6">Temperature Sensor</option>-->
                                    <option value="water_lvl">Water </option>
                                </select>
                                <button type="submit" class="btn btn-primary"
                                    onClick="return validation();">Submit</button>
                            </div>
                        </li>
                    </ul>
                </div>

            </form>
        </div>
    </div>
    <div class="position-relative">
        <div class="container-sec">
            <div class="cotainer-body p-4">
                <div class="page-hading">
                    <div class="d-flex align-items-center position-relative d-sm-block d-md-flex">
                        <a href="#" class="d-flex align-items-center me-4 mb-0">
                            <i class="ri-table-line"></i>Historical Data
                        </a>
                        <div class="detasheet-graph-icon ms-auto">
                            <a href="#" class="active">Datasheet</a>
                            <a href="{{route('tankwisechart',$enc_data)}}" class="">Graph</a>
                        </div>
                        <form method="get" class="download-btn-sec mb-0" action="{{ route('tankwisexcel',$enc_data) }}">
                            <button class="btn download-btn ms-2"><i class="ri-folder-download-fill"></i>
                                Download</button>
                        </form>
                    </div>
                </div>

                <div class="tank-wise-sec">
                    <h2 class="mt-3 mb-3 align-items-center d-flex"><i class="ri-calendar-2-line me-2"
                            style="font-size: 24px; font-weight: 100;"></i> From:
                        {{\Carbon\Carbon::parse($from_date)->format('d-m-Y')}} To:
                        {{\Carbon\Carbon::parse($to_date)->format('d-m-Y')}}
                    </h2>
                    <!-- pH values table -->
                    <div class="row">
                        <h2 class="mt-3 mb-3 align-items-center d-flex"><i class="ri-table-2 me-2"
                                style="font-size: 24px; font-weight: 100;"></i> Parameter : pH
                        </h2>
                        <div class="table-ar table-responsive">
                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th scope="col" style="text-align: left;">Date </th>
                                        <th scope="col">Maximum </th>
                                        <th scope="col">Average</th>
                                        <th scope="col">Minimum</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($phValues as $phData)
                                    <tr>
                                        <td style="text-align: left;">
                                            {{\Carbon\Carbon::parse($phData->created_date)->format('d-m-Y')}}
                                        </td>
                                        <td>{!! number_format((float)($phData->mxph), 2) !!}</td>
                                        <td>{!! number_format((float)($phData->midph), 2) !!}</td>
                                        <td>{!! number_format((float)($phData->miph), 2) !!}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- opr values table -->
                    <div class="row">
                        <h2 class="mt-3 mb-3 align-items-center d-flex"><i class="ri-table-2 me-2"
                                style="font-size: 24px; font-weight: 100;"></i> Parameter : IRON
                        </h2>
                        <div class="table-ar table-responsive">
                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th scope="col" style="text-align: left;">Date </th>
                                        <th scope="col">Maximum </th>
                                        <th scope="col">Average</th>
                                        <th scope="col">Minimum</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($oprValues as $oprData)
                                    <tr>
                                        <td style="text-align: left;">
                                            {{\Carbon\Carbon::parse($oprData->created_date)->format('d-m-Y')}}
                                        </td>
                                        <td>{!! number_format((float)($oprData->mxfe), 2) !!} mV</td>
                                        <td>{!! number_format((float)($oprData->midfe), 2) !!} mV</td>
                                        <td>{!! number_format((float)($oprData->mife), 2) !!} mV</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- ch values table -->
                    <div class="row">
                        <h2 class="mt-3 mb-3 align-items-center d-flex"><i class="ri-table-2 me-2"
                                style="font-size: 24px; font-weight: 100;"></i> Parameter : Ch
                        </h2>
                        <div class="table-ar table-responsive">
                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th scope="col" style="text-align: left;">Date</th>
                                        <th scope="col">Maximum</th>
                                        <th scope="col">Average</th>
                                        <th scope="col">Minimum</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($chlrnValues as $chlrnData)
                                    <tr>
                                        <td style="text-align: left;">
                                            {{\Carbon\Carbon::parse($chlrnData->created_date)->format('d-m-Y')}}</td>
                                        <td>{!! number_format((float)($chlrnData->mxchlrn), 2) !!} mg/L</td>
                                        <td>{!! number_format((float)($chlrnData->midchlrn), 2) !!} mg/L</td>
                                        <td>{!! number_format((float)($chlrnData->michlrn), 2) !!} mg/L</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- tds values table -->
                    <div class="row">
                        <h2 class="mt-3 mb-3 align-items-center d-flex"><i class="ri-table-2 me-2"
                                style="font-size: 24px; font-weight: 100;"></i> Parameter : TDS
                        </h2>
                        <div class="table-ar table-responsive">
                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th scope="col" style="text-align: left;">Date </th>
                                        <th scope="col">Maximum </th>
                                        <th scope="col">Average</th>
                                        <th scope="col">Minimum</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($tdsValues as $tdsData)
                                    <tr>
                                        <td style="text-align: left;">
                                            {{\Carbon\Carbon::parse($tdsData->created_date)->format('d-m-Y')}}</td>
                                        <td>{!! number_format((float)($tdsData->mxtds), 2) !!} ppm</td>
                                        <td>{!! number_format((float)($tdsData->midtds), 2) !!} ppm</td>
                                        <td>{!! number_format((float)($tdsData->mitds), 2) !!} ppm</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- tur values table -->
                    <div class="row">
                        <h2 class="mt-3 mb-3 align-items-center d-flex"><i class="ri-table-2 me-2"
                                style="font-size: 24px; font-weight: 100;"></i> Parameter : TUR
                        </h2>
                        <div class="table-ar table-responsive">
                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th scope="col" style="text-align: left;">Date </th>
                                        <th scope="col">Maximum </th>
                                        <th scope="col">Average</th>
                                        <th scope="col">Minimum</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($turValues as $turData)
                                    <tr>
                                        <td style="text-align: left;">
                                            {{\Carbon\Carbon::parse($turData->created_date)->format('d-m-Y')}}</td>
                                        <td>{!! number_format((float)($turData->mxtur), 2) !!} NTU</td>
                                        <td>{!! number_format((float)($turData->midtur), 2) !!} NTU</td>
                                        <td>{!! number_format((float)($turData->mitur), 2) !!} NTU</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- water level table -->
                    <div class="row">
                        <h2 class="mt-3 mb-3 align-items-center d-flex"><i class="ri-table-2 me-2"
                                style="font-size: 24px; font-weight: 100;"></i> Parameter : Water Level
                        </h2>
                        <div class="table-ar table-responsive">
                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th scope="col" style="text-align: left;">Date </th>
                                        <th scope="col">Maximum </th>
                                        <th scope="col">Average</th>
                                        <th scope="col">Minimum</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($water_lvlValues as $water_lvlData)
                                    <tr>
                                        <td style="text-align: left;">
                                            {{\Carbon\Carbon::parse($water_lvlData->created_date)->format('d-m-Y')}}
                                        </td>
                                        <td>{!! number_format((float)($water_lvlData->mxwater_lvl), 2) !!} Ft</td>
                                        <td>{!! number_format((float)($water_lvlData->midwater_lvl), 2) !!} Ft</td>
                                        <td>{!! number_format((float)($water_lvlData->miwater_lvl), 2) !!} Ft</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- <footer class="footer">
          <small style="margin-bottom: 20px; display: inline-block">
            © 2022 made with
            <span style="color: red; font-size: 18px">&#10084;</span> by -
            <a target="_blank" href="#"> Mohamed Azouaoui </a>
          </small>
          <br />
          <div>
            <a href="#" target="_blank" rel="noopener noreferrer">
              <img alt="GitHub followers" src="#" />
            </a>
            <a href="#" target="_blank" rel="noopener noreferrer">
              <img alt="Twitter Follow" src="#" />
            </a>
          </div>
        </footer> -->
</main>
@endsection
@push('scripts')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<script>
$(function() {
    // Initialize datepickers with format dd-mm-yy
    $('#from_date_input, #to_date_input').datepicker({
        dateFormat: 'dd-mm-yy'
    });

    // Event handler for fromdate selection
    $('#device_purchased_on').on('change', function() {
        var fromDate = $(this).datepicker('getDate');

        // Set maxDate on todate (fromDate + 7 days)
        if (fromDate) {
            var maxDate = new Date(fromDate);
            maxDate.setDate(maxDate.getDate() + 29);

            $('#device_purchased_on').datepicker('option', 'minDate', fromDate);
            $('#device_purchased_on1').datepicker('option', 'maxDate', maxDate);
        }
    });

    // Event handler for todate selection
    $('#device_purchased_on1').on('change', function() {
        var fromDate = $('#fromdate').datepicker('getDate');
        var toDate = $(this).datepicker('getDate');

        if (fromDate && toDate) {
            var diffDays = (toDate - fromDate) / (1000 * 60 * 60 * 24); // Difference in days

            if (diffDays > 29) {
                alert('The date range cannot exceed 15 days.');
                $(this).val(''); // Reset todate value
            }
        }
    });
});
</script>
@endpush
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Get the elements
    var viewBy = document.getElementById('view_by');
    var tankWiseDiv = document.getElementById('tank_wise');
    var KPIWiseDiv = document.getElementById('KPI_wise');

    // Add event listener to the select element
    viewBy.addEventListener('change', function() {
        var selectedValue = this.value;

        // Reset both divs to hidden initially
        tankWiseDiv.style.display = 'none';
        KPIWiseDiv.style.display = 'none';

        // Show the relevant div based on the selected option
        if (selectedValue === '1') {
            tankWiseDiv.style.display = 'block'; // Show Tank Wise div
        } else if (selectedValue === '2') {
            KPIWiseDiv.style.display = 'block'; // Show KPI Wise div
        }
    });
});
</script>
</body>

</html>