@extends('layouts.main')

@section('content')
<main class="content">
    <div class="g-color"></div>
    <div class="position-relative">
        <div class="container-sec">
            <div class="cotainer-body p-4">
                <div class="page-hading">
                    @if(session()->has('message'))
                    <div class="alert alert-{{ session('status')}}" role="alert">
                        {{ session('message')}}
                    </div>
                    @endif
                    <div class="d-flex align-items-center justify-content-between">
                        <div class="d-flex align-items-center position-relative">
                            <a href="#" class="d-flex align-items-center me-4 mb-0">
                                <i class="ri-arrow-left-line"></i>Users List
                            </a>
                            <!--<div class="swich-btn">
                      <div class="switches-container">
                        <input type="radio" id="switchDatasheet" name="switchPlan" value="Datasheet"
                          checked="checked" />
                        <input type="radio" id="switchGraph" name="switchPlan" value="Graph" />
                        <label for="switchDatasheet">Datasheet</label>
                        <label for="switchGraph">Graph</label>
                        <div class="switch-wrapper">
                          <div class="switch">
                            <div>Datasheet</div>
                            <div>Graph</div>
                          </div>
                        </div>
                      </div>
                    </div>-->
                        </div>
                        <!-- @can('users-create')-->
                        <a href="{{ route('users.create') }}">
                            <div class="btn black-btn float-end"><i class="ri-add-box-line"></i>Add User</div>
                        </a>
                        <!-- @endcan-->
                    </div>
                </div>
                <div class="tank-wise-sec">
                    <!-- <h2 class="mt-3 mb-3 align-items-center d-flex"><i class="ri-calendar-2-line me-2"
                            style="font-size: 24px; font-weight: 100;"></i> Users List
                    </h2> -->
                    <div class="row">
                        <div class="table-ar table-responsive">
                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th scope="col">Name</th>
                                        <th scope="col">Email</th>
                                        <th scope="col">Role</th>
                                        <th scope="col">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($data as $key => $user)
                                    <tr>
                                        <td>{{ $user->name }}</td>
                                        <td>{{ $user->email }}</td>
                                        <td>
                                            @if(!empty($user->getRoleNames()))
                                            @foreach($user->getRoleNames() as $v)
                                            <label class="badge bg-success">{{ $v }}</label>
                                            @endforeach
                                            @endif
                                        </td>
                                        <td>
                                            <a href="{{ route('users.edit', $user->id) }}"
                                                class="btn btn-warning mb-1">Edit</a>
                                            <form action="{{ route('users.destroy', $user->id) }}" method="POST"
                                                style="display: inline-block;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-delete mb-1">Delete</button>
                                            </form>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</main>
@endsection
@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script type="text/javascript">
$(".btn-delete").click(function(e) {
    e.preventDefault();
    var form = $(this).parents("form");

    Swal.fire({
        title: "Are you sure to delete this user?",
        text: "You won't be able to revert this!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Yes, delete it!"
    }).then((result) => {
        if (result.isConfirmed) {
            form.submit();
        }
    });

});
</script>
@endpush