<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\WebController;
use App\Http\Controllers\TankMasterController;
use App\Http\Controllers\DeviceMasterController;
use App\Http\Controllers\PortalConfigSettingsController;
use App\Http\Controllers\WaterHealthMeasureController;
use App\Http\Controllers\DeviceTankMappingController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\CronController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\RegisteredUserController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\RoleController;

Route::get('/', function () {
	return redirect()->route('login');  // Redirect to the login route
});

/*Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');*/
Route::get('/dashboard', [WebController::class, 'userdashboard'])->middleware(['auth'])->name('dashboard');

Route::middleware('auth')->group(function () {
	// User Management
	Route::get('/register', [RegisteredUserController::class, 'create'])->name('register');
	Route::post('/register', [RegisteredUserController::class, 'store']);
	Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
	Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
	Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

	Route::get('/report/tankwisewaterturbudity', [WebController::class, 'tankwisewaterturbudity'])->name('watervsturb');
	Route::post('/report/tankwisewaterturbudity', [WebController::class, 'tankwisewaterturbudity'])->name('watervsturbChartReport');
	Route::get('/report/tankwisewaterturbreport/{id}', [WebController::class, 'tankwisewatervsturbreport'])->name('watervsturbReport');
	Route::get('/report/tankwisewaterturbexcel/{id}', [WebController::class, 'tankwisewatervsturbexcel'])->name('watervsturbExcel');
	Route::get('/report/outlier', [WebController::class, 'outlier'])->name('outlier');
	Route::post('/report/outlier', [WebController::class, 'outlier'])->name('outlierchart');
	Route::get('/report/comparative', [WebController::class, 'comparative'])->name('comparative');
	Route::post('/report/comparative', [WebController::class, 'comparative'])->name('comparativechart');
	Route::get('/report/phmonitor', [WebController::class, 'phlevelmonitor'])->name('phmonitor');
	Route::post('/report/phmonitor', [WebController::class, 'phlevelmonitor'])->name('phmonitorchart');
	Route::get('/report/outlierexcel/{data}', [WebController::class, 'outlierexcel'])->name('outlierexcel');
	Route::get('/report/detailedreport', [WebController::class, 'detailedtankwise'])->name('detailedreport');
	Route::post('/report/detailedreport', [WebController::class, 'detailedtankwise'])->name('detailedreportview');
	Route::get('/report/detailedreportchart/{id}', [WebController::class, 'detailedtankwisechart'])->name('detailedreportchart');
	Route::get('/report/detailedreportexcel/{id}', [WebController::class, 'detailedTankWiseExcel'])->name('detailedreportexcel');
	// Tank Management
	Route::get('/tank-master/create', [TankMasterController::class, 'addtank'])->name('addtank');
	Route::post('/tank-master/store', [TankMasterController::class, 'store'])->name('store_tank');
	Route::get('/tank-master/list', [TankMasterController::class, 'tankdetails'])->name('tankdetails');
	Route::get('/tank-master/edit/{id}', [TankMasterController::class, 'edit'])->name('tanks_edit');
	Route::post('/tank-master/update', [TankMasterController::class, 'update'])->name('tanks_update');
	Route::get('/tank-master/tankdata/{uid}', [TankMasterController::class, 'tankdata'])->name('tanks_data');
	Route::get('/tank-master/tankchart/{uid}', [TankMasterController::class, 'tankchart'])->name('tankchart');
	Route::get('/tank-master/tankdatahistory/{uid}', [TankMasterController::class, 'tankdatahistory'])->name('tanks_history');
	Route::get('/tank-master/tank-imei-check/', [TankMasterController::class, 'tank_imei_check'])->name('tank_imei_check');
	// Device Management
	Route::get('/device-master/create', [DeviceMasterController::class, 'create'])->name('adddevice');
	Route::post('/device-master/store', [DeviceMasterController::class, 'store'])->name('store_device');
	Route::get('/device-master/list', [DeviceMasterController::class, 'show'])->name('devicedetails');
	Route::get('/device-master/edit/{id}', [DeviceMasterController::class, 'edit'])->name('device_edit');
	Route::post('/device-master/update', [DeviceMasterController::class, 'update'])->name('device_update');
	// Portal Config Settings Management
	Route::get('/portal-config-settings/create', [PortalConfigSettingsController::class, 'create'])->name('add_config');
	Route::post('/portal-config-settings/store', [PortalConfigSettingsController::class, 'store'])->name('save_config');
	Route::get('/portal-config-settings/index', [PortalConfigSettingsController::class, 'index'])->name('list_config');
	Route::get('/portal-config-settings/edit/{alpha_id}', [PortalConfigSettingsController::class, 'edit'])->name('edit_config');
	Route::post('/portal-config-settings/update', [PortalConfigSettingsController::class, 'update'])->name('update_config');
	// Water Health Measure Settings
	Route::get('/water-health-measures/create', [WaterHealthMeasureController::class, 'create'])->name('add_measure');
	Route::post('/water-health-measures/store', [WaterHealthMeasureController::class, 'store'])->name('save_measure');
	Route::get('/water-health-measures/index', [WaterHealthMeasureController::class, 'index'])->name('list_measure');
	Route::get('/water-health-measures/edit/{alpha_id}', [WaterHealthMeasureController::class, 'edit'])->name('edit_measure');
	Route::post('/water-health-measures/update', [WaterHealthMeasureController::class, 'update'])->name('update_measaure');
	// Tank Device Mapping Management
	Route::get('/device-mapping/create', [DeviceTankMappingController::class, 'create'])->name('addmapping');
	Route::post('/device-mapping/store', [DeviceTankMappingController::class, 'store'])->name('store_mapping');
	Route::get('/device-mapping/list', [DeviceTankMappingController::class, 'show'])->name('mappingdetails');
	Route::get('/device-mapping/edit/{id}', [DeviceTankMappingController::class, 'edit'])->name('mapping_edit');
	Route::post('/device-mapping/update', [DeviceTankMappingController::class, 'update'])->name('mapping_update');
	// Report
	Route::get('/report/selectrange', [ReportController::class, 'index'])->name('selectrange');
	Route::post('/report/tankDateReport', [ReportController::class, 'tankDateReport'])->name('tankDateReport');
	Route::get('/report/daterangechart/{id}', [ReportController::class, 'daterangechart'])->name('daterangechartview');
	Route::get('/report/tankwisechart/{id}', [ReportController::class, 'tankwisechart'])->name('tankwisechart');
	Route::get('/report/tankwiserange', [ReportController::class, 'tankwiserange'])->name('tankwiserange');
	Route::post('/report/tankwiserange', [ReportController::class, 'tankwiserange'])->name('tankwiseChartReport');
	Route::get('/report/tankwisexcel/{id}', [ReportController::class, 'excelTankWiseData'])->name('tankwisexcel');
	Route::get('/report/daterangexcel/{id}', [ReportController::class, 'excelDateRangeData'])->name('daterangexcel');
	Route::get('/report/dailysummary', [ReportController::class, 'dailyTankData'])->name('dailysummary');
	Route::post('/report/dailysummary', [ReportController::class, 'dailyTankData'])->name('tanksummary');
	Route::get('/report/dailysummarychart/{id}', [ReportController::class, 'dailyTankChart'])->name('dailytankchart');
	Route::get('/report/dailysummaryexcel/{id}', [ReportController::class, 'excelDailyTank'])->name('dailysummaryexcel');
	// Manage User profiles
	Route::get('/users', [UserController::class, 'index'])->name('users.list');
	Route::get('/users/create', [UserController::class, 'create'])->name('users.create');
	Route::post('/users', [UserController::class, 'store'])->name('users.store');
	Route::get('/users/edit/{user}', [UserController::class, 'edit'])->name('users.edit');
	Route::put('/users/{user}', [UserController::class, 'update'])->name('users.update');
	Route::delete('/users/{user}', [UserController::class, 'destroy'])->name('users.destroy');
	// Manage User roles
	//Route::resource('roles', RoleController::class);
	Route::get('/roles', [RoleController::class, 'index'])->name('roles.index');
	Route::get('/roles/create', [RoleController::class, 'create'])->name('roles.create');
	Route::post('/roles', [RoleController::class, 'store'])->name('roles.store');
	Route::get('/roles/edit/{role}', [RoleController::class, 'edit'])->name('roles.edit');
	Route::put('/roles/{role}', [RoleController::class, 'update'])->name('roles.update');
	Route::delete('/roles/{role}', [RoleController::class, 'destroy'])->name('roles.destroy');
});

// Corn Management
Route::get('/run-water-cron', [CronController::class, 'fetchWaterData']);
Route::get('/webhook_payload', [CronController::class, 'webhookpayload']);

require __DIR__ . '/auth.php';
