

<?php $__env->startSection('content'); ?>
<main class="content">
    <div class="g-color"></div>
    <div class="table-header position-relative">
        <div class="row justify-content-between ">
        </div>
        <div class="row justify-content-between">
            <form class="hd-date-input mt-5" action="<?php echo e(route('watervsturbChartReport')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="col-md-12">
                    <ul class="d-flex align-items-center p-0">
                        <li class="">
                            <div class="date-input d-flex align-items-center position-relative"><b class="me-3">Date
                                    From:</b>
                                <input class="form-control w-50" type="text" name="fromdate"
                                    value="<?php echo date('d-m-Y', strtotime($fdate)); ?>" id="device_purchased_on"
                                    autocomplete="off">
                                <i class="ri-calendar-2-line"></i>
                            </div>
                        </li>
                        <li class="">
                            <div class=" date-input d-flex align-items-center position-relative"><b class="me-2">To
                                    :</b>
                                <input class="form-control w-75" type="text" name="todate"
                                    value="<?php echo date('d-m-Y', strtotime($tdate)); ?>" id="device_purchased_on1"
                                    autocomplete="off">
                                <i class="ri-calendar-2-line"></i>
                            </div>
                        </li>
                        <li class="">
                            <div class="d-flex align-items-center position-relative"><b class="me-3">Select Tank:</b>
                                <select class="form-select w-75" name="tank_list" id="tank_list"
                                    aria-label="Default select example">
                                    <option value="">Select Tank</option>
                                    <?php $__currentLoopData = $tanks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($tank->id); ?>" <?php if ($tname == $tank->id){ ?> Selected
                                        <?php } ?>><?php echo e($tank->tank_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <input type="hidden" name="sval" value="1" />
                            </div>
                        </li>
                        <li class="">
                            <div class="btn-sec m-2">
                                <button type="submit" class="btn btn-primary"
                                    onClick="return validation();">Submit</button>
                            </div>
                        </li>
                    </ul>
                </div>
            </form>
        </div>
    </div>
    <div class="position-relative">
        <div class="container-sec">
            <div class="cotainer-body p-4">
                <div class="page-hading">
                    <div class="d-flex align-items-center justify-content-between d-sm-block d-md-flex">
                        <h2>Water Level vs Turbidity</h2>
                        <div class="detasheet-graph-icon ms-auto">
                            <a href="#" class="active">Graph</a>
                            <a href="<?php echo e(route('watervsturbReport',$encData)); ?>" class="">Datasheet</a>
                        </div>
                        <form method="get" action="<?php echo e(route('watervsturbExcel',$encData)); ?>">
                            <button class="btn download-btn ms-2"><i class="ri-folder-download-fill"></i>
                                Download</button>
                        </form>
                    </div>
                </div>
                <div class="row row-spacing">
                    <div class="col-md-12">&nbsp;</div>
                </div>

                <div class="add-tank">

                    <div class="row">
                        <div class="col-md-12">
                            <div id="container">

                            </div>
                        </div>
                    </div>
                    <div class="row row-spacing">
                        <div class="col-md-12">&nbsp;</div>
                    </div>
                    <!--<div class="row">
					<div class="col-md-12">						
                    <div id="container02">
					
					</div>
					</div>							                  
                 </div>-->
                </div>

            </div>
        </div>
    </div>


</main>

<?php $__env->stopSection(); ?>

<script src="https://code.highcharts.com/highcharts.js"></script>
<script src="https://code.highcharts.com/modules/accessibility.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Prepare data for the chart
    var data = <?php echo json_encode($data); ?>;

    // Create a list for x-axis categories (read_date and read_hour)
    var xAxisCategories = [];
    var seriesData = [];

    // Function to format the date and hour as d-m-Y H:i
    function formatDateTime(date, hour) {
        var parts = date.split('-'); // Split the date into components (Y, m, d)
        return parts[2] + '-' + parts[1] + '-' + parts[0] + ' ' + hour + ':00'; // Format as d-m-Y H:i
    }

    // Prepare series data and x-axis labels
    data.forEach(function(item, index) {
        if (item.wtrval && item.turval) { // Only include entries with water levels and turbidity values
            var dateHourLabel = formatDateTime(item.read_date, item.read_hour); // Format date and hour
            xAxisCategories.push(dateHourLabel); // Push the formatted label to x-axis categories

            // Push index for x-axis and turbidity value for y-axis
            seriesData.push([index, parseFloat(item.turval)]);
        }
    });

    Highcharts.chart('container', {
        chart: {
            type: 'scatter', // Set chart type to scatter plot
            zoomType: 'xy' // Enable zoom on both x and y axes
        },
        title: {
            text: 'Turbidity vs Time (Water Level)'
        },
        xAxis: {
            title: {
                text: 'Date and Hour'
            },
            categories: xAxisCategories, // Use the formatted date/hour categories for x-axis
            labels: {
                rotation: -45, // Rotate labels for better readability
                align: 'right'
            }
        },
        yAxis: {
            title: {
                text: 'Turbidity'
            }
        },
        series: [{
            name: 'Turbidity Data',
            data: seriesData, // [index, turbidity] pairs
            marker: {
                radius: 5,
                symbol: 'circle'
            },
            color: '#7cb5ec' // Light blue color for the markers
        }],
        plotOptions: {
            scatter: {
                marker: {
                    radius: 5,
                    states: {
                        hover: {
                            enabled: true,
                            lineColor: 'rgb(100,100,100)'
                        }
                    }
                },
                states: {
                    hover: {
                        marker: {
                            enabled: false
                        }
                    }
                },
                tooltip: {
                    headerFormat: '<b>{point.key}</b><br>',
                    pointFormat: 'Water Level: {point.x}, Turbidity: {point.y:.2f}' // Display the index (x-axis category) and turbidity value
                }
            }
        }
    });
});
</script>
<script>
// Prepare data for the chart
var ndata = <?php echo json_encode($data); ?>;

// Extract water levels (wtrval) and turbidity (turval)
var categories = [];
var seriesDatas = [];

ndata.forEach(function(item) {
    if (item.wtrval && item.turval) { // Only include entries with water levels and turbidity values
        categories.push(item.wtrval); // Push water level to x-axis categories
        seriesDatas.push(parseFloat(item.turval)); // Push turbidity to y-axis series
    }
});

// Create the chart
document.addEventListener('DOMContentLoaded', function() {
    Highcharts.chart('container02', {
        chart: {
            type: 'line' // Change to 'line' for a line chart
        },
        title: {
            text: 'Water Level vs Turbidity'
        },
        xAxis: {
            categories: categories, // Water levels on the x-axis
            title: {
                text: 'Water Level'
            }
        },
        yAxis: {
            title: {
                text: 'Turbidity'
            }
        },
        series: [{
            name: 'Turbidity',
            data: seriesDatas, // Turbidity values on the y-axis
            color: '#7cb5ec' // Set line color to light blue
        }]
    });
});
</script>

<?php $__env->startPush('scripts'); ?>
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<script>
$(function() {
    $("#device_purchased_on").datepicker({
        dateFormat: 'dd-mm-yy' // Example format
    });
});

$(function() {
    $("#device_purchased_on1").datepicker({
        dateFormat: 'dd-mm-yy' // Example format
    });
});
</script>
<?php $__env->stopPush(); ?>

<script>
function validation() {
    if (document.getElementById('device_purchased_on').value == "") {
        $('#error-fdt').html('* From Date Is Required');
        $('#error-fdt').css('color', 'red');
        $('#device_purchased_on').focus();
        return false;
    }
    if (document.getElementById('device_purchased_on1').value == "") {
        $('#error-tdt').html('* To Date Is Required');
        $('#error-tdt').css('color', 'red');
        $('#device_purchased_on1').focus();
        return false;
    }

    if (document.getElementById('tank_list').value == "") {
        $('#error-tl').html('* Select A Tank');
        $('#error-tl').css('color', 'red');
        $('#tank_list').focus();
        return false;
    }

    return true;
}
</script>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/asansolphe/dev/resources/views/report/watervsturbchartview.blade.php ENDPATH**/ ?>