<?php
ini_set("display_errors", 1);
ini_set("display_startup_errors", 1);
error_reporting(0);

require_once "config/config.php";
require_once "config/dbconfig.php";
require_once "config/database.php";
require_once "utility/file_handler.php";

/* End Validation */
// =========================================================
// create/update log

$logdir = "$logEventDir";
$logdir .= "/" . date("Y");
log_folder_create($logdir);
$logdir .= "/" . date("m");
log_folder_create($logdir);
$logdir .= "/" . date("d");
log_folder_create($logdir);

date_default_timezone_set('Asia/Kolkata');
$date = new DateTime();
$file_name = "pheAsansol-" . $date->format("d-m-Y-H-i-s") . ".log";
$myFile = $logdir . "/" . $file_name;

//$prmStr = file_get_contents("php://input");
$prmStr = $_REQUEST['key'];


if ($prmStr == 'working_alive') {
    http_response_code(200);
    exit;
} else if (strpos($prmStr, '|') !== false) {
    $inputStr = find_between_dollars($prmStr);
    $jsonStr = explode("|", $inputStr);
    $data["packet_type"] = $jsonStr[0];
    $data["tank_gateway"] = $jsonStr[1];
    if ($jsonStr[0] == 'WAT' && $jsonStr[2] != null && $jsonStr[4] != null && $jsonStr[6] != null && $jsonStr[8] != null && $jsonStr[10] != null && $jsonStr[12] != null && $jsonStr[14] != null) {
        $data[$jsonStr[2]] = $jsonStr[3];
        $data[$jsonStr[4]] = $jsonStr[5];
        $data[$jsonStr[6]] = $jsonStr[7];
        $data[$jsonStr[8]] = $jsonStr[9];
        $data[$jsonStr[10]] = $jsonStr[11];
        $data[$jsonStr[12]] = $jsonStr[13];
        $data['epoch'] = $jsonStr[14];
    } else if ($jsonStr[0] == 'LVL' && $jsonStr[2] != null && $jsonStr[4] != null) {
        $data[$jsonStr[2]] = $jsonStr[3];
        $data['epoch'] = $jsonStr[4];
    } else {
        echo "Invalid Data";
        http_response_code(400);
        exit;
    }
} else {
    echo "Invalid Input";
    http_response_code(400);
    exit;
}



//$data_file_name = "tank_" . $data["tank_gateway"] . ".json";
//$tankDataFile = $tankInfoDir . "/" . $data_file_name;
//$tankInfoStr = '{"tank": {"uid":' . $data["tank_gateway"] . ',"status":1,"devices":{}}}';
//$tankData = json_decode($tankInfoStr);
//echo $tankDataFile;
//$fcheck = file_path_check($tankDataFile);
//$tankData = json_decode(trim($fcheck), true);
//$tankUid = $tankData['tank_uid'];
//$tank_id = $tankData['tank_id'];
@$tankData = gateway_tank_check($data["tank_gateway"]);

//VALIDATING TANK UNIQUE ID
if ($tankData != NULL) {
    $reading_table = $tankData['reading_table'];
    $tank_id = $tankData['tank_id'];
    $stringData = "";
    $stringData .= "Time:" . gmdate("Y-m-d H:i:s") . "\n";
    $stringData .= "---------------------------------------------------" . "\n";
    $stringData .= "phe_webhook_request_received_tank_data" . "\n";
    $stringData .= "---------------------------------------------------" . "\n";
    $stringData .= "$inputStr";
    `echo "$stringData" > $myFile`;
    `chmod 760 $myFile`;
    // create/update log
    // var_dump($data);
    // die;
    $dbobj = new Database();
	$currtime =  date('Y-m-d H:i:s');
	//entry the whole packet
		$pkt_insert = $dbobj->executeQuery("INSERT INTO whole_data_packet (`data_packet`,`c_date`)VALUES('" . $prmStr . "','" . $currtime . "')");
	//end the packet entry    
    if ($data["packet_type"] == "WAT") {
        //CL data insert
		//$data['CL']
		if($data['CL']){
		$cal_ch = $data['CL']/100;
        $cl_insert = $dbobj->executeQuery("INSERT INTO " . $reading_table . " (`payload_id`,`tank_id`,`device_id`,`reading_value`,`payload_type`,`chlrn`,`chlrn_unit`,`created_at`,`created_by`)VALUES('" . $data['tank_gateway'] . "', " . $tank_id . ", 1, " . $data['CL'] . ",'" . $data['packet_type'] . "'," . $cal_ch . ",'mg/L','" . $currtime . "',1)");
		}
        //TDS data insert
        $tds_insert = $dbobj->executeQuery("INSERT INTO " . $reading_table . " (`payload_id`,`tank_id`,`device_id`,`reading_value`,`payload_type`,`tds`,`tds_unit`,`created_at`,`created_by`)VALUES('" . $data['tank_gateway'] . "', " . $tank_id . ", 4, " . $data['TDS'] . ",'" . $data['packet_type'] . "'," . $data['TDS'] . ",'mg/L','" . $currtime . "',1)");
        //PH data insert
		if($data['PH']){
		$phmv = $data['PH'];
		$phv = $data['PH'] / 1000;
		$calph = $phv * 2.8; // 5v = 14ph = 2.8
        $ph_insert = $dbobj->executeQuery("INSERT INTO " . $reading_table . " (`payload_id`,`tank_id`,`device_id`,`reading_value`,`payload_type`,`ph`,`ph_unit`,`created_at`,`created_by`)VALUES('" . $data['tank_gateway'] . "', " . $tank_id . ", 2, " . $data['PH'] . ",'" . $data['packet_type'] . "'," . $data['PH'] . ",'','" . $currtime . "',1)");
		}
        //TUR data insert
		/*$min = 1.5;
		$max = 1.8;
		$tur_ran_data = $min + mt_rand() / mt_getrandmax() * ($max - $min);*/
		if($data['TUR']){
		$tur_ran_data = $data['TUR']/1000;
        $tur_insert = $dbobj->executeQuery("INSERT INTO " . $reading_table . " (`payload_id`,`tank_id`,`device_id`,`reading_value`,`payload_type`,`tur`,`tur_unit`,`created_at`,`created_by`)VALUES('" . $data['tank_gateway'] . "', " . $tank_id . ", 5, " . $data['TUR'] . ",'" . $data['packet_type'] . "'," . $tur_ran_data . ",'NTU','" . $currtime . "',1)");
		}
        //TEMP data insert
        if ($data['TEMP'] != 0 || $data['TEMP'] != '') {
            $celsius_temp = $data['TEMP'];
            $kelvin_temp = ($data['TEMP'] + 273.15);
            $temp_insert = $dbobj->executeQuery("INSERT INTO tank_temp_readings (`payload_id`,`tank_id`,`device_id`,`reading_value`,`payload_type`,`celsius_temp`,`kelvin_temp`,`created_at`,`created_by`)VALUES('" . $data['tank_gateway'] . "', " . $tank_id . ", 6, " . $data['TEMP'] . ",'" . $data['packet_type'] . "'," . $celsius_temp . ", " . $kelvin_temp . ",'" . $currtime . "',1)");
        }
        //OPR/Fe data insert
        //$temp_query = "SELECT `kelvin_temp`,`celsius_temp` FROM tank_temp_readings WHERE `payload_id` IN(SELECT GROUP_CONCAT(VALUE SEPARATOR  ',') FROM portal_config_settings WHERE `value` IN(4, 5))ORDER BY created_at DESC LIMIT 1";
        $temp_query = "SELECT `kelvin_temp`,`celsius_temp` FROM tank_temp_readings ORDER BY created_at DESC LIMIT 1";
        $tempData = $dbobj->executeQuery($temp_query);
        $tempRow = $tempData->fetch_assoc();
        $tempCel = $tempRow['celsius_temp'];

        if ($data['OPR'] != 0) {
            $ironVal = get_Water_Fe_ratio($data['OPR'], $tempRow['kelvin_temp']);
        } else $ironVal = "NULL";

        $opr_insert = $dbobj->executeQuery("INSERT INTO " . $reading_table . " (`payload_id`,`tank_id`,`device_id`,`reading_value`,`payload_type`,`opr`,`opr_unit`,`iron_lvl`,`iron_lv_unit`,`temp`,`created_at`,`created_by`)VALUES('" . $data['tank_gateway'] . "', " . $tank_id . ", 3, " . $data['OPR'] . ",'" . $data['packet_type'] . "'," . $data['OPR'] . ",'mV'," . $ironVal . ", 'mg/L'," . $tempCel . ",'" . $currtime . "',1)");
        $data['FE'] = $ironVal;
    }
    if ($data["packet_type"] == "LVL") {
        //LVL data insert 1meter = 3.28 feet
        $water_feet = 2 + $data['LVL'];
        $lvl_insert = $dbobj->executeQuery("INSERT INTO " . $reading_table . " (`payload_id`,`tank_id`,`device_id`,`reading_value`,`payload_type`,`water_lvl`,`water_lvl_unit`,`created_at`,`created_by`)VALUES('" . $data['tank_gateway'] . "', " . $tank_id . ", 7, " . $data['LVL'] . ",'" . $data['packet_type'] . "'," . $water_feet . ",'ft','" . $currtime . "',1)");
    }
    $data['tank_name'] = $tankData['tank_name'];
    check_tank_data($data);
    http_response_code(200);
    //echo $stringData;
    echo 'success';
} else {
    /*
    log_folder_create($logdir);
    `echo "$tankInfoStr" > $myFile`;
    `chmod 760 $myFile`;
    */
    echo 'Data record error: No tank with the name';
    http_response_code(400);
    exit;
}
