// "use client";

import AOS from "aos";
import "aos/dist/aos.css";
import Breadcrumb from "@/app/components/common/Breadcrumb";

import AboutSection from "@/app/components/home/AboutSection";

import LogoSlider from "@/app/components/home/LogoSlider";
import Image from "next/image";
import AboutBanner from "@/app/components/about/aboutbanner";
import ExpandableText from "@/app/components/common/ExpandableText";
import AboutCustomerRate from "@/app/components/home/CustomarRate";
import AwardsTimeline from "@/app/components/about/AwardsTimeline";
import CholanToursComponent from "@/app/components/about/CholanToursComponent";
import LifeAtCholanToursComponent from "@/app/components/about/LifeAtCholanToursComponent";
import EmployeeCard from "@/app/components/about/team";
import { fetchPackageReviewData } from "@/app/services/reveiwService";
import CustomerRate from "@/app/components/about/AboutCustomarRate";
import { fetchAboutPageData } from "@/app/services/aboutServices";
import { getCanonical } from "@/app/lib/getCanonical";
import ReviewsWidget from "@/app/components/ReviewsWidget";

export async function generateMetadata({ params }: any) {
  const data = await fetchAboutPageData();

  const meta = data?.data?.details?.meta || {};
  const canonical = await getCanonical("/about-us");
  const currentUrl = canonical;

  // Extract the meta_details from API
  const metaDetails = meta.meta_details || "";

  return {
    title: meta?.meta_title || "cholan tours",
    description: meta?.meta_description || "cholan tours",
    keywords: meta.meta_keywords || "",
    alternates: { canonical },

    openGraph: {
      title: meta?.meta_title || "cholan tours",
      url: currentUrl,
      description: meta?.meta_description || "cholan tours",
    },

    twitter: {
      title: meta?.meta_title || "cholan tours",
      url: currentUrl,
      description: meta?.meta_description || "cholan tours",
    },
  };
}

const staticBreadcrumbItems = [
  { label: "Home", href: "/" },
  { label: "About Us", isCurrent: true },
];

export default async function AboutUs() {
  const data = await fetchAboutPageData();

  const [packageReviewData] = await Promise.all([fetchPackageReviewData()]);

  return (
    <div className="aboutus-wrapper">
      <AboutBanner bannerData={data?.data?.details} />
      <div className="pt-4 pb-5">
        <div className="container">
          <Breadcrumb items={staticBreadcrumbItems} />
          <section className="pb-5 pt-2">
            <div>
              {/* <h1 className="mb-2 fs-2">{`${data?.data?.details?.title} ${data?.data?.details?.title == "About Cholan Tours" ? "" : "Tour Packages"}`}</h1> */}

              {data?.data?.details?.short_description && (
                <div
                  className="row gap-4 gap-lg-0"
                  dangerouslySetInnerHTML={{
                    __html: data?.data?.details?.short_description || "",
                  }}
                />
              )}

              {/* <div className="col-lg-7">
                <ExpandableText
                  title={data?.data?.details?.title}
                  text={data?.data?.details?.short_description}
                  collapsedLines={4}
                />
              </div> */}
              {/* <div className="col-lg-5">
                <Image
                  src="/images/cholantours.webp"
                  alt="img"
                  width={400}
                  height={350}
                  loading="lazy"
                  className="w-100 rounded-4 object-cover"
                />
              </div> */}
            </div>
          </section>
        </div>
        <LifeAtCholanToursComponent
          data={data?.data?.details?.description}
          title={data?.data?.details?.title}
        />
        {/* <EmployeeCard /> */}
        {/* <div className="about-us-rate rating">
          {packageReviewData?.data && (
            <CustomerRate reviews={packageReviewData.data} />
          )}
        </div> */}

        
          <ReviewsWidget />
        

        {/* <AboutSection /> */}
        <div className="pt-5">
          <LogoSlider />
        </div>
      </div>
    </div>
  );
}
