// src/app/components/home/TopService.tsx
"use client";
import React, { useEffect, useState } from "react";
import Image from "next/image";
import Link from "next/link";
import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Pagination } from "swiper/modules";
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";

interface TourService {
  title: string;
  banner_image?: string;
  banner_image_alt?: string;
  link: string;
}

interface TopServiceProps {
  tourServices: TourService[];
}

const TopService: React.FC<TopServiceProps> = ({ tourServices }) => {
  const [jsEnabled, setJsEnabled] = useState(false);
  useEffect(() => {
    // ✅ Detect JS enabled
    setJsEnabled(true);
  }, []);

  if (!tourServices || tourServices.length === 0) return null;

  return (
    <section className="top-services common-padd py-16 bg-gray-50 make-hide">
      <div className="container mx-auto px-4">
        {/* Section Header */}
        <div className="common-header-center text-center mb-12">
          <h2 className="text-3xl font-bold text-gray-800">Tour Services</h2>
          <p className="mt-4 max-w-2xl mx-auto">
            We Provide Car & Bus Rental Services, Luxury Trains and Hotels as
            these are very important for us. The Tailor-made specialists in
            offering customised tour packages for you.
          </p>
        </div>

        {/* Always render Swiper for SSR compatibility */}
        {jsEnabled ? (
          <div className="discover-wraper">
            <Swiper
              key="top-services-swiper"  // Stable key for re-mounts
              modules={[Navigation, Pagination]}
              spaceBetween={30}
              slidesPerView={4}
              navigation
              pagination={{ clickable: true }}
              breakpoints={{
                320: { slidesPerView: 1 },
                640: { slidesPerView: 2 },
                1024: { slidesPerView: 4 },
              }}
              className="mySwiper"
            >
              {tourServices.map((data: TourService) => (
                <SwiperSlide key={data.title}>
                  <Link href={data.link}>
                    <div className="sngl-box bg-white rounded-lg overflow-hidden custom-hover">
                      <Image
                        width={300}
                        height={400}
                        sizes="100vw"
                        src={data.banner_image || "/images/no-img.webp"}
                        alt={data.banner_image_alt || "Service Image"}
                        className="w-full h-64 object-cover"
                      />
                      <div className="content-box-wraper p-3 flex justify-between items-center">
                        <h5 className="text-lg font-semibold text-gray-800">
                          {data.title}
                        </h5>
                        <div className="img-inc">
                          <Image
                            width={23}
                            height={23}
                            sizes="100vw"
                            src="/images/button-arrow.png"
                            alt="Arrow Icon"
                            className="hover:scale-110 transition-transform"
                          />
                        </div>
                      </div>
                    </div>
                  </Link>
                </SwiperSlide>
              ))}
            </Swiper>
          </div>
        ) : (
          <div className="discover-wraper js-disabled mt-0 pt-15px pb-15px">
            <div className="noscript-grid mt-4">
              {tourServices.slice(0, 4).map((data: TourService) => (
                <a key={data.title} href={data.link} className="">
                    <div className="sngl-box bg-white rounded-lg overflow-hidden custom-hover">
                      <Image
                        width={300}
                        height={400}
                        sizes="100vw"
                        src={data.banner_image || "/images/no-img.webp"}
                        alt={data.banner_image_alt || "Service Image"}
                        className="w-full h-64 object-cover"
                      />

                      <div className="content-box-wraper p-3 flex justify-between items-center">
                        <h5 className="text-lg font-semibold text-gray-800">
                          {data.title}
                        </h5>
                        <div className="img-inc">
                          <Image
                            width={23}
                            height={23}
                            sizes="100vw"
                            src="/images/button-arrow.png"
                            alt="Arrow Icon"
                            className="hover:scale-110 transition-transform"
                          />
                        </div>
                      </div>
                    </div>
                  </a>
                // <div
                //   key={data.title}
                //   className="sngl-box bg-white rounded-lg overflow-hidden custom-hover"
                // >
                //   <a href={data.link}>
                //     <img
                //       src={data.banner_image || "/images/no-img.webp"}
                //       alt={data.banner_image_alt || "Service Image"}
                //       className="w-full h-64 object-cover"
                //     />
                //   </a>

                //   <div className="content-box-wraper p-4 flex justify-between items-center">
                //     <a href={data.link}>
                //       <h5 className="text-lg font-semibold text-gray-800">
                //         {data.title}
                //       </h5>
                //     </a>

                //     <a href={data.link}>
                //       <img
                //         width={23}
                //         height={23}
                //         src="/images/button-arrow.png"
                //         alt="Arrow Icon"
                //       />
                //     </a>
                //   </div>
                // </div>
              ))}
            </div>
          </div>
        )}
        

      </div>
    </section>
  );
};

export default TopService;