"use client";
import Banner from "@/app/components/common/banner";
import Breadcrumb from "@/app/components/common/Breadcrumb";
import FAQAccordion from "@/app/components/common/FAQAccordion";
import FAQAccordionListing from "@/app/components/common/FAQAccordionForListing";
import TrainExpandableText from "@/app/components/train/ExpandableText";
import HeritageCard from "@/app/components/train/HeritageCard";
import TrainCard from "@/app/components/train/TrainCard";



export default function TrainOverview() {

    const breadcrumbItems = [
        { label: 'Home', href: '/' },
        { label: 'Tour', href: '/' },
        { label: 'Kashmir Tour Package', isCurrent: true },
    ];

    return (

        <div className="train-wrapper">
            <Banner />
            <div
                className="pt-5 train-wrapper-iiner"
                data-aos="fade-up"
                data-aos-delay="300"
            >
                <div className="container">
                    <Breadcrumb items={breadcrumbItems} />
                    <div className="flex flex-col gap-4 mb-4">
                        <div className="train-overview-para">
                            <h2 className="mb-2">Maharaja Express Overview </h2>
                            <p className="text-sm">The Maharajas’ Express is India’s most luxurious train, often compared to a five-star hotel on wheels. Renowned for its lavish interiors, world-class hospitality, and curated experiences, it offers a royal journey through India’s most iconic destinations. Guests can indulge in fine dining, spacious suites, and personalized service while exploring forts, palaces, and cultural wonders. With routes like the “Heritage of India” and “Treasures of India,” it truly redefines luxury travel. A ride on the Maharajas’ Express is not just a journey—it’s a royal experience of a lifetime.</p>
                        </div>
                        <div className="train-ex-para">
                            <h3 className="mb-2">About the Train</h3>
                            <TrainExpandableText />
                        </div>
                    </div>
                </div>


                <div className="train-journey-wrap py-5">
                    <div className="container">
                        <div className="flex flex-col gap-4">
                            <div className="">
                                <h2 className="mb-4 text-primary text-center font-semibold">Maharajas Express Journey</h2>
                                <div className="row">
                                    <div className="col-lg-3">
                                        <HeritageCard />
                                    </div>
                                    <div className="col-lg-3">
                                        <HeritageCard />
                                    </div>
                                    <div className="col-lg-3">
                                        <HeritageCard />
                                    </div>
                                    <div className="col-lg-3">
                                        <HeritageCard />
                                    </div>
                                </div>
                            </div>
                            <div className="train-overview-para">
                                <h2 className="mb-2">Maharaja Express Destinations</h2>
                                <p className="text-sm">The Maharaja Express takes you on an unforgettable journey through India’s most iconic destinations. From the regal forts and palaces of Rajasthan to the eternal beauty of the Taj Mahal in Agra, every stop is steeped in history and grandeur. Discover the cultural richness of Jaipur, the wilderness of Ranthambore, and the sacred ghats of Varanasi. The train also traverses vibrant cities like Delhi and Mumbai, offering a perfect blend of heritage and modern charm. Each destination has been carefully chosen to give travelers a true taste of India’s royal legacy and diverse traditions.</p>
                            </div>
                            <div className="train-ex-para">
                                <h3 className="mb-2">Maharaja Express Facilities</h3>
                                <TrainExpandableText />
                            </div>
                        </div>
                    </div>
                </div>
                <div className="faqs pb-5">
                    <div className="container">
                        <FAQAccordion faqs={[]} />
                    </div>
                </div>

                <div className="py-5 lux-trains">
                    <div className="container">
                            <h2 className="mb-4 text-black text-center font-semibold">More Luxury Hotels</h2> 
                            <div className="row">
                                <div className="col-lg-4">
                                    <TrainCard />
                                </div>
                                <div className="col-lg-4">
                                    <TrainCard />
                                </div>
                                <div className="col-lg-4">
                                    <TrainCard />
                                </div>
                            </div>
                    </div>
                </div>
            </div>
        </div>





    );
}