'use client';

import React, { useState, useEffect } from 'react';
import Image from 'next/image';
import flatpickr from 'flatpickr';

import 'flatpickr/dist/themes/material_orange.css'; 

const EnquiryForm = ({ title = "Kashmir Tour | Heaven On Earth" }) => {
    const [formData, setFormData] = useState({
        name: '',
        email: '',
        phone: '',
        travelDate: '',
        people: '',
        message: ''
    });

    const handleChange = (e) => {
        const { name, value } = e.target;
        setFormData({ ...formData, [name]: value });
    };

    const handleSubmit = (e) => {
        e.preventDefault();
        console.log('Form submitted:', formData);
    };

    useEffect(() => {
        const fp = flatpickr('.date-input', {
            dateFormat: 'd-m-Y',
            monthSelectorType: 'dropdown', 
            onChange: (selectedDates, dateStr) => {
                setFormData((prev) => ({ ...prev, travelDate: dateStr }));
            }
        });

        return () => fp.destroy();
    }, []);

    return (
        <div className="tourCard mb-4 shadow-sm p-3 p-lg-4">
            <h5 className="mb-0">{title}</h5>
            <form onSubmit={handleSubmit} className="mt-4">

                {/* Name */}
                <div className="form-floating mb-3">
                    <input
                        type="text"
                        name="name"
                        value={formData.name}
                        onChange={handleChange}
                        className="form-control"
                        id="floatingName"
                        placeholder="Name"
                        required
                    />
                    <label htmlFor="floatingName">Name*</label>
                </div>

                {/* Email */}
                <div className="form-floating mb-3">
                    <input
                        type="email"
                        name="email"
                        value={formData.email}
                        onChange={handleChange}
                        className="form-control"
                        id="floatingEmail"
                        placeholder="Email"
                        required
                    />
                    <label htmlFor="floatingEmail">Email*</label>
                </div>

                {/* Phone */}
                <div className="form-floating mb-3">
                    <input
                        type="tel"
                        name="phone"
                        value={formData.phone}
                        onChange={handleChange}
                        className="form-control"
                        id="floatingPhone"
                        placeholder="Phone Number"
                        required
                    />
                    <label htmlFor="floatingPhone">Phone Number*</label>
                </div>

                {/* Travel Date with Icon */}
                <div className="form-floating mb-3 position-relative">
                    <input
                        type="text"
                        name="travelDate"
                        value={formData.travelDate}
                        onChange={handleChange}
                        className="form-control date-input"
                        id="floatingDate"
                        placeholder="Travel Date"
                        required
                    />
                    <label htmlFor="floatingDate">Travel Date*</label>
                    <span className="calendar-icon">
                        <Image
                            src="/images/calendar-icon.svg"
                            alt="Calendar Icon"
                            width={20}
                            height={20}
                        />
                    </span>
                </div>

                {/* People */}
                <div className="form-floating mb-3">
                    <input
                        type="number"
                        name="people"
                        value={formData.people}
                        onChange={handleChange}
                        className="form-control"
                        id="floatingPeople"
                        placeholder="Number of People"
                        required
                    />
                    <label htmlFor="floatingPeople">No. of People*</label>
                </div>

                {/* Message */}
                <div className="form-floating mb-3">
                    <textarea
                        name="message"
                        value={formData.message}
                        onChange={handleChange}
                        className="form-control"
                        id="floatingMessage"
                        placeholder="Message"
                        rows="4"

                        required
                    ></textarea>
                    <label htmlFor="floatingMessage">Message*</label>
                </div>

                {/* Submit Button */}
                <button type="submit" className="btn orange-btn w-100 d-flex align-items-center justify-content-center gap-2">
                    Submit Enquiry
                    <Image
                        width={23}
                        height={23}
                        src="/images/button-arrow.png"
                        alt=""
                    />
                </button>
            </form>
        </div>
    );
};

export default EnquiryForm;
