"use client";

import React from "react";
import Image from "next/image";
import Link from "next/link";


const CustomerRate = () => {


  return (
    <section className="customer-rate common-padd pt-0">
        <div className="container">
            <div className="common-header-center">
                <h2><span className="color-blue">Customers</span> who book with Cholan Tours <span className="color-blue d-block">rate us 5/5</span></h2>
            </div>
            <div className="customer-rate-wraper">
                <div className="row">
                    <div className="col-lg-4">
                        <div className="sngl-box">
                            <div className="content-box">
                                <p>{`"Christine was very helpful and considerate of our needs."`}</p>
                            </div>
                            <div className="author">
                                <h5>Alastair</h5>
                                <div className="block-img">
                                    <Image
                                        width={82}
                                        height={12}
                                        sizes="100vw"
                                        src="/images/start-orang.png"
                                        alt=""
                                        className=""
                                    />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div className="col-lg-4">
                        <div className="sngl-box">
                            <div className="content-box">
                                <p>{`"Jen was helpful, practical, responsive and enthusiastic about our plans"`}</p>
                            </div>
                            <div className="author">
                                <h5>Anthony</h5>
                                <div className="block-img">
                                    <Image
                                        width={82}
                                        height={12}
                                        sizes="100vw"
                                        src="/images/start-orang.png"
                                        alt=""
                                        className=""
                                    />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div className="col-lg-4">
                        <div className="sngl-box">
                            <div className="content-box">
                                <p>{`"Very friendly, professional and helpful. Made good suggestions."`}</p>
                            </div>
                            <div className="author">
                                <h5>Peter</h5>
                                <div className="block-img">
                                    <Image
                                        width={82}
                                        height={12}
                                        sizes="100vw"
                                        src="/images/start-orang.png"
                                        alt=""
                                        className=""
                                    />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div className="btm-button">
                    <Link href="#" className="btn blue-btn">
                        See All Reviews
                        <span>
                            <Image
                                width={23}
                                height={23}
                                sizes="100vw"
                                src="/images/button-arrow.png"
                                alt=""
                                className=""
                            />
                        </span>
                    </Link>
                </div>
            </div>
        </div>
    </section>
  );
};

export default CustomerRate;
