"use client";

import React from "react";
import Image from "next/image";
import Link from "next/link";
import { devImgPath } from "@/app/urls/imageUrl";
import { useRouter } from "next/navigation";

const DiscoverIndia = ({ discoverIndiaPackageData }: any) => {
  const router = useRouter();

  const setUrl = (slug: any, displaySlug: any) => {
    router.push(`/packages/${slug}`);
  };

  return (
    <section className="discover-india common-padd">
      <Image
        width={1920}
        height={600}
        sizes="100vw"
        src="/images/indiaget.jpg"
        alt=""
        className=""
      />
      <div className="content-box">
        <div className="container">
          <div className="common-header-center">
            <h2>Discover India</h2>
            <p>
              Over the last two decades, We’ve helped our customer to travel so
              rather than us singing our praises; we prefer to let our customers
              do the talking...{" "}
            </p>
          </div>
          <div className="discover-wraper">
            <div className="row">
              {discoverIndiaPackageData.map((discover: any) => (
                <div className="col-lg-3" key={discover.id}>
                  <div className="sngl-box">
                    <div className="image-box">
                      <Image
                        width={300}
                        height={400}
                        sizes="100vw"
                        src={`${discover.primary_image}`}
                        alt=""
                        className=""
                      />
                    </div>
                    <div className="content-box-wraper">
                      <h5>{discover.title}</h5>
                      <p>
                        Premium {discover.title} in Depth with Intrepid Travel -{" "}
                        {discover.details.duration_days} day /{" "}
                        {discover.details.duration_nights} night 
                        {/* tour Start from
                        ₹{discover.price} */}
                      </p>
                      <button onClick={() => setUrl(discover.slug, discover.display_slug)}  className="btn blue-btn">
                        Find out More
                        <span>
                          <Image
                            width={23}
                            height={23}
                            sizes="100vw"
                            src="/images/button-arrow.png"
                            alt=""
                            className=""
                          />
                        </span>
                      </button>
                    </div>
                  </div>
                </div>
              ))}
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default DiscoverIndia;
