// 'use client';

// import { Tabs, TabList, Tab, TabPanel } from 'react-tabs';
// import 'react-tabs/style/react-tabs.css';
// import Image from 'next/image';
// import Link from 'next/link';
// import AOS from 'aos';
// import 'aos/dist/aos.css';
// import { useEffect, useState } from 'react';
// import { Swiper, SwiperSlide } from 'swiper/react';
// import { Autoplay, Navigation, Pagination } from 'swiper/modules';
// import 'swiper/css';
// import 'swiper/css/navigation';
// import 'swiper/css/pagination';
// import axios from 'axios';
// import { DEV_URL, XPublicToken } from '@/app/urls/apiUrls';

// interface ImageComponentProps {
//   src: string;
//   alt: string;
//   href: string;
// }

// const ImageComponent = ({ src, alt, href }: ImageComponentProps) => (
//   <Link href={href} className="group block">
//     <div
//       className="position-relative overflow-hidden rounded-4 shadow-md transition-all duration-300 group-hover:shadow-xl group-hover:-translate-y-1"
//       data-aos="zoom-in"
//       data-aos-delay="100"
//     >
//       <Image
//         src={src}
//         alt={alt}
//         width={400}
//         height={600}
//         className="w-full h-72 object-cover transition-transform duration-500 group-hover:scale-110 group-hover:brightness-95"
//       />
//       <div className="absolute inset-x-0 bottom-0 h-0 bg-gradient-to-t from-black/70 to-transparent transition-all duration-400 group-hover:h-2/3" />
//     </div>
//   </Link>
// );


// const Tourpackages: React.FC<any> = ({internationalData}: any) => {
//   useEffect(() => {
//     AOS.init({
//       duration: 800,
//       easing: 'ease-in-out',
//       once: true,
//     });
//   }, []);

  
//   const [packagedata, setPackagedata] = useState<any>([]);
//   const [slug, setSlug] = useState<any>("");

//     useEffect(() => {
//     fetchCountries();
//   }, [slug]);

//   const fetchCountries = async () => {
//     try {

//        const url = slug
//         ? `${DEV_URL}/api/v1/packages/categories/international?slug=${slug}&limit=${50}`
//         : `${DEV_URL}/api/v1/packages/categories/international?slug=${internationalData.categories[0].slug}&limit=${50}`;

//       const response = await axios.get(url, {
//         headers: {
//           "X-Public-Token": XPublicToken,
//         },
//       });
  
//       console.log("response.data",response.data);
//       setPackagedata(response.data.data);

//     } catch (err) {
//       console.error("Failed to fetch:", err);
//     }
//   };

//   const getSlug = (slug: any) => {
//     setSlug(slug);
//   }
  
//   return (
//     <div className="container pb-4">
//       <div className="row">
//         <h2 className="mb-4 text-center">International Tour Packages by Interest</h2>
//         <Tabs>
//           {/* Tab List */}
//           <TabList className="nav nav-pills justify-content-center mb-5 gap-4" data-aos="fade-up" data-aos-delay="100">
        

//             {internationalData.categories.map((data: any) => (
//             <Tab onClick={() => getSlug(data.slug)}  key={data.slug}
//               className="nav-link"
//               selectedClassName="active bg-primary text-white"
//             >
//               {data.name}
//             </Tab>
//             ))}
            
//           </TabList>

//           {/* All Tab */}
//           <TabPanel data-aos="fade-up" data-aos-delay="200">
//             <Swiper
//               spaceBetween={15}
//               slidesPerView={6}
//               pagination={{ clickable: true }}
//               autoplay={{ delay: 3000, disableOnInteraction: false }}
//               modules={[Pagination, Autoplay]}
//               breakpoints={{
//                 320: { slidesPerView: 1 },
//                 640: { slidesPerView: 2 },
//                 768: { slidesPerView: 3 },
//                 1024: { slidesPerView: 4 },
//                 1280: { slidesPerView: 6 },
//               }}
//               className="mySwiper"
//             >

//               {packagedata?.packages?.map((data: any) => (
//               <SwiperSlide key={data.slug} >
//                 <ImageComponent
//                   src={data.primary_image}
//                   alt="city"
//                   href="/destination/bali-1"
//                 />
//                 <Link className="text-black" href="/destination/bali-1">
//                   <h5 className="mt-4 text-center transition-colors duration-300">
//                     {data.location.name}
//                   </h5>
//                 </Link>
//               </SwiperSlide>
//               ))}

//             </Swiper>
//           </TabPanel>

  
//         </Tabs>
//       </div>
//     </div>
//   );
// };

// export default Tourpackages;



'use client';

import { Tabs, TabList, Tab, TabPanel } from 'react-tabs';
import 'react-tabs/style/react-tabs.css';
import Image from 'next/image';
import Link from 'next/link';
import AOS from 'aos';
import 'aos/dist/aos.css';
import { useEffect, useState } from 'react';
import { Swiper, SwiperSlide } from 'swiper/react';
import { Autoplay, Pagination } from 'swiper/modules';
import 'swiper/css';
import 'swiper/css/pagination';
import axios from 'axios';
import { DEV_URL, XPublicToken } from '@/app/urls/apiUrls';

interface ImageComponentProps {
  src: string;
  alt: string;
  href: string;
}

const ImageComponent = ({ src, alt, href }: ImageComponentProps) => (
  <Link href={href} className="group block">
    <div
      className="position-relative overflow-hidden rounded-4 shadow-md transition-all duration-300 group-hover:shadow-xl group-hover:-translate-y-1"
      data-aos="zoom-in"
      data-aos-delay="100"
    >
      <Image
        src={src}
        alt={alt}
        width={400}
        height={600}
        className="w-full h-72 object-cover transition-transform duration-500 group-hover:scale-110 group-hover:brightness-95"
      />
      <div className="absolute inset-x-0 bottom-0 h-0 bg-gradient-to-t from-black/70 to-transparent transition-all duration-400 group-hover:h-2/3" />
    </div>
  </Link>
);

const Tourpackages: React.FC<any> = ({ internationalData }: any) => {
  useEffect(() => {
    AOS.init({ duration: 800, easing: 'ease-in-out', once: true });
  }, []);

  const [packagedata, setPackagedata] = useState<any>({});
  const [selectedIndex, setSelectedIndex] = useState(0);

  const fetchPackages = async (slug: string) => {
    try {
      const url = `${DEV_URL}/api/v1/packages/categories/international?slug=${slug}&limit=50`;
      const response = await axios.get(url, {
        headers: { 'X-Public-Token': XPublicToken },
      });

      setPackagedata((prev: any) => ({
        ...prev,
        [slug]: response.data.data,
      }));
    } catch (err) {
      console.error('Failed to fetch:', err);
    }
  };

  useEffect(() => {
    const slug = internationalData.categories[selectedIndex].slug;
    if (!packagedata[slug]) {
      fetchPackages(slug);
    }
  }, [selectedIndex]);

  return (
    <div className="container pb-4">
      <div className="row">
        <h2 className="mb-4 text-center">International Tour Packages by Interest</h2>
        <Tabs selectedIndex={selectedIndex} onSelect={(index) => setSelectedIndex(index)}>
          <TabList className="nav nav-pills justify-content-center mb-5 gap-4" data-aos="fade-up" data-aos-delay="100">
            {internationalData.categories.map((data: any) => (
              <Tab key={data.slug} className="nav-link" selectedClassName="active bg-primary text-white">
                {data.name}
              </Tab>
            ))}
          </TabList>

          {/* Render TabPanel for each category */}
          {internationalData.categories.map((data: any, idx: number) => {
            const dataForSlug = packagedata[data.slug];

            return (
              <TabPanel key={data.slug} data-aos="fade-up" data-aos-delay="200">
                {dataForSlug ? (
                  <Swiper
                    spaceBetween={15}
                    slidesPerView={6}
                    pagination={{ clickable: true }}
                    autoplay={{ delay: 3000, disableOnInteraction: false }}
                    modules={[Pagination, Autoplay]}
                    breakpoints={{
                      320: { slidesPerView: 1 },
                      640: { slidesPerView: 2 },
                      768: { slidesPerView: 3 },
                      1024: { slidesPerView: 4 },
                      1280: { slidesPerView: 6 },
                    }}
                    className="mySwiper"
                  >
                    {dataForSlug.packages?.map((pkg: any) => (
                      <SwiperSlide key={pkg.slug}>
                        <ImageComponent
                          src={pkg.primary_image}
                          alt="city"
                          href={`/packages/${pkg.slug}`}
                        />
                        <Link className="text-black" href={`/packages/${pkg.slug}`}>
                          <h5 className="mt-4 text-center">{pkg.location.name}</h5>
                        </Link>
                      </SwiperSlide>
                    ))}
                  </Swiper>
                ) : (
                  <p>Loading packages...</p>
                )}
              </TabPanel>
            );
          })}
        </Tabs>
      </div>
    </div>
  );
};

export default Tourpackages;
