'use client';

import { Tabs, TabList, Tab, TabPanel } from 'react-tabs';
import 'react-tabs/style/react-tabs.css';
import Image from 'next/image';
import Link from 'next/link';
import AOS from 'aos';
import 'aos/dist/aos.css';
import { useEffect } from 'react';

const TrainTabWithImages = () => {
  useEffect(() => {
    AOS.init({
      duration: 800,
      easing: 'ease-in-out',
      once: true,
    });
  }, []);
  

  return (
    <div className="train-list">
      <Tabs>
        {/* Tab List */}
        <TabList className="nav nav-pills justify-content-center mb-3 gap-4" data-aos="fade-up" data-aos-delay="100">

          {['All', 'Maharaja Express', 'Palace on wheels', 'Golden chariot', 'Deccan Odyssey'].map((label) => (
            <Tab
              key={label}
              className="nav-link"
              selectedClassName="active bg-primary text-white"
            >
              {label}
            </Tab>
          ))}
        </TabList>

        <div className="train-listing-wraper py-5">

          <div className="container">
            <div className="row">
              <TabPanel data-aos="fade-up" data-aos-delay="200">
                <div className="d-flex flex-col gap-20">
                  <div className="flex flex-col lg:flex-row items-center justify-between gap-8">
                    {/* Left Image */}
                    <div className="w-full col-lg-4 relative">
                      <div className="relative z-10">
                        <Image
                          src="/images/strain.webp"
                          alt="Luxury Train"
                          width={600}
                          height={400}
                          className="rounded-[30px] w-full h-auto"
                        />
                      </div>

                    </div>

                    {/* Right Content */}
                    <div className="w-full col-lg-8 relative">

                      <h2 className="text-black">Maharaja Express</h2>
                      <p className="text-[#575757] text-sm font-normal leading-relaxed">
                        Luxury trains offer a unique way to explore destinations with the perfect blend of opulence, comfort, and cultural discovery. Designed to recreate the charm of royal travel, these trains feature elegantly furnished cabins, fine-dining restaurants, personalized butler service, and curated itineraries covering iconic landmarks. They provide not just transportation, but an immersive travel experience where guests can indulge in world-class hospitality while enjoying the scenic beauty and heritage of diverse regions.
                      </p>

                      {/* CTA Buttons */}
                      <div className="mt-6 flex flex-wrap gap-4">
                        <Link href="#" className="btn blue-btn">
                          View Details
                          <span>
                            <Image
                              width={23}
                              height={23}
                              sizes="100vw"
                              src="/images/button-arrow.png"
                              alt=""
                              className=""
                            />
                          </span>
                        </Link>
                        <Link href="#" className="btn orange-btn">
                          Enquire Now
                          <span>
                            <Image
                              width={23}
                              height={23}
                              sizes="100vw"
                              src="/images/button-arrow.png"
                              alt=""
                              className=""
                            />
                          </span>
                        </Link>
                      </div>

                      <div className="routes">
                        <ul>
                          <li>Maharastra Splendour</li>
                          <li>Hidden Treasure Of Gujarat</li>
                          <li>Indian Odyssey</li>
                          <li>Indian Sojourn</li>
                          <li>Jewels Of The Deccan</li>
                        </ul>
                      </div>


                    </div>
                  </div>
                  <div className="flex flex-col lg:flex-row items-center justify-between gap-8">
                    <div className="w-full col-lg-8 relative">

                      <h2 className="text-black">Maharaja Express</h2>
                      <p className="text-[#575757] text-sm font-normal leading-relaxed">
                        Luxury trains offer a unique way to explore destinations with the perfect blend of opulence, comfort, and cultural discovery. Designed to recreate the charm of royal travel, these trains feature elegantly furnished cabins, fine-dining restaurants, personalized butler service, and curated itineraries covering iconic landmarks. They provide not just transportation, but an immersive travel experience where guests can indulge in world-class hospitality while enjoying the scenic beauty and heritage of diverse regions.
                      </p>

                      {/* CTA Buttons */}
                      <div className="mt-6 flex flex-wrap gap-4">
                        <Link href="#" className="btn blue-btn">
                          View Details
                          <span>
                            <Image
                              width={23}
                              height={23}
                              sizes="100vw"
                              src="/images/button-arrow.png"
                              alt=""
                              className=""
                            />
                          </span>
                        </Link>
                        <Link href="#" className="btn orange-btn">
                          Enquire Now
                          <span>
                            <Image
                              width={23}
                              height={23}
                              sizes="100vw"
                              src="/images/button-arrow.png"
                              alt=""
                              className=""
                            />
                          </span>
                        </Link>
                      </div>

                      <div className="routes">
                        <ul>
                          <li>Maharastra Splendour</li>
                          <li>Hidden Treasure Of Gujarat</li>
                          <li>Indian Odyssey</li>
                          <li>Indian Sojourn</li>
                          <li>Jewels Of The Deccan</li>
                        </ul>
                      </div>


                    </div>
                    <div className="w-full col-lg-4 relative">
                      <div className="relative z-10">
                        <Image
                          src="/images/strain.webp"
                          alt="Luxury Train"
                          width={600}
                          height={400}
                          className="rounded-[30px] w-full h-auto"
                        />
                      </div>

                    </div>
                  </div>
                  <div className="flex flex-col lg:flex-row items-center justify-between gap-8">
                    {/* Left Image */}
                    <div className="w-full col-lg-4 relative">
                      <div className="relative z-10">
                        <Image
                          src="/images/strain.webp"
                          alt="Luxury Train"
                          width={600}
                          height={400}
                          className="rounded-[30px] w-full h-auto"
                        />
                      </div>

                    </div>

                    {/* Right Content */}
                    <div className="w-full col-lg-8 relative">

                      <h2 className="text-black">Maharaja Express</h2>
                      <p className="text-[#575757] text-sm font-normal leading-relaxed">
                        Luxury trains offer a unique way to explore destinations with the perfect blend of opulence, comfort, and cultural discovery. Designed to recreate the charm of royal travel, these trains feature elegantly furnished cabins, fine-dining restaurants, personalized butler service, and curated itineraries covering iconic landmarks. They provide not just transportation, but an immersive travel experience where guests can indulge in world-class hospitality while enjoying the scenic beauty and heritage of diverse regions.
                      </p>

                      {/* CTA Buttons */}
                      <div className="mt-6 flex flex-wrap gap-4">
                        <Link href="#" className="btn blue-btn">
                          View Details
                          <span>
                            <Image
                              width={23}
                              height={23}
                              sizes="100vw"
                              src="/images/button-arrow.png"
                              alt=""
                              className=""
                            />
                          </span>
                        </Link>
                        <Link href="#" className="btn orange-btn">
                          Enquire Now
                          <span>
                            <Image
                              width={23}
                              height={23}
                              sizes="100vw"
                              src="/images/button-arrow.png"
                              alt=""
                              className=""
                            />
                          </span>
                        </Link>
                      </div>

                      <div className="routes">
                        <ul>
                          <li>Maharastra Splendour</li>
                          <li>Hidden Treasure Of Gujarat</li>
                          <li>Indian Odyssey</li>
                          <li>Indian Sojourn</li>
                          <li>Jewels Of The Deccan</li>
                        </ul>
                      </div>


                    </div>
                  </div>
                  <div className="flex flex-col lg:flex-row items-center justify-between gap-8">
                    <div className="w-full col-lg-8 relative">

                      <h2 className="text-black">Maharaja Express</h2>
                      <p className="text-[#575757] text-sm font-normal leading-relaxed">
                        Luxury trains offer a unique way to explore destinations with the perfect blend of opulence, comfort, and cultural discovery. Designed to recreate the charm of royal travel, these trains feature elegantly furnished cabins, fine-dining restaurants, personalized butler service, and curated itineraries covering iconic landmarks. They provide not just transportation, but an immersive travel experience where guests can indulge in world-class hospitality while enjoying the scenic beauty and heritage of diverse regions.
                      </p>

                      {/* CTA Buttons */}
                      <div className="mt-6 flex flex-wrap gap-4">
                        <Link href="#" className="btn blue-btn">
                          View Details
                          <span>
                            <Image
                              width={23}
                              height={23}
                              sizes="100vw"
                              src="/images/button-arrow.png"
                              alt=""
                              className=""
                            />
                          </span>
                        </Link>
                        <Link href="#" className="btn orange-btn">
                          Enquire Now
                          <span>
                            <Image
                              width={23}
                              height={23}
                              sizes="100vw"
                              src="/images/button-arrow.png"
                              alt=""
                              className=""
                            />
                          </span>
                        </Link>
                      </div>

                      <div className="routes">
                        <ul>
                          <li>Maharastra Splendour</li>
                          <li>Hidden Treasure Of Gujarat</li>
                          <li>Indian Odyssey</li>
                          <li>Indian Sojourn</li>
                          <li>Jewels Of The Deccan</li>
                        </ul>
                      </div>


                    </div>
                    <div className="w-full col-lg-4 relative">
                      <div className="relative z-10">
                        <Image
                          src="/images/strain.webp"
                          alt="Luxury Train"
                          width={600}
                          height={400}
                          className="rounded-[30px] w-full h-auto"
                        />
                      </div>

                    </div>
                  </div>
                </div>


              </TabPanel>

              
              <TabPanel data-aos="fade-up" data-aos-delay="200">
                <div className="flex flex-col lg:flex-row items-center justify-between gap-8">
                  {/* Left Image */}
                  <div className="w-full col-lg-4 relative">
                    <div className="relative z-10">
                      <Image
                        src="/images/strain.webp"
                        alt="Luxury Train"
                        width={600}
                        height={400}
                        className="rounded-[30px] w-full h-auto"
                      />
                    </div>

                  </div>

                  {/* Right Content */}
                  <div className="w-full col-lg-8 relative">

                    <h2 className="text-black">Maharaja Express</h2>
                    <p className="text-[#575757] text-sm font-normal leading-relaxed">
                      Luxury trains offer a unique way to explore destinations with the perfect blend of opulence, comfort, and cultural discovery. Designed to recreate the charm of royal travel, these trains feature elegantly furnished cabins, fine-dining restaurants, personalized butler service, and curated itineraries covering iconic landmarks. They provide not just transportation, but an immersive travel experience where guests can indulge in world-class hospitality while enjoying the scenic beauty and heritage of diverse regions.
                    </p>

                    {/* CTA Buttons */}
                    <div className="mt-6 flex flex-wrap gap-4">
                      <Link href="#" className="btn blue-btn">
                        View Details
                        <span>
                          <Image
                            width={23}
                            height={23}
                            sizes="100vw"
                            src="/images/button-arrow.png"
                            alt=""
                            className=""
                          />
                        </span>
                      </Link>
                      <Link href="#" className="btn orange-btn">
                        Enquire Now
                        <span>
                          <Image
                            width={23}
                            height={23}
                            sizes="100vw"
                            src="/images/button-arrow.png"
                            alt=""
                            className=""
                          />
                        </span>
                      </Link>
                    </div>

                    <div className="routes">
                      <ul>
                        <li>Maharastra Splendour</li>
                        <li>Hidden Treasure Of Gujarat</li>
                        <li>Indian Odyssey</li>
                        <li>Indian Sojourn</li>
                        <li>Jewels Of The Deccan</li>
                      </ul>
                    </div>


                  </div>
                </div>
              </TabPanel>
            </div>
          </div>

        </div>



        {/* Add more <TabPanel> here if needed */}
      </Tabs>
    </div>
  );
};

export default TrainTabWithImages;
