import Link from 'next/link';
import Image from 'next/image';
import React from 'react';

const HeritageCard: React.FC = () => {
    return (
        <div className="max-w-100 rounded-lg overflow-hidden shadow-lg bg-white tourCard heritage-card">
            <img
                className="w-full h-48 object-cover "
                src="images/tour/heritage.webp"
                alt="Heritage of India"
            />
            <div className="p-3 pb-0">
                <h5 className="mb-3 text-black font-semibold">The Heritage of India</h5>
                <p className="text-[#575757] text-sm mb-2 flex items-start gap-2">
                    <img src="images/icon/location.svg" alt="icon"/>
                     <span> Mumbai - Udaipur - Jodhpur - Bikaner - Jaipur - Ranthambore - Agra - Delhi </span>
                </p>
                <p className="text-[#575757] text-sm mb-2 flex items-start gap-2">
                    <img src="images/icon/clock.svg" alt="icon"/>
                     <span>6 Nights / 7 Days </span>
                </p>
            </div>
            <div className="mx-auto w-100 py-4">
                <div className="button text-center">
                      <Link href="#" className="btn orange-btn">
                        Enquire Now
                        <span>
                          <Image
                            width={23}
                            height={23}
                            sizes="100vw"
                            src="/images/button-arrow.png"
                            alt=""
                            className=""
                          />
                        </span>
                      </Link>
                </div>
            </div>
        </div>
    );
};

export default HeritageCard;