import React from 'react';
import Image from 'next/image';

const TrainCard: React.FC = () => {
    return (
        <div className="max-w-sm rounded-[23px] overflow-hidden shadow-lg bg-white p-4">
            <img
                className="w-full h-48 object-cover rounded-[23px]"
                src="images/train-lux.webp"
                alt="Palace on Wheels"
            />
            <div className="py-4 pb-0">
                <h5 className="mb-3 text-black font-semibold">The Heritage of India</h5>

                <p className="text-gray-600 text-sm">
                    The north-west Indian state of Rajasthan is famous for its desert and majestic forts and palaces spread out across several cities, attracting millions of visitors, both domestic and international.
                </p>
            </div>
            <div className="pt-4">
                <button
                   
                    className="btn blue-btn !bg-[#05164D] w-100"
                >
                    Explore More
                    <span>
                        <Image
                            width={23}
                            height={23}
                            sizes="100vw"
                            src="/images/button-arrow.png"
                            alt=""
                           
                        />
                    </span>
                </button>
            </div>
        </div>
    );
};

export default TrainCard;