import { Inter } from "next/font/google";
import "./globals.css";
import "bootstrap/dist/css/bootstrap.min.css";
import { Metadata } from "next/types";
import HeaderSec from "./components/Header";
import FooterSec from "./components/Footer";
import HeaderWrapper from "./components/headerWrapper";

const inter = Inter({
  variable: "--font-inter",
  subsets: ["latin"],
});

export const metadata: Metadata = {
  title: "Cholan Tours",
  description: "Crafting Journeys, Creating Memories",
};

export default function RootLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  return (
    <html lang="en">
      <head>
        <link rel="icon" href="/favicon.ico" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <meta name="theme-color" content="#000000" />
        <meta
          name="description"
          content="Crafting Journeys, Creating Memories"
        />
      </head>
      <body className={inter.variable} cz-shortcut-listen="true">
        
          <HeaderWrapper />
          {children}
          <FooterSec />
        
      </body>
    </html>
  );
}
