import { unstable_cache } from "next/cache";
import AboutSection from "./components/home/AboutSection";
import CustomerRate from "./components/home/CustomarRate";
import DiscoverIndia from "./components/home/DiscoverIndia";
import HomeBanner from "./components/home/HomeBannerSection";
import HoneymoonPackage from "./components/home/HoneymoonPackage";
import HomeTourPackage from "./components/home/IndiaTourPackage";
import InterTourPackage from "./components/home/InterTourPackage";
import LogoSlider from "./components/home/LogoSlider";
import LuxaryTour from "./components/home/LuxuryTour";
import TopService from "./components/home/TopService";
import WhyChoose from "./components/home/WhyChoose";
import {
  discoverIndiaPackageHomeData,
  fetchHomeCountryPackageData,
  fetchHomeData,
  fetchHomeExclusiveData,
  trendingInternationalHomePackageData,
} from "./services/homeService";
import CountryTourPackage from "./components/home/CountryTourPackage";

export default async function Home() {
  // Cache wrapper for API calls
  const withCache = (fn: any, key: any, tags: any) =>
    unstable_cache(
      async () => {
        try {
          const result = await fn();
          return { data: result.data, error: null };
        } catch (error) {
          console.error(`Error in ${key}:`, error);
          return { data: null, error: `Failed to fetch ${key}` };
        }
      },
      [key],
      { revalidate: 5, tags }
    );

  const cachedHomeData = withCache(() => fetchHomeData(), `home_content`, [
    `home_content`,
  ]);

  const cachedExclusiveHomeData = withCache(
    () => fetchHomeExclusiveData(),
    `exclusive_content`,
    [`exclusive_content`]
  );

  const cachedHomeCountryPackageData = withCache(
    () => fetchHomeCountryPackageData(),
    `countryPackage_HomeData`,
    [`countryPackage_HomeData`]
  );

  const cachedTrendingInternationalPackageData = withCache(
    () => trendingInternationalHomePackageData(),
    `trendingInternational_HomeData`,
    [`trendingInternational_HomeData`]
  );

  const cachedDiscoverIndiaPackageData = withCache(
    () => discoverIndiaPackageHomeData(),
    `DiscoverIndiaPackage_HomeData`,
    [`DiscoverIndiaPackage_HomeData`]
  );

  const [
    bannerData,
    exclusiveIndiaPackage,
    countryPackageHomeData,
    trendingInternationalData,
    discoverIndiaPackageData
  ] = await Promise.all([
    cachedHomeData(),
    cachedExclusiveHomeData(),
    cachedHomeCountryPackageData(),
    cachedTrendingInternationalPackageData(),
    cachedDiscoverIndiaPackageData()
  ]);

  return (
    <main>
      <HomeBanner bannerData={bannerData.data} />
      <HomeTourPackage exclusiveIndiaPackage={exclusiveIndiaPackage.data} />
      <CountryTourPackage countryPackageHomeData={countryPackageHomeData.data} />
      <InterTourPackage trendingInternationalData={trendingInternationalData.data} />
      <HoneymoonPackage data={bannerData.data.special_package} />
      <LuxaryTour />
      <DiscoverIndia discoverIndiaPackageData={discoverIndiaPackageData.data}/>
      <TopService />
      <CustomerRate />
      <WhyChoose />
      <AboutSection />
      <LogoSlider />
    </main>
  );
}
