<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Validation\ValidationException;

use App\Models\Continent;

class ContinentController extends Controller{


    public function store(Request $r){

        $r->validate([
            'name' => 'required',
            'code' => 'nullable'
        ]);
        $slug = Str::slug($r->name);

        if (Continent::where('slug', $slug)->exists()) {
            throw ValidationException::withMessages([
                'name' => 'Continent already exists.',
            ]);
        }

        $continent = Continent::create([
            'name' => $r->name,
            'slug' => $slug,
            'code' => $r->code
        ]);

        return response()->json($continent);
    }
}
