<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\DealPackages;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Validation\ValidationException;


class DealPackageController extends Controller{

    public function index(Request $r){}

    public function store(Request $r){
        //echo 'ahsdsgaj';die;
        $r->validate([
            'package_id' => 'required|exists:packages,id'
        ]);

        $obj = [
            'page_id' => $r->page_id,
            'package_id' => $r->package_id
        ];

        $package = DealPackages::create($obj);

        $url = getUrl($r->page_id)['url'];
        return redirect()
        ->route($url)
        ->with('active_tab', 'dpackage')
        ->with('success', 'Deal Package created successfully');
    }

    public function edit(DealPackages $dpackage){
        $spackage = DealPackages::where('id',$dpackage->id)->first();
        return response()->json($spackage);
    }

    public function update(Request $r, DealPackages $dpackage){
        if (!$r->exists('status')) {
            $r->validate([
                'package_id'   => 'required|exists:packages,id'
            ]);
            $obj = [
                'package_id'   => $r->package_id
            ];

            $dpackage->update($obj);
        }else {
            $dpackage->is_active = $r->status;
            $dpackage->save();
        }
        if ($r->ajax()) {
            return response()->json([
                'status'  => 'success',
                'message' => 'Package status updated successfully',
                'data'    => $dpackage
            ]);
        }
        
        return redirect()
        ->route('admin.page-settings.international')
        ->with('active_tab', 'dpackage')
        ->with('success', 'Deal Package updated successfully');
    }

    public function destroy(DealPackages $dpackage){
        $dpackage->is_deleted = 1; 
        $dpackage->save();
        session()->flash('active_tab', 'dpackage');
        return response()->json(['success'=>true]);
    }
}
