<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\EnquiryPackage;
use App\Models\EnquiryTrain;
use App\Models\EnquiryHotel;
use App\Models\EnquiryGeneral;
use App\Models\EnquiryPlanTrip;
use App\Models\EnquiryCar;

class EnquiryController extends Controller
{
    // ================== INDEX (with data) ==================
    public function packages()
    {
        $enquiries = EnquiryPackage::where('is_deleted',0)->with('package.details')->latest()->paginate(25);
        return view('admin.enquiries.packages', compact('enquiries'));
    }

    public function trains()
    {
        $enquiries = EnquiryTrain::where('is_deleted',0)->with(['train', 'tour'])->latest()->paginate(25);
        // echo '<pre>';
        // print_r($enquiries->toArray());die;
        return view('admin.enquiries.trains', compact('enquiries'));
    }

    public function cars()
    {
        $enquiries = EnquiryCar::where('is_deleted',0)->latest()->paginate(25);
        // echo '<pre>';
        // print_r($enquiries->toArray());die;
        return view('admin.enquiries.cars', compact('enquiries'));
    }

    public function hotels()
    {
        $enquiries = EnquiryHotel::where('is_deleted',0)->with('hotel')->latest()->paginate(25);
        return view('admin.enquiries.hotels', compact('enquiries'));
    }

    public function general()
    {
        $enquiries = EnquiryGeneral::where('is_deleted',0)->where('is_get_in_touch',0)->latest()->paginate(25);
        return view('admin.enquiries.general', compact('enquiries'));
    }

    public function customized()
    {
        $enquiries = EnquiryGeneral::where('is_deleted',0)->where('is_get_in_touch',1)->latest()->paginate(25);
        return view('admin.enquiries.customized', compact('enquiries'));
    }

    public function planTrip()
    {
        $enquiries = EnquiryPlanTrip::where('is_deleted',0)->latest()->paginate(25);
        return view('admin.enquiries.plan_trip', compact('enquiries'));
    }

    // ================== DETAIL (AJAX JSON) ==================
    public function packageDetail($id)
    {
        $enquiry = EnquiryPackage::with('package')->find($id);
        if (!$enquiry) {
            return response()->json(['success' => false, 'message' => 'Enquiry not found'], 404);
        }
        return response()->json(['success' => true, 'data' => $enquiry]);
    }

    public function trainDetail($id)
    {
        $enquiry = EnquiryTrain::with(['train', 'tour'])->find($id);
        if (!$enquiry) {
            return response()->json(['success' => false, 'message' => 'Enquiry not found'], 404);
        }
        return response()->json(['success' => true, 'data' => $enquiry]);
    }

    public function hotelDetail($id)
    {
        $enquiry = EnquiryHotel::with('hotel')->find($id);
        if (!$enquiry) {
            return response()->json(['success' => false, 'message' => 'Enquiry not found'], 404);
        }
        return response()->json(['success' => true, 'data' => $enquiry]);
    }

    public function carDetail($id)
    {
        $enquiry = EnquiryCar::find($id);
        if (!$enquiry) {
            return response()->json(['success' => false, 'message' => 'Enquiry not found'], 404);
        }
        return response()->json(['success' => true, 'data' => $enquiry]);
    }

    public function generalDetail($id)
    {
        $enquiry = EnquiryGeneral::find($id);
        if (!$enquiry) {
            return response()->json(['success' => false, 'message' => 'Enquiry not found'], 404);
        }
        return response()->json(['success' => true, 'data' => $enquiry]);
    }
    
    public function planTripDetail($id)
    {
        $enquiry = EnquiryPlanTrip::find($id);
        if (!$enquiry) {
            return response()->json(['success' => false, 'message' => 'Enquiry not found'], 404);
        }
        return response()->json(['success' => true, 'data' => $enquiry]);
    }

    // ================== DELETE ENQUIRIES ==================
    public function deletePackage($id)
    {
        $enquiry = EnquiryPackage::find($id);
        if (!$enquiry) {
            return response()->json(['success' => false, 'message' => 'Enquiry not found'], 404);
        }
        $enquiry->delete();
        return response()->json(['success' => true, 'message' => 'Tour enquiry deleted successfully']);
    }

    public function deleteTrain($id)
    {
        $enquiry = EnquiryTrain::find($id);
        if (!$enquiry) {
            return response()->json(['success' => false, 'message' => 'Enquiry not found'], 404);
        }
        $enquiry->delete();
        return response()->json(['success' => true, 'message' => 'Train enquiry deleted successfully']);
    }

    public function deleteHotel($id)
    {
        $enquiry = EnquiryHotel::find($id);
        if (!$enquiry) {
            return response()->json(['success' => false, 'message' => 'Enquiry not found'], 404);
        }
        $enquiry->delete();
        return response()->json(['success' => true, 'message' => 'Hotel enquiry deleted successfully']);
    }

    public function deleteCar($id)
    {
        $enquiry = EnquiryCar::find($id);
        if (!$enquiry) {
            return response()->json(['success' => false, 'message' => 'Enquiry not found'], 404);
        }
        $enquiry->delete();
        return response()->json(['success' => true, 'message' => 'Car enquiry deleted successfully']);
    }

    public function deleteGeneral($id)
    {
        $enquiry = EnquiryGeneral::find($id);
        if (!$enquiry) {
            return response()->json(['success' => false, 'message' => 'Enquiry not found'], 404);
        }
        $enquiry->delete();
        return response()->json(['success' => true, 'message' => 'Hotel enquiry deleted successfully']);
    }

    public function deletePlanTrip($id)
    {
        $enquiry = EnquiryPlanTrip::find($id);
        if (!$enquiry) {
            return response()->json(['success' => false, 'message' => 'Enquiry not found'], 404);
        }
        $enquiry->delete();
        return response()->json(['success' => true, 'message' => 'Hotel enquiry deleted successfully']);
    }

    // ================== CHANGE STATUS ==================
    public function changePackageStatus(Request $r, $id)
    {
        $enquiry = EnquiryPackage::find($id);
        if (!$enquiry) {
            return response()->json(['success' => false, 'message' => 'Enquiry not found'], 404);
        }
        $enquiry->is_confirmed = $r->status;
        $enquiry->save();

        return response()->json([
            'success' => true,
            'message' => 'Tour enquiry status updated successfully',
            'status'  => $enquiry->is_confirmed
        ]);
    }

    public function changeTrainStatus(Request $r, $id)
    {
        $enquiry = EnquiryTrain::find($id);
        if (!$enquiry) {
            return response()->json(['success' => false, 'message' => 'Enquiry not found'], 404);
        }
        $enquiry->is_confirmed = $r->status;
        $enquiry->save();

        return response()->json([
            'success' => true,
            'message' => 'Train enquiry status updated successfully',
            'status'  => $enquiry->is_confirmed
        ]);
    }

    public function changeHotelStatus(Request $r, $id)
    {
        $enquiry = EnquiryHotel::find($id);
        if (!$enquiry) {
            return response()->json(['success' => false, 'message' => 'Enquiry not found'], 404);
        }
        $enquiry->is_confirmed = $r->status;
        $enquiry->save();

        return response()->json([
            'success' => true,
            'message' => 'Hotel enquiry status updated successfully',
            'status'  => $enquiry->is_confirmed
        ]);
    }

    public function changeGeneralStatus(Request $r, $id)
    {
        $enquiry = EnquiryGeneral::find($id);
        if (!$enquiry) {
            return response()->json(['success' => false, 'message' => 'Enquiry not found'], 404);
        }
        $enquiry->is_confirmed = $r->status;
        $enquiry->save();

        return response()->json([
            'success' => true,
            'message' => 'Enquiry status updated successfully',
            'status'  => $enquiry->is_confirmed
        ]);
    }

    public function changePlanTripStatus(Request $r, $id)
    {
        $enquiry = EnquiryPlanTrip::find($id);
        if (!$enquiry) {
            return response()->json(['success' => false, 'message' => 'Enquiry not found'], 404);
        }
        $enquiry->is_confirmed = $r->status;
        $enquiry->save();

        return response()->json([
            'success' => true,
            'message' => 'Enquiry status updated successfully',
            'status'  => $enquiry->is_confirmed
        ]);
    }
}
