<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Review;


class ReviewController extends Controller
{
    // ================== INDEX (with data) ==================
    public function packages()
    { 
        $reviews = Review::with('package.details')->whereNotNull('package_id')->latest()->paginate(25);
        return view('admin.reviews.packages', compact('reviews'));
    }

    // public function car()
    // {
    //     $enquiries = EnquiryTrain::with(['train', 'tour'])->latest()->paginate(25);
    //     // echo '<pre>';
    //     // print_r($enquiries->toArray());die;
    //     return view('admin.enquiries.trains', compact('enquiries'));
    // }

    public function hotels()
    {
        $reviews = Review::with('hotel')->whereNotNull('hotel_id')->latest()->paginate(25);
        return view('admin.reviews.hotels', compact('reviews'));
    }

    // ================== DETAIL (AJAX JSON) ==================
    public function packageDetail($id)
    {
        $review = Review::with('package')->find($id);
        if (!$review) {
            return response()->json(['success' => false, 'message' => 'Review not found'], 404);
        }
        return response()->json(['success' => true, 'data' => $review]);
    }

    public function hotelDetail($id)
    {
        $review = Review::with('hotel')->find($id);
        if (!$review) {
            return response()->json(['success' => false, 'message' => 'Review not found'], 404);
        }
        return response()->json(['success' => true, 'data' => $review]);
    }
    

    // ================== DELETE ENQUIRIES ==================
    public function deletePackage($id)
    {
        $review = Review::find($id);
        if (!$review) {
            return response()->json(['success' => false, 'message' => 'Review not found'], 404);
        }
        $review->delete();
        return response()->json(['success' => true, 'message' => 'Review deleted successfully']);
    }

    public function deleteHotel($id)
    {
        $review = Review::find($id);
        if (!$review) {
            return response()->json(['success' => false, 'message' => 'Review not found'], 404);
        }
        $review->delete();
        return response()->json(['success' => true, 'message' => 'Review deleted successfully']);
    }

    // ================== CHANGE STATUS ==================
    public function changeStatus(Request $r, $id)
    {
        $review = Review::find($id);
        if (!$review) {
            return response()->json(['success' => false, 'message' => 'Review not found'], 404);
        }
        $review->is_approved = $r->status;
        $review->save();

        return response()->json([
            'success' => true,
            'message' => 'Review approved',
            'status'  => $review->is_approved
        ]);
    }

}
