<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Banner;
use App\Models\SpecialPackage;
use App\Models\Package;
use App\Models\DealPackages;
use App\Models\Page;
use App\Models\Train;
use App\Models\TourService;
use App\Models\TrainTour;
use App\Models\Hotel;
use App\Models\Facility;
use App\Models\CarCategory;
use App\Models\CarRoute;
use App\Models\Car;
use App\Models\Location;

class SettingsController extends Controller{


    public function home(Request $request){
        //session()->flash('active_tab', 'sbanner');
        list($static_banners, $banners) = Banner::where('is_deleted','!=',1)->with('package.category')->get()
        ->partition(function ($banner) {
            return $banner->is_static == 1;
        });

        $special_packages = SpecialPackage::where('is_deleted','!=',1)->with('package.category','package.details','package.source_location.country','package.location.country')->get();

        $services = TourService::where('is_deleted','!=',1)->get();

        $packages = Package::with('category','details','source_location.country','location.country')->where('is_active',1)->where('is_deleted','!=',1)->get();

        $page_details = Page::find(8);
        return view('admin.settings.home', compact(
            'banners',
            'static_banners',
            'special_packages',
            'packages',
            'services',
            'page_details'
        ));
    }

    public function international(Request $request){
        $page_details = Page::find(1);

        $deal_packages = DealPackages::where('page_id', 1)
            ->where('is_deleted', '!=', 1)
            ->with(['package','package.details','package.location.country.continent'])
            ->get();

        // echo '<pre>';
        // print_r($deal_packages->toArray() );die;
        $dealPackageIds = $deal_packages->pluck('package_id');

        $packages = Package::with('category','details','source_location.country','location.country')
            ->where('type',2)
            ->where('is_active',1)
            ->where('is_deleted','!=',1)
            ->whereNotIn('id', $dealPackageIds)
            ->get();

        return view('admin.settings.page', compact(
            'page_details',
            'deal_packages',
            'packages'
        ));
    }

    public function india(Request $request){
        $page_details = Page::find(3);

        $deal_packages = DealPackages::where('page_id', 3)
            ->where('is_deleted', '!=', 1)
            ->with(['package','package.details','package.location.country.continent'])
            ->get();

        // echo '<pre>';
        // print_r($deal_packages->toArray() );die;
        $dealPackageIds = $deal_packages->pluck('package_id');

        $packages = Package::with('category','details','source_location.country','location.country')
            ->where('country_id',1)
            ->where('is_active',1)
            ->where('is_deleted','!=',1)
            ->whereNotIn('id', $dealPackageIds)
            ->get();

        return view('admin.settings.page', compact(
            'page_details',
            'deal_packages',
            'packages'
        ));
    }

    public function srilanka(Request $request){
        $page_details = Page::find(4);

        $deal_packages = DealPackages::where('page_id', 4)
            ->where('is_deleted', '!=', 1)
            ->with(['package','package.details','package.location.country.continent'])
            ->get();

        // echo '<pre>';
        // print_r($deal_packages->toArray() );die;
        $dealPackageIds = $deal_packages->pluck('package_id');

        $packages = Package::with('category','details','source_location.country','location.country')
            ->where('country_id',10)
            ->where('is_active',1)
            ->where('is_deleted','!=',1)
            ->whereNotIn('id', $dealPackageIds)
            ->get();

        return view('admin.settings.page', compact(
            'page_details',
            'deal_packages',
            'packages'
        ));
    }

    public function luxuryTrain(Request $request){
        $page_details = Page::find(2);

        $trains = Train::where('is_deleted','!=',1)->orderBy('id','desc')->get();
        $tours = TrainTour::where('is_deleted','!=',1)
            ->with('train','details')
            ->orderBy(list_config()['order_by'], list_config()['direction'])
            ->paginate(25);

        return view('admin.settings.train', compact(
            'page_details',
            'trains',
            'tours'
        ));
    }

    public function luxuryHotel(Request $request){
        $page_details = Page::find(5);
        $facilities = Facility::where('is_active',1)->get();
        $hotels = Hotel::where('is_deleted','!=',1)->orderBy('id','desc')->get();

        return view('admin.settings.hotel', compact(
            'page_details',
            'facilities',
            'hotels'
        ));
    }

    public function car(Request $request)
    {
        $page_details = Page::find(6);

        $countryId = $request->get('country_id', 1);

        $locations = Location::where([
            ['country_id', '=', $countryId],
            ['is_active', '=', 1],
        ])->get();

        $categories = CarCategory::where('is_deleted', 0)->get();

        $car_routes = CarRoute::with(['cars.category'])
            ->where('is_deleted', 0)
            ->orderByDesc('id')
            ->paginate(25);

        $cars = Car::with('category')
            ->where('is_deleted', '!=', 1)
            ->orderByDesc('id')
            ->get();

        session()->put('active_tab', $request->has('page') ? 'route_list' :  session()->get('active_tab'));

        return view('admin.settings.car', compact(
            'page_details',
            'locations',
            'categories',
            'cars',
            'car_routes'
        ));
    }


    public function customizedHoliday(Request $request){
        $page_details = Page::find(7);
        return view('admin.settings.page', compact(
            'page_details'
        ));
    }

}
