<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\SpecialPackage;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Validation\ValidationException;


class SpecialPackageController extends Controller{

    public function store(Request $r){
        $r->validate([
            'package_id' => 'required|exists:packages,id',
            'title' => 'required|string|max:255',
            'banner_image' => 'image|mimes:webp'
        ]);

        $obj = [
            'package_id' => $r->package_id,
            'title' => $r->title,
            'banner_image' => $r->banner_image_alt
        ];

        if ($r->hasFile('banner_image')) {
            $file = $r->file('banner_image');

            if ($file->isValid()) {
                // keep original file name
                $filename = $file->getClientOriginalName();

                // store in "banner/" folder on public disk
                $path = $file->storeAs('special_package', $filename, 's3');

                $obj['banner_image'] = $path;
            }
        }


        $banner = SpecialPackage::create($obj);
        session()->flash('active_tab', 'spackage');

        return response()->json(['success'=>true]);
    }

    public function edit(SpecialPackage $spackage){
        $spackage = SpecialPackage::where('id',$spackage->id)->first();
        
        session()->flash('active_tab', 'spackage');
        return response()->json($spackage);
    }

    public function update(Request $r, SpecialPackage $spackage){

        if (!$r->exists('status')) {
            $r->validate([
                'title'        => 'required|max:150',
                'package_id'   => 'required|exists:packages,id',
                'banner_image' => 'image|mimes:webp'
            ]);
            $path = $spackage->banner_image ?? '';
            if ($r->hasFile('banner_image')) {
                $file = $r->file('banner_image');

                //if ($file->isValid()) {
                    // delete old file if exists
                    try {
                        if ($spackage->banner_image && \Storage::disk('s3')->exists($spackage->banner_image)) {
                            \Storage::disk('s3')->delete($spackage->banner_image);
                        }
                    } catch (\Exception $e) {
                        // ✅ Catch any unexpected error, but don’t break deletion
                        \Log::error('Unexpected S3 error: '.$e->getMessage());
                    }

                    // // keep original filename
                    // $filename = $file->getClientOriginalName();

                    // // store in S3 under "special_package/"
                    // $path = $file->storeAs('special_package', $filename, 's3');

                    $filename = $r->file('banner_image')->getClientOriginalName();

                    // store with original filename in S3
                    $path = $r->file('banner_image')->storeAs('special_package', $filename, 's3');
                //}
            }

            $obj = [
                'title'       => $r->title,
                'package_id'   => $r->package_id,
                'banner_image'=> $path,
                'banner_image_alt' => $r->banner_image_alt
            ];
            //print_r($obj);die;
            $spackage->update($obj);
        } else {
            if ($r->status) {
                $spackage->is_active = 1;
            } else {
                // If trying to deactivate → check if another static active exists
                $activeStatic = SpecialPackage::where('is_active', 1)
                ->where('id', '!=', $spackage->id)
                ->exists();

                if (!$activeStatic) {
                    // No other static is active → force this one to stay active
                    $spackage->is_active = 1;
                    return response()->json([
                        'status'  => 'error',
                        'message' => 'At least one special package need to active',
                        'data'    => $spackage
                    ]);
                } else {
                    // Safe to deactivate
                    $spackage->is_active = 0;
                }
            }
            $spackage->save();
        }
        session()->flash('active_tab', 'spackage');

        // If AJAX request, return JSON response
        if ($r->ajax()) {
            return response()->json([
                'status'  => 'success',
                'message' => 'Special Package updated successfully',
                'data'    => $spackage
            ]);
        }

        // Fallback for non-AJAX
        return redirect()
        ->route('admin.settings.index')
        ->with('success', 'Special Package updated successfully');
    }

    public function destroy(SpecialPackage $spackage){
        $spackage->is_deleted = 1; 
        $spackage->save();
        if(Storage::disk('s3')->exists($spackage->banner_image)){
            Storage::disk('s3')->delete($spackage->banner_image);
        }
        session()->flash('active_tab', 'spackage');
        return response()->json(['success'=>true]);
    }
}
