<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\EnquiryMail;
use App\Models\Package;
use App\Models\Train;
use App\Models\TrainTour;
use App\Models\Hotel;
use App\Models\EnquiryPackage;
use App\Models\EnquiryTrain;
use App\Models\EnquiryHotel;
use App\Models\EnquiryGeneral;
use App\Models\EnquiryPlanTrip;
use App\Models\EnquiryCar;

class EnquiryController extends Controller
{
    // ---------- HELPER FUNCTION TO SEND EMAILS ----------
    private function sendEnquiryEmails(array $data, $subjectAdmin, $subjectCustomer = null)
    {
        $adminData = $data;
        $adminData['is_admin'] = true;
        Mail::to(config('mail.admin_email', env('ADMIN_EMAIL')))->send(
            new EnquiryMail($adminData, $subjectAdmin)
        );

        if (!empty($data['email']) && $subjectCustomer) {
            $customerData = $data;
            $customerData['is_admin'] = false;
            Mail::to($data['email'])->send(
                new EnquiryMail($customerData, $subjectCustomer)
            );
        }
    }

    // ================== STORE PACKAGE ENQUIRY ==================
    public function storePackage(Request $request)
    {
        $validated = $request->validate([
            'package_slug' => 'required|string|exists:packages,slug',
            'name' => 'required|string|max:255',
            'email' => 'nullable|email|max:255',
            'phone' => 'nullable|string|max:20',
            'no_of_travellers' => 'nullable',
            'per_person_budget' => 'nullable',
            'country' => 'nullable',
            'city' => 'nullable',
            'month' => 'nullable',
            'arrival_city' => 'nullable',
            'departure_city' => 'nullable',
            'message' => 'nullable|string',
        ]);

        $package = Package::where('slug', $validated['package_slug'])->first();
        $validated['package_id'] = $package->id;
        unset($validated['package_slug']);

        $enquiry = EnquiryPackage::create($validated);

        unset($validated['package_id']);
        $validated['Looking For'] = $package->title;

        $this->sendEnquiryEmails(
            $validated,
            'New Package Enquiry Received',
            'Thank you for your Package Enquiry'
        );

        return response()->json([
            'success' => true,
            'message' => 'Package enquiry submitted successfully',
        ]);
    }

    // ================== STORE TRAIN ENQUIRY ==================
    public function storeTrain(Request $request)
    {
        $validated = $request->validate([
            'train_slug' => 'nullable|string|exists:trains,slug',
            'train_tour_slug' => 'nullable|string|exists:train_tour,slug',
            'name' => 'required|string|max:255',
            'email' => 'nullable|email|max:255',
            'phone' => 'required|string|max:20',
            'message' => 'nullable|string'
        ]);

        if (!empty($validated['train_slug'])) {
            $train = Train::where('slug', $validated['train_slug'])->first();
            $validated['train_id'] = $train ? $train->id : null;
        }

        if (!empty($validated['train_tour_slug'])) {
            $tour = TrainTour::where('slug', $validated['train_tour_slug'])->first();
            $validated['train_tour_id'] = $tour ? $tour->id : null;
        }

        unset($validated['train_slug'], $validated['train_tour_slug']);

        $enquiry = EnquiryTrain::create($validated);

        if(!empty($validated['train_tour_id'])) {
           $validated['Looking For'] = $tour->title; 
           unset($validated['train_tour_id']);
        }

        if(!empty($validated['train_id'])) {
           $validated['Looking For'] = $train->title; 
           unset($validated['train_id']);
        }
        

        $this->sendEnquiryEmails(
            $validated,
            'New Train Enquiry Received',
            'Thank you for your Train Enquiry'
        );

        return response()->json([
            'success' => true,
            'message' => 'Train enquiry submitted successfully',
        ]);
    }

    // ================== STORE HOTEL ENQUIRY ==================
    public function storeHotel(Request $request)
    {
        $validated = $request->validate([
            'hotel_slug' => 'required|string|exists:hotels,slug',
            'name' => 'required|string|max:255',
            'email' => 'nullable|email|max:255',
            'phone' => 'required|string|max:20',
            'adult_count' => 'nullable|integer',
            'child_count' => 'nullable|integer',
            'checking_date' => 'nullable|date',
            'checkout_date' => 'nullable|date',
            'room_type' => 'nullable|string',
            'message' => 'nullable|string',
        ]);

        $hotel = Hotel::where('slug', $validated['hotel_slug'])->first();
        $validated['hotel_id'] = $hotel->id;
        unset($validated['hotel_slug']);

        $enquiry = EnquiryHotel::create($validated);

        $validated['Looking For'] = $hotel->title; 
        unset($validated['hotel_id']);
        $this->sendEnquiryEmails(
            $validated,
            'New Hotel Enquiry Received',
            'Thank you for your Hotel Enquiry'
        );

        return response()->json([
            'success' => true,
            'message' => 'Hotel enquiry submitted successfully',
        ]);
    }

    // ================== STORE GENERAL ENQUIRY ==================
    public function storeGeneral(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'nullable|email|max:255',
            'phone' => 'nullable|string|max:20',
            'no_of_travellers' => 'nullable',
            'start_date' => 'nullable',
            'message' => 'nullable|string',
            'city'=> 'nullable|string',
            'travel_type' => 'nullable|string',
            'month' => 'nullable|string',
            'country' => 'nullable|string',
            'is_get_in_touch' => 'required'
        ]);

        $enquiry = EnquiryGeneral::create($validated);

        $this->sendEnquiryEmails(
            $validated,
            'New General Enquiry Received',
            'Thank you for your Enquiry'
        );

        return response()->json([
            'success' => true,
            'message' => 'Enquiry submitted successfully',
        ]);
    }

    // ================== STORE PLAN TRIP ENQUIRY ==================
    public function storePlanTrip(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'nullable|email|max:255',
            'phone' => 'nullable|string|max:20',
            'no_of_travellers' => 'nullable',
            'city' => 'nullable',
            'month' => 'nullable',
            'arrival_city' => 'nullable',
            'departure_city' => 'nullable',
            'message' => 'nullable|string',
        ]);

        $enquiry = EnquiryPlanTrip::create($validated);

        $this->sendEnquiryEmails(
            $validated,
            'New Plan Trip Enquiry Received',
            'Thank you for your Plan Trip Enquiry'
        );

        return response()->json([
            'success' => true,
            'message' => 'Plan Trip enquiry submitted successfully',
        ]);
    }

    // ================== STORE CAR ENQUIRY ==================
    public function storeCar(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'nullable|email|max:255',
            'phone' => 'nullable|string|max:20',
            'from_city' => 'nullable',
            'vehicle_type' => 'nullable',
            'start_location' => 'nullable',
            'end_location' => 'nullable',
            'start_date' => 'nullable',
            'return_date' => 'nullable',
            'adult_count' => 'nullable',
            'child_count' => 'nullable'
        ]);

        $enquiry = EnquiryCar::create($validated);

        $this->sendEnquiryEmails(
            $validated,
            'New Car Enquiry Received',
            'Thank you for your Car Enquiry'
        );

        return response()->json([
            'success' => true,
            'message' => 'Car enquiry submitted successfully',
        ]);
    }
}
