<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Http\Resources\TrainResource;
use App\Http\Resources\TrainTourResource;
use App\Models\Train;
use App\Models\TrainTour;


class TrainController extends Controller{

    public function index(Request $r){

        $limit     = list_config()['limit']; // default 10 
        $orderBy   = list_config()['order_by']; // default order by id
        $direction = list_config()['direction']; // default desc

        $trains = Train::where('is_active', 1)
            ->where('is_deleted', '!=', 1)
            ->select('title', 'short_description', 'primary_image', 'slug') 
            ->orderBy($orderBy, $direction)
            ->limit(4)
            ->get();

        return response()->json([
            'status' => 'success',
            'message' => 'Listing',
            'data' => TrainResource::collection($trains)
        ], 200);
    }


    public function trainDetails(Request $r){

        $train = Train::where('slug', $r->slug)
            ->where('is_active', 1)
            ->where('is_deleted', '!=', 1)
            ->with(['tours.details','faqs','meta'])
            ->firstOrFail();

        // Fetch similar packages
        $similarTrains = Train::where('id', '!=', $train->id) // exclude current package
            ->where('is_active', 1)
            ->where('is_deleted', '!=', 1)
            ->take(3) // limit results
            ->get();
        return response()->json([
            'status' => 'success',
            'message' => 'Details',
            'data'    => [
                'train' => new TrainResource($train),
                'similar_trains' => TrainResource::collection($similarTrains)
            ]
        ]);
    }

    public function tourDetails(Request $r){

        $tour = TrainTour::where('slug', $r->slug)
            ->where('is_active', 1)
            ->where('is_deleted', '!=', 1)
            ->with(['train.cabins.images','details','itineraries','faqs','meta'])
            ->firstOrFail();

        $similarTrains = Train::where('id', '!=', $tour->train->id) 
            ->where('is_active', 1)
            ->where('is_deleted', '!=', 1)
            ->take(3) // limit results
            ->get();
        return response()->json([
            'status' => 'success',
            'message' => 'Details',
            'data'    => [
                'tour' => new TrainTourResource($tour),
                'similar_trains' => TrainResource::collection($similarTrains)
            ]
        ]);
    }
}
