<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class HotelResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'title'         => $this->title,
            'location'         => $this->location,
            'slug'         => $this->slug,
            'primary_image' => $this->primary_image ? storage_link($this->primary_image): null,
            'primary_image_alt' =>$this->primary_image_alt,
            'short_description' => $this->short_description,
            'refund_cancellation_policy'  => $this->refund_cancellation_policy,
            'facilities'  => $this->facilities ?? [],
            'rating' => round($this->reviews_avg_rating, 1),
            'total_review' => $this->reviews_count,
            
            'images' => $this->whenLoaded('images', function () {
                return $this->images->map(fn($img) => [
                    'image_path' => $img->image_path ? storage_link($img->image_path): null,
                    'image_alt' =>$img->image_alt,
                ]);
            }),

            'rooms' => HotelRoomResource::collection($this->whenLoaded('rooms')),

            'faqs' => $this->whenLoaded('faqs', function () {
                return $this->faqs->map(fn($faq) => [
                    'question'   => $faq->question,
                    'answer' => $faq->answer
                ]);
            }),
            
            'todos' => $this->whenLoaded('todos', function () {
                return $this->todos->map(fn($todo) => [
                    'title'   => $todo->title,
                    'details' => $todo->details,
                    'banner_image' => $todo->banner_image ? storage_link($todo->banner_image): null,
                    'banner_image_alt' =>$todo->title,
                ]);
            }),

            'meta' => $this->whenLoaded('meta', function () {
                return [
                    'meta_title'         => $this->meta->meta_title ?? null,
                    'meta_description'   => $this->meta->meta_description ?? null,
                    'meta_keywords'      => $this->meta->meta_keywords ?? null,
                    'h1_heading'         => $this->meta->h1_heading,
                    'meta_details'       => $this->meta->meta_details ?? null,
                ];
            }),
        ];
    }
}

