<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Car extends Model
{
    use HasFactory;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'cars';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'title',
        'slug',
        'category_id',
        'primary_image',
        'primary_image_alt',
        'type',
        'seats',
        'is_active',
        'is_deleted',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'is_active' => 'boolean',
        'is_deleted' => 'boolean',
    ];


    public function category()
    {
        return $this->belongsTo(CarCategory::class, 'category_id', 'id');
    }


    public function enquiries()
    {
        return $this->hasMany(EnquiryHotel::class, 'hotel_id');
    }

    public function todos()
    {
        return $this->hasMany(HotelToDo::class,'hotel_id','id');
    }

    public function reviews()
    { 
        return $this->hasMany(Review::class,'hotel_id','id');
    }

    public function meta()
    {
        return $this->hasOne(HotelMetaData::class, 'hotel_id', 'id');
    }

}
