<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CarRoutePageDetails extends Model
{
    use HasFactory;

    protected $table = 'car_routes_page_details';

    protected $fillable = [
        'id',
        'route_id',
        'title',
        'description',
        'banner_image',
        'banner_image_alt'
    ];


    public function route()
    {
        return $this->belongsTo(Page::class, 'route_id', 'id');
    }
}
