<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Country extends Model
{
    use HasFactory;

    protected $table = 'countries';

    protected $fillable = [
        'continent_id',
        'slug',
        'name',
        'code',
    ];

    public function continent()
    {
        return $this->belongsTo(Continent::class, 'continent_id', 'id');
    }

    public function locations()
    {
        return $this->hasMany(Location::class, 'country_id', 'id');
    }
    
    public function packages()
    { 
        return $this->hasMany(Package::class,'country_id','id'); 
    }

    public function faqs()
    {
        return $this->hasMany(CountryFaq::class,'country_id','id');
    }

    public function details(){
        return $this->hasOne(CountryDetails::class, 'country_id', 'id');
    }

    public function meta(){
        return $this->hasOne(CountryMetaData::class, 'country_id', 'id');
    }
}
