<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EnquiryCar extends Model
{
    use HasFactory;

    protected $table = 'enquiry_car';

    protected $fillable = [
        'name',
        'email',
        'phone',
        'from_city',
        'vehicle_type',
        'start_location',
        'end_location',
        'start_date',
        'return_date',
        'adult_count',
        'child_count',
        'is_confirmed',
        'is_deleted'
    ];

    protected $casts = [
        'is_deleted' => 'boolean'
    ];

}
