<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EnquiryHotel extends Model
{
    use HasFactory;

    protected $table = 'enquiry_hotel';

    protected $fillable = [
        'hotel_id',
        'name',
        'email',
        'phone',
        'adult_count',
        'child_count',
        'checking_date',
        'checkout_date',
        'room_type',
        'message',
        'is_confirmed',
        'is_deleted',
    ];

    protected $casts = [
        'is_deleted' => 'boolean'
    ];

    public function hotel()
    {
        return $this->belongsTo(Hotel::class, 'hotel_id');
    }
}
