<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EnquiryTrain extends Model
{
    use HasFactory;

    protected $table = 'enquiry_train'; // ✅ fix this table name

    protected $fillable = [
        'train_id',
        'train_tour_id',
        'name',
        'email',
        'phone',
        'message',
        'is_confirmed',
        'is_deleted',
    ];

    protected $casts = [
        'is_deleted'   => 'boolean',
    ];

    public function train()
    {
        return $this->belongsTo(Train::class, 'train_id');
    }

    public function tour()
    {
        return $this->belongsTo(TrainTour::class, 'train_tour_id');
    }
}
