<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Location extends Model
{
    use HasFactory;

    protected $table = 'locations';

    protected $fillable = [
        'country_id',
        'name',
        'slug',
        'is_top_trending',
        'is_active',
    ];

    public function country()
    {
        return $this->belongsTo(Country::class, 'country_id', 'id');
    }

    public function details()
    {
        return $this->hasOne(LocationDetails::class, 'location_id', 'id');
    }

    public function packages()
    { 
        return $this->hasMany(Package::class,'location_id','id'); 
    }

    public function faqs()
    {
        return $this->hasMany(LocationFaq::class,'location_id','id');
    } 

    public function meta()
    {
        return $this->hasOne(LocationMetaData::class,'location_id','id');
    } 
    
}
