<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Package extends Model
{
    protected $table = 'packages';

    protected $casts = [
        'is_active' => 'boolean',
        'is_deleted' => 'boolean',
    ];

    protected $fillable = [
        'title',
        'slug',
        'type',
        'category_id',
        'continent_id',
        'country_id',
        'location_id',
        'source_continent_id',
        'source_country_id',
        'source_location_id',
        'primary_image',
        'primary_image_alt',
        'is_featured',
        'is_top_trending',
        'short_description',
        'long_description',
        'is_active',
        'is_deleted',
        'is_customized'
    ];

    public function category()
    { 
        return $this->belongsTo(Category::class,'category_id','id'); 
    }
    
    public function source_location()
    { 
        return $this->belongsTo(Location::class,'source_location_id','id'); 
    }

    public function location()
    { 
        return $this->belongsTo(Location::class,'location_id','id'); 
    }

    public function country()
    { 
        return $this->belongsTo(Country::class,'country_id','id'); 
    }
    

    public function continent()
    { 
        return $this->belongsTo(Continent::class,'continent_id','id'); 
    }

    public function details()
    {
        return $this->hasOne(PackageDetail::class, 'package_id', 'id');
    }

    public function images()
    { 
        return $this->hasMany(PackageImage::class,'package_id','id'); 
    }

    public function itineraries()
    { 
        return $this->hasMany(PackageItinerary::class,'package_id','id'); 
    }

    public function faqs()
    {
        return $this->hasMany(PackageFaq::class,'package_id','id');
    }  
    
    public function enquiries()
    {
        return $this->hasMany(EnquiryPackage::class, 'package_id');
    }

    public function bookings()
    { 
        return $this->hasMany(Booking::class,'package_id','id'); 
    }

    public function reviews()
    { 
        return $this->hasMany(Review::class,'package_id','id');
    }

    public function meta()
    {
        return $this->hasOne(PackageMetaData::class, 'package_id', 'id');
    }
}
