<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Review extends Model 
{
    protected $fillable = [
        'package_id',
        'hotel_id',
        'car_id',
        'customer_name',
        'rating',
        'comment',
        'is_approved'
    ];

    public function package()
    { 
        return $this->belongsTo(Package::class, 'package_id', 'id'); 
    }

    public function hotel()
    { 
        return $this->belongsTo(Hotel::class, 'hotel_id', 'id'); 
    }

    // public function car()
    // { 
    //     return $this->belongsTo(Car::class, 'car_id', 'id'); 
    // }
}

