<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TrainTourDetails extends Model
{
    protected $table = 'train_tour_details';

    protected $casts = [
        'facilities' => 'array',
    ];

    protected $fillable = [
        'train_tour_id',
        'duration_days',
        'duration_nights',
        'itinerary_overview',
        'includes',
        'excludes',
        'route_details',
        'map_image',
        'facilities',
    ];

    // ✅ Correct relation
    public function trainTour()
    {
        return $this->belongsTo(TrainTour::class, 'train_tour_id', 'id');
    }
}
