@if ($paginator->lastPage() > 1)
    <ul class="pagination justify-content-center">
        
        {{-- Previous Page --}}
        <li class="page-item {{ $paginator->onFirstPage() ? 'disabled' : '' }}">
            <a href="{{ $paginator->previousPageUrl() }}" class="page-link">&lt;</a>
        </li>

        {{-- Page Numbers --}}
        @for ($i = 1; $i <= $paginator->lastPage(); $i++)
            <li class="page-item {{ $paginator->currentPage() == $i ? 'active' : '' }}">
                <a href="{{ $paginator->url($i) }}" class="page-link">{{ $i }}</a>
            </li>
        @endfor

        {{-- Next Page --}}
        <li class="page-item {{ !$paginator->hasMorePages() ? 'disabled' : '' }}">
            <a href="{{ $paginator->nextPageUrl() }}" class="page-link">&gt;</a>
        </li>
    </ul>
@endif
