@extends('layouts.app') 
@section('title','Edit Package')
@section('content')
<div class="container">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h2">
                    <i class="fas fa-edit me-2"></i>Edit Package
                </h1>
                <a href="{{ route('admin.packages.index') }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Back to Packages
                </a>
            </div>
        </div>
    </div>
    
    <div class="row">
        <div class="col-12">
            <form id="packageForm" method="POST" action="{{ route('admin.packages.update',$package->id) }}" enctype="multipart/form-data">
                @csrf 
                @method('PUT')
               
                {{-- Example field --}}
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">Package Information</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            {{-- Package Name --}}
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Package Name<span class="required-text">*</span></label>
                                    <input type="text" class="form-control @error('title') is-invalid @enderror" id="title" name="title"  value="{{ old('title',$package->title) }}" required>
                                    @error('title')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            {{-- Slug --}}
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Slug<span class="required-text">*</span></label>
                                    <input type="text" class="form-control rd-only @error('slug') is-invalid @enderror" id="slug" name="slug" value="{{ old('slug',$package->slug) }}" readonly>
                                    @error('slug')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                    <div class="invalid-feedback  d-none" id="slug-error"></div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-3">
                                <label>Type</label>
                                <select class="form-select @error('type') is-invalid @enderror" id="type" name="type" required>
                                    <option value="">Select Type<span class="required-text">*</span></option>
                                    @foreach(getPackageType() as $p)
                                        <option value="{{ $p->id }}" {{ old('type',$package->type) == $p->id ? 'selected':'' }}>{{ $p->name }}</option>
                                    @endforeach
                                </select>
                                @error('type')
                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-3">
                                <label>Category<span class="required-text">*</span></label>
                                <select class="form-select @error('category_id') is-invalid @enderror" id="category_id" name="category_id" required>
                                    @foreach($categories as $c)
                                        <option value="{{ $c->id }}" {{ old('category_id',$package->category_id) == $c->id ? 'selected':'' }}>{{ $c->name }}</option>
                                    @endforeach
                                </select>
                                @error('category_id')
                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>
                            {{-- Duration (Days) --}}
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="duration_days" class="form-label">Duration (Days)<span class="required-text">*</span></label>
                                    <input type="number" class="form-control @error('duration_days') is-invalid @enderror" 
                                    id="duration_days" name="duration_days" min="1" max="30" value="{{ old('duration_days',$package->details->duration_days) }}" onchange="generateItinerary()" required>
                                    @error('duration_days')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            {{-- Duration (Nights) --}}
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="duration_nights" class="form-label">Duration (Nights)<span class="required-text">*</span></label>
                                    <input type="number" class="form-control @error('duration_nights') is-invalid @enderror" id="duration_nights" name="duration_nights" min="0"max="30"  value="{{ old('duration_nights',$package->details->duration_nights) }}" onchange="generateItinerary()" required>
                                    @error('duration_nights')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            {{-- Price --}}
                            <!-- <div class="col-md-2">
                                <div class="mb-3">
                                    <label for="price" class="form-label">Cost ($)</label>
                                    <input type="number" step="0.01" class="form-control @error('price') is-invalid @enderror" id="price" name="price" value="{{ old('price',$package->price) }}" required>
                                    @error('price')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div> -->
                        </div>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="start_date" class="form-label">Start Date</label>
                                    <input type="date" class="form-control  @error('start_date') is-invalid @enderror" 
                                    id="start_date" name="start_date" value="{{ old('start_date', $package->details->start_date?->format('Y-m-d')) }}">
                                    @error('start_date')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="end_date" class="form-label">End Date</label>
                                    <input type="date" class="form-control  @error('end_date') is-invalid @enderror" 
                                    id="end_date" name="end_date" value="{{ old('start_date', $package->details->end_date?->format('Y-m-d')) }}">
                                    @error('end_date')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="featured" class="form-label">Exclusive?</label>
                                    <br/>
                                    <input type="checkbox" class="@error('is_featured') is-invalid @enderror" id="featured" 
                                    name="is_featured" value="1" {{ old('is_featured', $package->is_featured) ? 'checked' : '' }}>
                                    @error('is_featured')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>

                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="is_top_trending" class="form-label">Top Trending?</label>
                                    <br/>
                                    <input type="checkbox" class="@error('is_top_trending') is-invalid @enderror"  id="is_top_trending"  name="is_top_trending" value="1" {{ old('is_top_trending', $package->is_top_trending) ? 'checked' : '' }}>
                                    @error('is_top_trending')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <!-- <div class="col-md-2">
                                <div class="mb-3">
                                    <label for="is_top_trending" class="form-label">Customized?</label>
                                    <br/>
                                    <input type="checkbox" class="@error('is_customized') is-invalid @enderror"  id="is_customized"  name="is_customized" value="1" {{ old('is_customized', $package->is_customized) ? 'checked' : '' }}>
                                    @error('is_customized')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div> -->
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label for="tour_highlights" class="form-label">Tour Highlights<span class="required-text">*</span></label>
                                    <input type="text" class="form-control  @error('tour_highlights') is-invalid @enderror" id="tour_highlights" name="tour_highlights" value="{{ old('tour_highlights',$package->details->tour_highlights) }}" required>
                                    @error('tour_highlights')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            {{-- Short Description --}}
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="short_description" class="form-label">Short Description<span class="required-text">*</span></label>
                                    <textarea class="form-control tinymce @error('short_description') is-invalid @enderror" 
                                    id="short_description" name="short_description" rows="5">
                                        {{ old('short_description',$package->short_description) }}
                                    </textarea>
                                    @error('short_description')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                    <div class="invalid-feedback  d-none" id="short-description-error"></div>
                                </div>
                            </div>

                            {{-- Long Description --}}
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="long_description" class="form-label">Long Description<span class="required-text">*</span></label>
                                    <textarea class="form-control tinymce @error('long_description') is-invalid @enderror" 
                                    id="long_description" name="long_description" rows="5">
                                        {{ old('long_description',$package->long_description) }}
                                    </textarea>
                                    @error('long_description')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Gallery --}}
                <div class="card mt-3">
                    <div class="card-header bg-warning text-white">
                        <h5 class="mb-0">Package Gallery</h5>
                    </div>
                    <div class="card-body">
                        {{-- Primary Image --}}
                        <div class="card mt-3">
                            <div class="card-header">
                                <h6 class="mb-0">Primary Image<span class="required-text">*</span> (accept only .webp)</h6>
                            </div>
                            <div class="card-body">
                                <div class="row" id="praimaryPreview">
                                    @if($package->primary_image)
                                        <div class="col-md-12">
                                            <div class="card mb-3">
                                                <img src="{{ storage_link($package->primary_image) }}" class="card-img-top img-fluid" style="height:150px; object-fit:cover;">
                                            </div>
                                        </div>
                                    @endif
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <input type="text"  class="form-control @error('primary_image_alt') is-invalid @enderror"  id="primary_image_alt" name="primary_image_alt" 
                                           value="{{ old('primary_image_alt',$package->primary_image_alt) }}" required placeholder="Primary Image Alt">
                                            @error('primary_image_alt')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="mb-3">
                                            <input type="file" class="form-control @error('primary_image') is-invalid @enderror" id="primary_image" name="primary_image" accept=".webp,image/webp"
                                            {{!$package->primary_image ? 'required' : ''}} >
                                            @error('primary_image')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- Gallery Images --}}
                        <div class="card mt-3">
                            <div class="card-header">
                                <h6 class="mb-0">Gallery Images<span class="required-text">*</span>(accept only .webp)(Select Multiple Image)</h6>
                            </div>
                            <div class="card-body">
                                <div class="row" id="galleryPreview">
                                    @if($package->images->count())
                                        @foreach($package->images as $p)
                                            <div class="col-md-3 text-center" id="img-{{ $p->id }}">
                                                <div class="card mb-3">
                                                    {{-- ✅ Show image preview --}}
                                                    <img src="{{ storage_link($p->image_path) }}"
                                                        alt="{{ $p->image_alt ?? 'Package Image' }}"
                                                        class="card-img-top img-fluid  mb-2"
                                                        style="height:150px; object-fit:cover;">
                                                    <div class="card-body p-2">
                                                        <input type="text" 
                                                            name="existing_images_alt[{{ $p->id }}]" 
                                                            class="form-control"
                                                            placeholder="Image Alt"
                                                            value="{{ old('existing_images_alt.'.$p->id, $p->image_alt) }}">
                                                        <button type="button"
                                                                class="btn btn-sm btn-danger"
                                                                onclick="deleteImage({{ $p->id }})">
                                                            Delete
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    @endif
                                </div>
                                <div class="row mt-3">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <input type="file" name="images[]" id="galleryInput" multiple  class="form-control" accept=".webp,image/webp">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Location Selection -->
                <div class="card mt-3">
                    <div class="card-header bg-success text-white">
                        <h5 class="mb-0">Location</h5>
                    </div>
                    <div class="card-body">
                        <div class="card mt-3">
                            <div class="card-header">
                                <h6 class="mb-0">Source Location</h6>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    {{-- Continent --}}
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <label for="source_continent_id" class="form-label">Continent<span class="required-text">*</span></label>
                                            <select class="form-select continent_id @error('source_continent_id') is-invalid @enderror @if($package->type == 1) rd-only @endif" id="source_continent_id" name="source_continent_id"  onchange="loadCountries(this,'source')" required>
                                                <option value="">Select Continent</option>
                                                @foreach($continents as $c)
                                                    <option value="{{ $c->id }}" {{ old('source_continent_id',$package->source_continent_id) == $c->id ? 'selected' : '' }}>{{ $c->name }}</option>
                                                @endforeach
                                            </select>
                                            @error('source_continent_id')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    {{-- Country --}}
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <label for="source_country_id" class="form-label">Country<span class="required-text">*</span></label>
                                            <select class="form-select country_id @error('source_country_id') is-invalid @enderror @if($package->type == 1) rd-only @endif" id="source_country_id" name="source_country_id" onchange="loadCities(this,'source')" required>
                                                <option value="">Select Country</option>
                                                @foreach($source_countries as $c)
                                                    <option value="{{ $c->id }}" {{ old('source_country_id',$package->source_country_id) == $c->id ? 'selected' : '' }}>{{ $c->name }}</option>
                                                @endforeach
                                            </select>
                                            @error('source_country_id')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    {{-- City --}}
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <label for="source_location_id" class="form-label">City<span class="required-text">*</span></label>
                                            <select class="form-select location_id @error('source_location_id') is-invalid @enderror" id="source_location_id" name="source_location_id" required>
                                                <option value="">Select City</option>
                                                @foreach($source_locations as $l)
                                                    <option value="{{ $l->id }}" {{ old('source_location_id',$package->source_location_id) == $l->id ? 'selected' : '' }}>{{ $l->name }}</option>
                                                @endforeach
                                            </select>
                                            @error('source_location_id')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div> 
                        </div>
                        <div class="card mt-3">
                            <div class="card-header">
                                <h6 class="mb-0">Detination Location</h6>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    {{-- Continent --}}
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <label for="continent_id" class="form-label">Continent<span class="required-text">*</span></label>
                                            <select class="form-select continent_id @error('continent_id') is-invalid @enderror @if($package->type == 1) rd-only @endif" id="continent_id" name="continent_id" required onchange="loadCountries(this,'destination')">
                                                <option value="">Select Continent</option>
                                                @foreach($continents as $c)
                                                    <option value="{{ $c->id }}" {{ old('continent_id',$package->continent_id) == $c->id ? 'selected' : '' }}>{{ $c->name }}</option>
                                                @endforeach
                                            </select>
                                            @error('continent_id')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    {{-- Country --}}
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <label for="country_id" class="form-label">Country<span class="required-text">*</span></label>
                                            <select class="form-select country_id @error('country_id') is-invalid @enderror @if($package->type == 1) rd-only @endif" id="country_id" name="country_id" onchange="loadCities(this,'destination')" required>
                                                <option value="">Select Country</option>
                                                @foreach($countries as $c)
                                                    <option value="{{ $c->id }}" {{ old('country_id',$package->country_id) == $c->id ? 'selected' : '' }}>{{ $c->name }}</option>
                                                @endforeach
                                            </select>
                                            @error('country_id')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    {{-- City --}}
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <label for="location_id" class="form-label">City<span class="required-text">*</span></label>
                                            <select class="form-select location_id @error('location_id') is-invalid @enderror" id="location_id" name="location_id" required>
                                                <option value="">Select City</option>
                                                @foreach($locations as $l)
                                                    <option value="{{ $l->id }}" {{ old('location_id',$package->location_id) == $l->id ? 'selected' : '' }}>{{ $l->name }}</option>
                                                @endforeach
                                            </select>
                                            @error('location_id')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div> 
                        </div>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header bg-info text-white">
                        <h5 class="mb-0">Facilities</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            @foreach($facilities as $f)
                                <div class="col-md-2 mb-3">
                                    <label class="form-label">{{ $f->name }}</label>
                                    <input type="checkbox" 
                                        name="facilities[]"  
                                        value="{{ $f->icon }}"
                                        {{ in_array($f->icon, old('facilities', $package->details->facilities ?? [])) ? 'checked' : '' }}>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header bg-info text-white">
                        <h5 class="mb-0">Routes Details<span class="required-text">*</span></h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <input class="form-control  @error('route_details') is-invalid @enderror" id="route_details" name="route_details" value="{{ old('route_details',$package->details->route_details) }}" required placeholder="2N Srinagar | 2N Kashmir">
                                    @error('route_details')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                    <div class="invalid-feedback  d-none" id="route_details-error"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Itinerary --}}
                <div class="card mt-3">
                    <div class="card-header bg-warning text-white">
                        <h5 class="mb-0">Tour Itinerary<span class="required-text">*</span></h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <textarea class="form-control tinymce @error('itinerary_overview') is-invalid @enderror" name="itinerary_overview" rows="5" id="itinerary">{{ old('itinerary_overview',$package->details->itinerary_overview) }}</textarea>
                                    @error('itinerary_overview')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                    <div class="invalid-feedback d-none" id="itinerary-error"></div>
                                </div>
                            </div>
                        </div>
                        <div class="row" id="itinerary_days">
                            {{-- Prefill existing itineraries if needed --}}
                            @if($package->itineraries->count())
                                @foreach($package->itineraries as $i=>$it)
                                    <div class="col-md-6">
                                        <div class="card mt-3">
                                            <div class="card-header">
                                                <h6 class="mb-0">Day {{$i+1}}</h6>
                                            </div>
                                            <div class="card-body">
                                                <div class="mb-3">
                                                    <label for="itinerary_title_{{$i+1}}" class="form-label">Title<span class="required-text">*</span></label>
                                                    <input type="text" name="itineraries[{{ $i+1 }}][title]" value="{{ $it->title }}" class="form-control" id="itinerary_title_{{$i+1}}" required>
                                                </div>
                                                <div class="mb-3">
                                                    <textarea name="itineraries[{{ $i+1 }}][details]" class="form-control tinymce" id="itinerary_details_{{$i+1}}">{{ $it->details }}</textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            @endif
                        </div>
                    </div>
                </div>

                {{-- Inclusions/Exclusions --}}
                <div class="card mt-3">
                    <div class="card-header bg-info text-white">
                        <h5 class="mb-0">Cost Details</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="inclusions" class="form-label">Inclusions</label>
                                    <small> (*End with # after each inclusions item)</small>
                                    <textarea class="form-control  @error('includes') is-invalid @enderror" name="includes" rows="5" id="includes"  placeholder="Welcome drink on arrival # Accommodation at hotel #">{{ old('includes',$package->details->includes) }}</textarea>
                                    @error('includes')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="exclusions" class="form-label">Exclusions</label>
                                    <small> (*End with # after each exclusions item)</small>
                                    <textarea class="form-control   @error('excludes') is-invalid @enderror" name="excludes" rows="5" id="excludes" placeholder="5% GST # Peak season surcharges #">{{ old('excludes',$package->details->excludes) }}</textarea>
                                    @error('excludes')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card mt-3 d-none" id="package-exists-sce">
                    <div class="card-body text-center">
                        <div class="invalid-feedback d-block" id="package-exists"></div>
                    </div>
                </div>
                {{-- Submit --}}
                <div class="card mt-3">
                    <div class="card-body text-center">
                        <button type="submit" class="btn btn-success btn-lg" id="submit-btn">
                            <i class="fas fa-save me-2"></i>Update Package
                        </button>
                        <a href="{{ route('admin.packages.index') }}" class="btn btn-secondary btn-lg ms-2">
                            <i class="fas fa-times me-2"></i>Cancel
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    let selectedFiles = [];
    let imageCounter = 0;
    function loadCountries(continent, element = null, selectedCountry = null, selectedCity = null, callback = null){
        var ele = '';
        if(element == 'destination') {
            ele = '#country_id';
            $('#country_id').empty();
            $('#country_id').append('<option value="">Select Country</option>');
            $('#location_id').empty();
            $('#location_id').append('<option value="">Select City</option>');
        }else {
            ele = '#source_country_id';
            $('#source_country_id').empty();
            $('#source_country_id').append('<option value="">Select Country</option>');
            $('#source_location_id').empty();
            $('#source_location_id').append('<option value="">Select City</option>');
        }

        if (continent.value) {
            $.ajax({
                type: "GET",
                url: "{{ route('admin.countries.index') }}",
                data: {'continent_id':continent.value},
                success: function(res) {
                    if(res.countries.length) {
                        
                        if (typeof callback === "function") {
                            ele = '.country_id';
                        }
                        $.each(res.countries, function(key, value) {
                            $(ele).append('<option value="' + value.id + '"' + 
                                (selectedCountry == value.id ? ' selected' : '') + '>' + value.name +'</option>');
                        });
                        if (selectedCountry) {
                            loadCities({ value: selectedCountry },element, selectedCity, callback);
                        }
                    }
                    if (typeof callback === "function") {
                        callback(); // run after population
                    }
                }
            });
        }
    }

    function loadCities(country, element,selectedCity = null, callback=null){
        var ele = '';
        if(element == 'destination') {
            ele = '#location_id';
            $('#location_id').empty();
            $('#location_id').append('<option value="">Select City</option>');
        } else {
            ele = '#source_location_id';
            $('#source_location_id').empty();
            $('#source_location_id').append('<option value="">Select City</option>');
        }
        if (country.value) {
            $.ajax({
                type: "GET",
                url: "{{ route('admin.locations.index') }}",
                data: {'country_id':country.value},
                success: function(res) {
                    if(res.cities.length) {
                        if (typeof callback === "function") {
                            ele = '.location_id';
                        }
                        $.each(res.cities, function(key, value) {
                            $(ele).append('<option value="' + value.id + '"' + 
                                (selectedCity == value.id ? ' selected' : '') + '>' + value.name +'</option>');
                        });
                    }
                }
            });
        }
    }


    function generateItinerary() {
        let dnights = parseInt($('#duration_nights').val()) || 0;
        let ddays   = parseInt($('#duration_days').val()) || 0;
        let days    = Math.max(dnights, ddays); // total days

        let $container = $('#itinerary_days');
        let existingDays = $container.find('.day-card').length;

        // ✅ If days increased → add new cards after the last one
        if (days > existingDays) {
            for (let index = existingDays + 1; index <= days; index++) {
                let newDayHtml = `
                    <div class="col-md-6 day-card" id="day-${index}">
                        <div class="card mt-3">
                            <div class="card-header">
                                <h6 class="mb-0">Day ${index}</h6>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label for="itinerary_title_${index}" class="form-label">
                                        Title <span class="required-text">*</span>
                                    </label>
                                    <input type="text" class="form-control" 
                                        id="itinerary_title_${index}" 
                                        name="itineraries[${index}][title]" required>
                                </div>
                                <div class="mb-3">
                                    <label for="itinerary_details_${index}" class="form-label">
                                        Details
                                    </label>
                                    <textarea class="form-control tinymce" 
                                        id="itinerary_details_${index}" 
                                        name="itineraries[${index}][details]" 
                                        rows="5"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                `;
                $container.append(newDayHtml);
            }
        }

        // ✅ If days decreased → remove from last index only
        else if (days < existingDays) {
            for (let index = existingDays; index > days; index--) {
                // remove TinyMCE instance first (important)
                tinymce.remove(`#itinerary_details_${index}`);
                // then remove DOM node
                $(`#day-${index}`).remove();
            }
        }

        // ✅ Re-init TinyMCE only for new textareas
        $container.find('textarea.tinymce').each(function () {
            if (!tinymce.get(this.id)) {
                tinymce.init({
                    selector: `#${this.id}`,
                    menubar: false,
                    height: 200
                });
            }
        });

        if (typeof createSlug === "function") {
            createSlug(); // keep your slug logic safe
        }
    }


    function createSlug(){
        var title = $('#title').val().toLowerCase()
        .replace(/[^a-z0-9\s-]/g, '')
        .trim()
        .replace(/\s+/g, '-');
        var days = $('#duration_days').val();
        var nights = $('#duration_nights').val();
        let slug = '';
        if(title) slug += title;
        if(days) slug += '-'+days+'-days';
        if(nights) slug += '-'+nights+'-nights';
        $('#slug').val(slug);
    }

    function deleteImage(imageId){
        Swal.fire({
            title: "Are you sure?",
            text: "This image will be deleted!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#e3342f",
            cancelButtonColor: "#6c757d",
            confirmButtonText: "Yes, delete it",
            cancelButtonText: "Cancel",
            customClass: {
                popup: 'rounded-2xl shadow-lg',  // Rounded + shadow
                confirmButton: 'px-4 py-2 text-white',
                cancelButton: 'px-4 py-2 text-white'
            }
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "{{ route('admin.packages.images.delete') }}", // create this route
                    type: 'DELETE',
                    data: {
                        id: imageId
                    },
                    success: function(res){
                        if(res.success){
                            $('#img-' + imageId).remove();
                        } else {
                            toastr.error('Package image not deleted', 'Failed');
                        }
                    }
                });
            }
        });
    }

    function renderPreview(files) {
        let dt = new DataTransfer();
        $(".new-uplod").remove();
        files.forEach((file, index) => {
            if (file.type === 'image/webp') {
                dt.items.add(file); // keep valid file

                let reader = new FileReader();
                reader.onload = function(e) {
                    let col = `
                        <div class="col-md-3 text-center mb-3 new-uplod" data-filename="${file.name}">
                            <div class="card">
                                <img src="${e.target.result}" class="card-img-top img-fluid mb-2" 
                                    style="height:150px; object-fit:cover;">
                                <div class="card-body p-2">
                                    <input type="text" name="images_alt[]"  class="form-control" placeholder="Image Alt Text">
                                    <button type="button" class="btn btn-sm btn-danger remove-btn">Delete</button> 
                                </div>
                            </div>
                        </div>`;
                    $("#galleryPreview").append(col);
                };
                reader.readAsDataURL(file);
            }  else {
                toastr.error("Only .webp images are allowed!", 'Error');
            }
        });

        document.getElementById("galleryInput").files = dt.files;
        selectedFiles = Array.from(dt.files);
    }

    // delete only clicked image
    $(document).on("click", ".remove-btn", function() {
        let card = $(this).closest(".new-uplod");
        let fileName = card.data("filename"); // store filename instead of index

        // remove from selectedFiles by matching name
        selectedFiles = selectedFiles.filter(file => file.name !== fileName);

        // remove card only
        card.remove();

        // rebuild FileList
        let dt = new DataTransfer();
        selectedFiles.forEach((file) => {
            if (file.type === 'image/webp') {
                dt.items.add(file);
            }
        });

        document.getElementById("galleryInput").files = dt.files;
        selectedFiles = Array.from(dt.files);
    });





    $(document).ready(function () {
        let oldContinent = "{{ old('continent_id') }}";
        let oldCountry   = "{{ old('country_id') }}";
        let oldCity      = "{{ old('location_id') }}";

        if (oldContinent) {
            loadCountries({ value: oldContinent },null, oldCountry, oldCity);
        }

        $(document).on('input', '#title', function() {
            createSlug();
        });

        $(document).on('change', '#duration_nights', function() {
            createSlug();
        });

        $("#type").on("change", function() {
            let type = $(this).val();
            if (type == "1") { // National
                $(".continent_id")
                .val(1)
                .addClass("rd-only");      // add custom class

                // Call loadCountries with callback
                loadCountries({ value: 1 }, null, 1, null, function() {
                    $(".country_id")
                    .val(1)
                    .addClass("rd-only");
                });
                $('.location_id').empty();
                $('.location_id').append('<option value="">Select City</option>');
            } else { // International
                $(".continent_id")
                .removeClass("rd-only")
                .val("");

                $(".country_id")
                .removeClass("rd-only")
                .val("");

                $(".location_id")
                .removeClass("rd-only")
                .val("");
            }
        });

        $("#galleryInput").on("change", function(e) {
            selectedFiles = Array.from(e.target.files); // store files
            renderPreview(selectedFiles);
        });
        
    });

    document.getElementById('packageForm').addEventListener('submit', function(event) {
        tinymce.triggerSave();
        event.preventDefault(); // stop form first
        $('.invalid-feedback').text('');
        $('.invalid-feedback').addClass('d-none');
        let isError = 0;
        let description = document.getElementById('short_description');
        if(!description.value.trim()) {
            isError = 1;
            $('#short-description-error').removeClass('d-none');
            $('#short-description-error').addClass('d-block');
            $('#short-description-error').text('Short Descriptions required');
            $('html, body').animate({
                scrollTop: $("#short-description-error").offset().top - 100   // adjust -100 for some spacing from top
            }, 600);

        }

        let itinerary = document.getElementById('itinerary');
        if(!itinerary.value.trim()) {
            isError = 1;
            $('#itinerary-error').removeClass('d-none');
            $('#itinerary-error').addClass('d-block');
            $('#itinerary-error').text('Itinerary overview required');
            $('html, body').animate({
                scrollTop: $("#itinerary-error").offset().top - 100   // adjust -100 for some spacing from top
            }, 600);

        }
        // let excludes = document.getElementById('excludes');
        // if(!excludes.value.trim()) {
        //     isError = 1;
        //     $('#excludes-error').removeClass('d-none');
        //     $('#excludes-error').addClass('d-block');
        //     $('#excludes-error').text('Exclusions required');
        //     $('html, body').animate({
        //         scrollTop: $("#excludes-error").offset().top - 100   // adjust -100 for some spacing from top
        //     }, 600);

        // }
        // let includes = document.getElementById('includes');
        // if(!includes.value.trim()) {
        //     isError = 1;
        //     $('#includes-error').removeClass('d-none');
        //     $('#includes-error').addClass('d-block');
        //     $('#includes-error').text('Inclusions required');
        //     $('html, body').animate({
        //         scrollTop: $("#includes-error").offset().top - 100   // adjust -100 for some spacing from top
        //     }, 600);

        // }

        if(!isError){
            let $btn = $("#submit-btn");
            // Disable button + show loading text
            $btn.prop("disabled", true).text("Please wait...");
            let form = this;
            let title = document.getElementById('title').value.trim();
            let days = document.getElementById('duration_days').value.trim();
            let nights = document.getElementById('duration_nights').value.trim();
            let slug = document.getElementById('slug').value.trim();
            let type = document.getElementById('type').value;
            let catId = document.getElementById('category_id').value;
            let locationId = document.getElementById('location_id').value;
            let sourceLocationId = document.getElementById('source_location_id').value;
            let slugError = document.getElementById('package-exists-sce');
            slugError.classList.add('d-none');
            $.ajax({
                type: "GET",
                url: "{{ route('admin.packages.slug.duplicate_check') }}",
                data: {
                    'id':"{{$package->id}}",
                    'title':title,
                    'duration_days':days,
                    'duration_nights':nights,
                    'slug':slug,
                    'category_id':catId,
                    'type':type,
                    'location_id':locationId,
                    'source_location_id':sourceLocationId
                },
                success: function(res) {
                    if (res.exists) {
                        $btn.prop("disabled", false).text("Update Package");
                        slugError.classList.remove('d-none');
                        $('#package-exists').removeClass('d-none');
                        $('#package-exists').text('Package combination already exists in packages');
                    } else {
                        slugError.classList.add('d-none');
                        form.submit();
                    }
                },
                error:function(err){
                    form.submit();
                }
            });
        }
    });

    /* ==== Primary Image Preview ==== */
    document.getElementById('primary_image').addEventListener('change', function(event) {
        let input = event.target;
        let file = input.files[0];
        let preview = document.getElementById('praimaryPreview');
        // Clear old preview

        let dt = new DataTransfer(); // For rebuilding file list

        if (file && (file.type === 'image/webp' || file.name.toLowerCase().endsWith('.webp'))) {
            dt.items.add(file); // Keep valid file

            let reader = new FileReader();
            reader.onload = function(e) {
                let col = document.createElement('div');
                col.classList.add('col-md-12', 'mb-3');
                col.innerHTML = `
                    <div class="card">
                        <img src="${e.target.result}" class="card-img-top img-fluid" 
                            style="height:150px; object-fit:cover;">
                    </div>
                `;
                preview.innerHTML = ""; 
                preview.appendChild(col);
            };
            reader.readAsDataURL(file);
        } else {
            toastr.error("Only .webp images are allowed!", 'Error');
            input.value = ""; // reset invalid file
        }

        // Replace with filtered file list (empty if invalid)
        input.files = dt.files;
    });
</script>
    
@endsection