@extends('layouts.app') 
@section('title','Edit Train Tour')
@section('content')
<div class="container">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h2">
                    <i class="fas fa-plus me-2"></i>Edit Train Tour
                </h1>
                <a href="{{ route('admin.page-settings.luxury-train') }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Back to Luxury Trains
                </a>
            </div>
        </div>
    </div>
    
    <div class="row">
        <div class="col-12">
            <form id="packageForm" method="POST" action="{{ route('admin.train-tours.update',$trainTour->id) }}" enctype="multipart/form-data">
               @csrf 
                @method('PUT')
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">Tour Information</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="title" class="form-label">Tour Title<span class="required-text">*</span></label>
                                    <input type="text" class="form-control @error('title') is-invalid @enderror" 
                                    id="title" name="title" value="{{ old('title',$trainTour->title) }}" required>
                                    @error('title')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            {{-- Slug --}}
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="slug" class="form-label">Slug<span class="required-text">*</span></label>
                                    <input type="text" class="form-control rd-only @error('slug') is-invalid @enderror" 
                                    id="slug" name="slug" value="{{ old('slug',$trainTour->slug) }}" readonly placeholder="Auto Generated Slug">
                                    @error('slug')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                    <div class="invalid-feedback d-none" id="slug-error"></div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="train_id" class="form-label">Train<span class="required-text">*</span></label>
                                    <select class="form-select @error('train_id') is-invalid @enderror" id="train_id" name="train_id" required>
                                        <option value="">Select Train</option>
                                        @foreach($trains as $t)
                                            <option data-slug="{{$t->slug}}" value="{{ $t->id }}" {{ old('train_id',$trainTour->train_id) == $t->id ? 'selected':'' }}>{{ $t->title }}</option>
                                        @endforeach
                                    </select>
                                    @error('train_id')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            {{-- Duration (Days) --}}
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="duration_days" class="form-label">Duration (Days)<span class="required-text">*</span></label>
                                    <input type="number" class="form-control @error('duration_days') is-invalid @enderror" 
                                    id="duration_days" name="duration_days" min="1" max="30" value="{{ old('duration_days',$trainTour->details->duration_days) }}" onchange="generateItinerary()" required>
                                    @error('duration_days')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            {{-- Duration (Nights) --}}
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="duration_nights" class="form-label">Duration (Nights)<span class="required-text">*</span></label>
                                    <input type="number" class="form-control @error('duration_nights') is-invalid @enderror" id="duration_nights" name="duration_nights" min="0" max="30"  value="{{ old('duration_days',$trainTour->details->duration_nights) }}" onchange="generateItinerary()" required>
                                    @error('duration_nights')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="description" class="form-label">Short Description<span class="required-text">*</span></label>
                                    <textarea class="form-control tinymce @error('description') is-invalid @enderror" 
                                    id="description" name="description" rows="5">
                                        {{ old('short_description',$trainTour->description) }}
                                    </textarea>
                                    @error('description')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                    <div class="invalid-feedback d-none" id="description-error"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="refund_cancellation_policy" class="form-label">Refund Cancellation Policy<span class="required-text">*</span></label>
                                    <textarea class="form-control tinymce @error('refund_cancellation_policy') is-invalid @enderror" id="refund_cancellation_policy" name="refund_cancellation_policy" rows="5">    
                                        {{ old('short_description',$trainTour->refund_cancellation_policy) }}
                                    </textarea>
                                    @error('refund_cancellation_policy')
                                        <div class="invalid-feedback d-block" id="refund-error">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header bg-warning text-white">
                        <h5 class="mb-0">Package Gallery</h5>
                    </div>
                    <div class="card-body">
                        <div class="row" id="praimaryPreview">
                            @if($trainTour->primary_image)
                                <div class="col-md-12">
                                    <div class="card mb-3">
                                        <img src="{{ storage_link($trainTour->primary_image) }}" class="card-img-top img-fluid" style="height:150px; object-fit:cover;">
                                    </div>
                                </div>
                            @endif
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <input type="file" class="form-control @error('primary_image') is-invalid @enderror" id="primary_image" name="primary_image" accept=".webp,image/webp"
                                    {{!$trainTour->primary_image ? 'required' : ''}} >
                                    @error('primary_image')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card mt-3">
                    <div class="card-header bg-success text-white">
                        <h5 class="mb-0">Facilities</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            @foreach($facilities as $f)
                                <div class="col-md-2 mb-3">
                                    <label class="form-label">{{ $f->name }}</label>
                                    <input type="checkbox" 
                                        name="facilities[]"  
                                        value="{{ $f->icon }}"
                                        {{ in_array($f->icon, old('facilities', $trainTour->details->facilities ?? [])) ? 'checked' : '' }}>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
                <div class="card mt-3">
                    <div class="card-header bg-info text-white">
                        <h5 class="mb-0">Routes Details<span class="required-text">*</span></h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <input class="form-control  @error('route_details') is-invalid @enderror" id="route_details" name="route_details" value="{{ old('route_details',$trainTour->details->route_details) }}" required placeholder="Srinagar-Kashmir">
                                    @error('route_details')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                    <div class="invalid-feedback  d-none" id="route_details-error"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header bg-warning text-white">
                        <h5 class="mb-0">Route Map</h5>
                    </div>
                    <div class="card-body">
                        <div class="card mt-3">
                            <div class="card-header">
                                <h6 class="mb-0">Map Image<span class="required-text">*</span></h6>
                            </div>
                            <div class="card-body">
                                <div class="row" id="mapPreview">
                                    @if($trainTour->details->map_image)
                                        <div class="col-md-12">
                                            <div class="card mb-3">
                                                <img src="{{ storage_link($trainTour->details->map_image) }}" class="card-img-top img-fluid" style="height:50% !important; width:50% !important; object-fit:cover;">
                                            </div>
                                        </div>
                                    @endif
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <input type="file"  class="form-control @error('map_image') is-invalid @enderror"  id="map_image" name="map_image" accept=".jpg,.jpeg,.png,.webp,image/jpeg,image/png,image/webp" {{!$trainTour->details->map_image ? 'required' : ''}}>
                                            @error('map_image')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Itinerary -->
                <div class="card mt-3">
                    <div class="card-header bg-success text-white">
                        <h5 class="mb-0">Tour Itinerary<span class="required-text">*</span></h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <textarea class="form-control @error('itinerary_overview') is-invalid @enderror" 
                                    id="itinerary" name="itinerary_overview" rows="5" required>{{ old('itinerary_overview',$trainTour->details->itinerary_overview) }}</textarea>
                                    @error('itinerary_overview')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row" id="itinerary_days">
                            {{-- Prefill existing itineraries if needed --}}
                            @if($trainTour->itineraries->count())
                                @foreach($trainTour->itineraries as $i=>$it)
                                    <div class="col-md-6">
                                        <div class="card mt-3">
                                            <div class="card-header">
                                                <h6 class="mb-0">Day {{$i+1}}</h6>
                                            </div>
                                            <div class="card-body">
                                                <div class="mb-3">
                                                    <label for="itinerary_title_{{$i+1}}" class="form-label">Title<span class="required-text">*</span></label>
                                                    <input type="text" name="itineraries[{{ $i+1 }}][title]" value="{{ $it->title }}" class="form-control" id="itinerary_title_{{$i+1}}" required>
                                                </div>
                                                <div class="mb-3">
                                                    <textarea name="itineraries[{{ $i+1 }}][details]" class="form-control" id="itinerary_details_{{$i+1}}">{{ $it->details }}</textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Inclusions & Exclusions -->
                <div class="card mt-3">
                    <div class="card-header bg-info text-white">
                        <h5 class="mb-0">Cost Details</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            {{-- Inclusions --}}
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="inclusions" class="form-label">Inclusions</label>
                                    <small> (*End with # after each includes item)</small>
                                    <textarea class="form-control  @error('includes') is-invalid @enderror" id="includes" name="includes" rows="5"  placeholder="Welcome drink on arrival # Accommodation at hotel #">{{ old('includes',$trainTour->details->includes) }}</textarea>
                                    @error('includes')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                    <div class="invalid-feedback  d-none" id="includes-error"></div>
                                </div>
                            </div>

                            {{-- Exclusions --}}
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="exclusions" class="form-label">Exclusions</label>
                                    <small> (*End with # after each exclude item)</small>
                                    <textarea class="form-control  @error('excludes') is-invalid @enderror" id="excludes" name="excludes" rows="5"  placeholder="5% GST # Peak season surcharges #"> {{ old('excludes',$trainTour->details->excludes) }}</textarea>
                                    @error('excludes')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                    <div class="invalid-feedback  d-none" id="excludes-error"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mt-3 d-none" id="tour-exists-sce">
                    <div class="card-body text-center">
                        <div class="invalid-feedback d-block" id="tour-exists"></div>
                    </div>
                </div>
                <!-- Submit Button -->
                <div class="card mt-3">
                    <div class="card-body text-center">
                        <button type="submit" class="btn btn-primary btn-lg" id="submitBtn">
                            <i class="fas fa-save me-2"></i>Update Tour
                        </button>
                        <a href="{{ route('admin.page-settings.luxury-train') }}" class="btn btn-secondary btn-lg ms-2">
                            <i class="fas fa-times me-2"></i>Cancel
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@section('scripts')
<script>

    function generateItinerary(){
        let dnights = $('#duration_nights').val();
        let ddays = $('#duration_days').val();
        days = (dnights >= ddays) ? dnights : ddays;

        let itineraryHtml = '';
        for (let index = 1; index <= days; index++) {
            itineraryHtml+= '<div class="col-md-6">';
                itineraryHtml+= '<div class="card mt-3">';
                    itineraryHtml+= '<div class="card-header">';
                        itineraryHtml+= '<h6 class="mb-0">Day '+index+'</h6>';
                    itineraryHtml+= '</div>';
                    itineraryHtml+= '<div class="card-body">';
                        itineraryHtml+= '<div class="mb-3">';
                            itineraryHtml+= '<label for="itinerary_title_'+index+'" class="form-label">Title<span class="required-text">*</span></label>';
                            itineraryHtml+= '<input type="text" class="form-control" id="itinerary_title_'+index+'" name="itineraries['+index+'][title]" required>';
                        itineraryHtml+= '</div>';
                        itineraryHtml+= '<div class="mb-3">';
                            itineraryHtml+= '<textarea class="form-control" id="itinerary_details_'+index+'" name="itineraries['+index+'][details]" rows="5" placeholder=""></textarea>';
                        itineraryHtml+= '</div>';
                    itineraryHtml+= '</div>';
                itineraryHtml+= '</div>';
            itineraryHtml+= '</div>';
        }
        $('#itinerary_days').html(itineraryHtml);
        createSlug();
    }

    function createSlug(){
        var title = $('#title').val().toLowerCase()
        .replace(/[^a-z0-9\s-]/g, '')
        .trim()
        .replace(/\s+/g, '-');
        var train = $('#train_id').find('option:selected').data('slug');
        let slug = '';
        if(title) slug += title;
        if(train) slug += '-'+train;
        $('#slug').val(slug);
    }

    $(document).ready(function () {
        $(document).on('input', '#title', function() {
            createSlug();
        });

        $(document).on('change', '#train_id', function() {
            createSlug();
        });

    });

    document.getElementById('packageForm').addEventListener('submit', function(event) {
        tinymce.triggerSave();
        event.preventDefault(); // stop form first
        $('.invalid-feedback').text('');
        $('.invalid-feedback').addClass('d-none');

        let isError = 0;
        let description = document.getElementById('description');
        if(!description.value.trim()) {
            isError = 1;
            $('#description-error').removeClass('d-none');
            $('#description-error').addClass('d-block');
            $('#description-error').text('Short Descriptions required');
            $('html, body').animate({
                scrollTop: $("#description-error").offset().top - 100   // adjust -100 for some spacing from top
            }, 600);

        }
        let refund = document.getElementById('refund_cancellation_policy');
        if(!refund.value.trim()) {
            isError = 1;
            $('#refund-error').removeClass('d-none');
            $('#refund-error').addClass('d-block');
            $('#refund-error').text('Refund / Cancellation Plicy required');
            $('html, body').animate({
                scrollTop: $("#refund-error").offset().top - 100   // adjust -100 for some spacing from top
            }, 600);

        }


        if(!isError){
            let $btn = $("#submitBtn");
            // Disable button + show loading text
            $btn.prop("disabled", true).text("Please wait...");

            let form = this;
            let title = document.getElementById('title').value.trim();
            let train = $('#train_id').val();
            let slugError = document.getElementById('tour-exists-sce');
            slugError.classList.add('d-none');
            $.ajax({
                type: "GET",
                url: "{{ route('admin.train-tours.slug.duplicate_check') }}",
                data: {
                    'id':"{{$trainTour->id}}",
                    'title':title,
                    'train_id':train
                },
                success: function(res) {
                    if (res.exists) {
                        $btn.prop("disabled", false).text("Update Tour");
                        slugError.classList.remove('d-none');
                        $('#tour-exists').show();
                        $('#tour-exists').text('Tour already exists');
                        $('html, body').animate({
                            scrollTop: $("#slug-error").offset().top - 100   // adjust -100 for some spacing from top
                        }, 600);
                    } else {
                        slugError.classList.add('d-none');
                        form.submit();
                    }
                },
                error:function(err){
                    form.submit();
                }
            });
        }
    });
</script>
<script>
    /* ==== Primary Image Preview ==== */
    document.getElementById('primary_image').addEventListener('change', function(event) {
        let input = event.target;
        let file = input.files[0];
        let preview = document.getElementById('praimaryPreview');
         // Clear old preview

        let dt = new DataTransfer(); // For rebuilding file list

        if (file && (file.type === 'image/webp')) {
            dt.items.add(file); // Keep valid file

            let reader = new FileReader();
            reader.onload = function(e) {
                let col = document.createElement('div');
                col.classList.add('col-md-12', 'mb-3');
                col.innerHTML = `
                    <div class="card">
                        <img src="${e.target.result}" class="card-img-top img-fluid" 
                            style="height:150px; object-fit:cover;">
                    </div>
                `;
                preview.innerHTML = "";
                preview.appendChild(col);
            };
            reader.readAsDataURL(file);
        } else {
            toastr.error("Only .webp images are allowed!", 'Error');
            input.value = ""; // reset invalid file
        }

        // Replace with filtered file list (empty if invalid)
        input.files = dt.files;
    });

    document.getElementById('map_image').addEventListener('change', function(event) {
        let input = event.target;
        let file = input.files[0];
        let preview = document.getElementById('mapPreview');

        let reader = new FileReader();
        reader.onload = function(e) {
            let col = document.createElement('div');
            col.classList.add('col-md-12', 'mb-3');
            col.innerHTML = `
                <div class="card">
                    <img src="${e.target.result}" class="card-img-top img-fluid"
                   style="height:50% !important; width:50% !important">
                </div>
            `;
            preview.innerHTML = "";
            preview.appendChild(col);
        };
        reader.readAsDataURL(file);
        

    });
</script>

@endsection
