<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>{{ $subject ?? 'Enquiry' }}</title>
</head>
<body>
    <h2>{{ $data['name'] ?? 'Customer' }},</h2>

    @if(isset($data['is_admin_view']) && $data['is_admin_view'])
        <p>You have received a new enquiry. Details below:</p>
    @else
        <p>Thank you for contacting us. We received your enquiry — we will get back to you soon.</p>
    @endif

    <h4>Enquiry Details</h4>
    <table cellpadding="4">
        @foreach($data as $key => $value)
            @if(!in_array($key, ['is_admin_view']) && !empty($value))
                <tr>
                    <td style="font-weight:bold;">{{ ucfirst(str_replace('_',' ', $key)) }}:</td>
                    <td>{{ $value }}</td>
                </tr>
            @endif
        @endforeach
    </table>

    <p>Regards,<br/>Cholan Tours Team</p>
</body>
</html>
