<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="csrf-token" content="{{ csrf_token() }}">
        <title>@yield('title')</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
        <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
        <link href="{{ asset('/public/css/styles.css') }}" rel="stylesheet">
        <link href="https://cdnjs.cloudflare.com/ajax/libs/switchery/0.8.2/switchery.min.css" rel="stylesheet">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    </head>
    <body>
        <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
            <div class="container-fluid">
                <a class="navbar-brand" href="{{ route('admin.dashboard') }}">
                    <img src="{{ public_link('logo-white-text-black-tagline.webp') }}" height="50">
                </a>
                
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                    <span class="navbar-toggler-icon"></span>
                </button>
                
                <div class="collapse navbar-collapse" id="navbarNav">
                    <ul class="navbar-nav me-auto">
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}" href="{{ route('admin.dashboard') }}">
                                <i class="fas fa-tachometer-alt me-1"></i>Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('admin.categories.*') ? 'active' : '' }}" href="{{ route('admin.categories.index') }}">
                                <i class="fas fa-tags me-1"></i>Categories
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('admin.locations.*') ? 'active' : '' }}" href="{{ route('admin.locations.index') }}">
                                <i class="fas fa-globe me-1"></i>Locations
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('admin.packages.*') ? 'active' : '' }}" href="{{ route('admin.packages.index') }}">
                                <i class="fas fa-box me-1"></i>Packages
                            </a>
                        </li>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle {{ request()->routeIs('admin.page-settings.*') ? 'active' : '' }}" href="#" id="inquiriesDropdown" role="button" data-bs-toggle="dropdown">
                                <i class="fas fa-cog me-1"></i>Page Settings
                            </a>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="{{ route('admin.page-settings.home') }}">Home Page</a></li>
                                <li><a class="dropdown-item" href="{{ route('admin.page-settings.india') }}">India Page</a></li>
                                <li><a class="dropdown-item" href="{{ route('admin.page-settings.srilanka') }}">Sri Lanka Page</a></li>
                                <li><a class="dropdown-item" href="{{ route('admin.page-settings.customized-holiday') }}">Customized Holiday Page</a></li>
                                <li><a class="dropdown-item" href="{{ route('admin.page-settings.international') }}">International Page</a></li>
                                <li><a class="dropdown-item" href="{{ route('admin.page-settings.luxury-train') }}">Luxury Train Page</a></li>
                                <li><a class="dropdown-item" href="{{ route('admin.page-settings.luxury-hotel') }}">Luxury Hotel Page</a></li>
                                <li><a class="dropdown-item" href="{{ route('admin.page-settings.car') }}">Car Page</a></li>
                                <li><a class="dropdown-item" href="{{ route('admin.promotional-ads.index') }}">Promotional Ads</a></li>
                            </ul>
                        </li>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle {{ request()->routeIs('admin.enquiries.*') ? 'active' : '' }}" href="#" id="inquiriesDropdown" role="button" data-bs-toggle="dropdown">
                                <i class="fas fa-envelope me-1"></i>Enquiries
                            </a>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="{{ route('admin.enquiries.packages') }}">Tour Booking</a></li>
                                <li><a class="dropdown-item" href="{{ route('admin.enquiries.cars') }}">Car Booking</a></li>
                                <!-- <li><a class="dropdown-item" href="inquiries-cab.html">Cab Booking</a></li> -->
                                <li><a class="dropdown-item" href="{{ route('admin.enquiries.trains') }}">Train Booking</a></li>
                                <li><a class="dropdown-item" href="{{ route('admin.enquiries.hotels') }}">Hotel Booking</a></li>
                                <li><a class="dropdown-item" href="{{ route('admin.enquiries.customized') }}">Customized Tour Booking</a></li>
                                <li><a class="dropdown-item" href="{{ route('admin.enquiries.general') }}">General Enquiries</a></li>
                            </ul>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('admin.reviews.*') ? 'active' : '' }}" href="{{ route('admin.reviews.packages') }}">
                                <i class="fas fa-comment me-1"></i>Reviews
                            </a>
                        </li>
                    </ul>
                    
                    <ul class="navbar-nav">
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown">
                                <i class="fas fa-user me-1"></i>Admin
                            </a>
                            <ul class="dropdown-menu dropdown-menu-end">
                                <li><a class="dropdown-item" href="{{ route('admin.logout') }}">
                                    <i class="fas fa-sign-out-alt me-1"></i>Logout
                                </a></li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>
        <main class="container-fluid mt-4">
            @yield('content')
        </main>
        @yield('modal')
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/switchery/0.8.2/switchery.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/5.10.0/tinymce.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

        <script>

            toastr.options = {
                closeButton: true,
                progressBar: true,
                positionClass: "toast-top-right",
                timeOut: "3000"
            };

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            let elems = Array.prototype.slice.call(document.querySelectorAll('.js-switch'));
            elems.forEach(function(html) {
                let switchery = new Switchery(html,  { size: 'medium' });
            });

            const s3BaseUrl = "{{ Storage::disk('s3')->url('') }}"; // gives base S3 URL
        </script>
        <script>
            (function() {
                const WORD_LIMIT = 700;       // TinyMCE word limit
                const MAX_LENGTH = 250;       // Input/textarea char limit
                const WARNING_TIME = 2000;    // Toast duration (ms)

                // 🔸 Simple toast-like warning
                function showWarning(el, msg) {
                    if (el.dataset.warned) return; // prevent duplicates
                    el.dataset.warned = true;

                    const warn = document.createElement('div');
                    warn.textContent = msg;
                    Object.assign(warn.style, {
                        position: 'fixed',
                        bottom: '20px',
                        right: '20px',
                        background: '#ff4d4d',
                        color: '#fff',
                        padding: '8px 12px',
                        borderRadius: '6px',
                        zIndex: 99999,
                        fontSize: '14px',
                        boxShadow: '0 2px 6px rgba(0,0,0,0.15)'
                    });
                    document.body.appendChild(warn);

                    setTimeout(() => {
                        warn.remove();
                        delete el.dataset.warned;
                    }, WARNING_TIME);
                }

                // 🔸 Enforce global character limit on normal inputs & textareas
                function enforceCharLimit(e) {
                    const el = e.target;
                    if (el.tagName !== 'INPUT' && el.tagName !== 'TEXTAREA') return;
                    if (el.tagName === 'INPUT' && el.type !== 'text') return;

                    let val = el.value;
                    if (val.length > MAX_LENGTH) {
                        el.value = val.substring(0, MAX_LENGTH);
                        showWarning(el, `Max ${MAX_LENGTH} characters allowed.`);
                    }
                }

                document.addEventListener('input', enforceCharLimit, true);
                document.addEventListener('paste', function(e) {
                    const el = e.target;
                    if (el.tagName === 'INPUT' || el.tagName === 'TEXTAREA') {
                        setTimeout(() => enforceCharLimit({ target: el }), 10);
                    }
                }, true);

                // 🔸 Initialize TinyMCE with word limit and editable code editor
                function initTinyMCEOn($textarea) {
                    if (!$textarea.attr('id')) {
                        $textarea.attr('id', 'tinymce_' + Math.random().toString(36).substr(2, 9));
                    }
                    const id = $textarea.attr('id');

                    tinymce.init({
                        selector: `#${id}`,
                        menubar: true,
                        statusbar: true,
                        plugins: [
                            'advlist autolink lists charmap print preview hr pagebreak',
                            'searchreplace wordcount visualblocks visualchars fullscreen',
                            'insertdatetime media nonbreaking save table directionality',
                            'emoticons template paste textcolor colorpicker textpattern'
                        ],
                        toolbar: 'bold italic underline | bullist numlist | alignleft aligncenter alignright alignjustify',
                        branding: false,
                        setup: function(editor) {
                            editor.on('change', () => editor.save());

                            // Word limit enforcement
                            const enforceWordLimit = () => {
                                const text = editor.getContent({ format: 'text' }).trim();
                                const words = text.split(/\s+/).filter(w => w.length > 0);
                                if (words.length > WORD_LIMIT) {
                                    showWarning(editor.getElement(), `Word limit exceeded! Max ${WORD_LIMIT} words.`);
                                    const trimmed = words.slice(0, WORD_LIMIT).join(' ');
                                    editor.setContent(trimmed);
                                    editor.selection.select(editor.getBody(), true);
                                    editor.selection.collapse(false);
                                }
                            };

                            editor.on('input', enforceWordLimit);
                            editor.on('paste', () => setTimeout(enforceWordLimit, 10));

                            editor.on('keydown', function(e) {
                                const text = editor.getContent({ format: 'text' }).trim();
                                const words = text.split(/\s+/).filter(w => w.length > 0);
                                if (words.length >= WORD_LIMIT && e.key.length === 1 && !e.ctrlKey && !e.metaKey && !e.altKey) {
                                    e.preventDefault();
                                    showWarning(editor.getElement(), `Word limit of ${WORD_LIMIT} reached.`);
                                }
                            });

                            // Make code editor always editable
                            editor.on('ExecCommand', function(e) {
                                if (e.command === 'mceCodeEditor') {
                                    setTimeout(() => {
                                        const codeArea = document.querySelector('.tox-textarea');
                                        if (codeArea) {
                                            codeArea.removeAttribute('readonly');
                                            codeArea.removeAttribute('type');
                                            codeArea.setAttribute('name', 'editbox');
                                            codeArea.setAttribute('id', 'editbox');
                                            codeArea.focus();
                                        }
                                    }, 100);
                                }
                            });
                        }
                    });
                }

                // ---------------------------
                // Initialize TinyMCE on page load & modals
                // ---------------------------
                $(document).ready(function() {
                    $('textarea.tinymce').each(function() { initTinyMCEOn($(this)); });
                });

                $(document).on('shown.bs.modal', function() {
                    $(this).find('textarea.tinymce').each(function() { initTinyMCEOn($(this)); });
                });

                console.log(`✅ TinyMCE word limit (${WORD_LIMIT}) and global input limit (${MAX_LENGTH}) active`);
            })();
        </script>




        @yield('scripts')
    </body>
</html>