<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\PackageController;
use App\Http\Controllers\Api\CategoryController;
use App\Http\Controllers\Api\SettingsController;
use App\Http\Controllers\Api\TrainController;
use App\Http\Controllers\Api\HotelController;
use App\Http\Controllers\Api\CarController;
use App\Http\Controllers\Api\EnquiryController;
use App\Http\Controllers\Api\ReviewController;


Route::prefix('v1')->group(function () {
    Route::post('register',[AuthController::class,'register']);
    Route::post('login',[AuthController::class,'login']);
    Route::middleware('auth:sanctum')->post('logout',[AuthController::class,'logout']);

    Route::middleware('public.token')->group(function () {
        Route::get('page/settings/menu', [SettingsController::class, 'menu']);

        Route::get('page/settings/home', [SettingsController::class, 'home']);

        Route::get('page/settings/international', [SettingsController::class, 'international']);

        Route::get('page/settings/india', [SettingsController::class, 'india']);

        Route::get('page/settings/srilanka', [SettingsController::class, 'srilanka']);

        Route::get('page/settings/customized-holidays', [SettingsController::class, 'customizedHolidays']);

        Route::get('page/settings/luxury-train', [SettingsController::class, 'luxuryTrain']);

        Route::get('page/settings/luxury-hotel', [SettingsController::class, 'luxuryHotel']);

        Route::get('page/settings/car', [SettingsController::class, 'car']);

        Route::get('packages/exclusive', [PackageController::class, 'exclusivePackages']);

        Route::get('packages/top-trending-country', [PackageController::class, 'topTrendingCountryPackages']);

        Route::get('packages/top-trending-international', [PackageController::class, 'topTrendingInterNationalPackages']);

        Route::get('packages/discover-india', [PackageController::class, 'discoverIndiaTourPackages']);
        
        Route::get('package/{slug}', [PackageController::class, 'packageDetails']);

        Route::get('packages/city/{slug}', [PackageController::class, 'packagesByLoction']);

        Route::get('packages/countries/international', [PackageController::class, 'internationalCountries']);

        // rote will be deleted
        Route::get('packages/international', [PackageController::class, 'internationalPackagesByCountry']);
        Route::get('packages/categories/international', [CategoryController::class, 'packagesByCategory']);

        Route::get('packages/category/{category}', [CategoryController::class, 'packagesByCategory']);

        Route::get('packages/{slug}', [PackageController::class, 'packagesByCountry']);

        Route::get('packages/categories/country', [CategoryController::class, 'countryPackagesByCategory']);

        Route::get('luxury-trains', [TrainController::class, 'index']);

        Route::get('luxury-trains/{slug}', [TrainController::class, 'trainDetails']);
        
        Route::get('luxury-train/tour/{slug}', [TrainController::class, 'tourDetails']);

        Route::get('luxury-hotels', [HotelController::class, 'index']);

        Route::get('luxury-hotels/{slug}', [HotelController::class, 'hotelDetails']);

        Route::get('cars', [CarController::class, 'index']);

        Route::get('route/cars', [CarController::class, 'getCarsByRoute']);

    
        Route::post('enquiries/package', [EnquiryController::class, 'storePackage']);

        Route::post('enquiries/train', [EnquiryController::class, 'storeTrain']);
        
        Route::post('enquiries/hotel', [EnquiryController::class, 'storeHotel']);

        Route::post('enquiries/general', [EnquiryController::class, 'storeGeneral']);

        Route::post('enquiries/plan_trip', [EnquiryController::class, 'storePlanTrip']);

        Route::post('enquiries/car', [EnquiryController::class, 'storeCar']);

        Route::get('reviews/packages', [ReviewController::class, 'packageReviews']);
        Route::get('reviews/package/{slug}', [ReviewController::class, 'packageReviewsBySlug']);

        Route::get('reviews/hotels', [ReviewController::class, 'hotelReviews']);
        Route::get('reviews/hotel/{slug}', [ReviewController::class, 'hotelReviewsBySlug']);

        Route::get('reviews/cars', [ReviewController::class, 'carReviews']);
        Route::get('reviews/car/{slug}', [ReviewController::class, 'carReviewsBySlug']);

        Route::post('review', [ReviewController::class, 'store']);

    });

    
});

Route::fallback(function () {
    abort(404);
});
