<?php $__env->startSection('title','Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h2">
                    <i class="fas fa-cog me-2"></i>Home Page Settings
                </h1>
            </div>
        </div>
    </div>
     <!-- Action Buttons -->
    <div class="row mb-4">
        <div class="col-12">
            <button class="btn btn-primary me-2" onclick="addBanner();">
                <i class="fas fa-plus me-2"></i>Add Slider Banner
            </button>
            <button class="btn btn-success me-2" onclick="addStaticBanner();">
                <i class="fas fa-plus me-2"></i>Add Single Banner
            </button>
            <button class="btn btn-warning" onclick="addSpecialPackage();">
                <i class="fas fa-plus me-2"></i>Add Special Package
            </button>
            <button class="btn btn-danger" onclick="addTourService();">
                <i class="fas fa-plus me-2"></i>Add Tour Service
            </button>
            <button class="btn btn-warning page-meta" data-id="<?php echo e($page_details->id); ?>" data-url="<?php echo e(route('admin.page-meta.show.meta',$page_details->id)); ?>">
                <i class="fas fa-globe me-2"></i>Home Page Meta Info
                <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
            </button>
        </div>
    </div>
    
    <!-- Inquiry Type Tabs -->
    <div class="row mb-3">
        <div class="col-12">
            <ul class="nav nav-pills">
                <li class="nav-item">
                    <a class="nav-link tab_link <?php echo e((session('active_tab') && session('active_tab') == 'banner') ? 'active' :''); ?> <?php echo e(!session('active_tab') ? 'active' : ''); ?>"  data-tab="banner_tab">
                        <i class="fas fa-image me-1"></i>Slider Banner
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link tab_link <?php echo e((session('active_tab') && session('active_tab') == 'sbanner') ? 'active' :''); ?>" data-tab="sbanner_tab">
                        <i class="fas fa-image me-1"></i>Single Banner
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link tab_link <?php echo e((session('active_tab') && session('active_tab') == 'spackage') ? 'active' :''); ?>" data-tab="spackage_tab">
                        <i class="fas fa-box me-1"></i>Special Package
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link tab_link <?php echo e((session('active_tab') && session('active_tab') == 'tservice') ? 'active' :''); ?>" data-tab="tservice_tab">
                        <i class="fas fa-cog me-1"></i>Tour Service
                    </a>
                </li>
            </ul>
        </div>
    </div>
    
    <div class="row tab_details <?php echo e((session('active_tab') && session('active_tab') != 'banner') ? 'd-none' :''); ?>" id="banner_tab">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-image me-2"></i>Banners
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="bg-light">
                                <tr>
                                    <th>Package</th>
                                    <th>Title</th>
                                    <th>Image</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $banners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <strong class="text-primary d-block"><?php echo e($b->package->title); ?> <?php echo e($b->package->details->duration_days.' D/'.$b->package->details->duration_nights.' N'); ?></strong>
                                        <small class="text-muted"><?php echo e($b->package->category->name); ?> (<?php echo e($b->package->source_location->name.', '.$b->package->source_location->country->name.' -> '.$b->package->location->name.', '.$b->package->location->country->name); ?>)</small>
                                    </td>
                                    <td>
                                        <div>
                                            <small class="d-block"><?php echo e($b->title); ?></small>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="card mb-3">
                                            <img id="page-banner-image" src="<?php echo e(storage_link($b->banner_image)); ?>" class="card-img-top img-fluid" style="height:50px; object-fit:cover;">
                                        </div>
                                    </td>
                                    <td>
                                        <input id="status_<?php echo e($b->id); ?>" type="checkbox" data-id="<?php echo e($b->id); ?>" data-url="<?php echo e(route('admin.banners.update',$b->id)); ?>" class="js-switch banner-status" <?php echo $b->is_active == 1 ? 'checked' : '' ?>>
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary edit-banner" data-id="<?php echo e($b->id); ?>" data-url="<?php echo e(route('admin.banners.edit',$b->id)); ?>">
                                            <i class="fas fa-edit icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                        <button class="btn btn-sm btn-outline-danger delete-banner" data-id="<?php echo e($b->id); ?>" data-url="<?php echo e(route('admin.banners.destroy',$b->id)); ?>">
                                            <i class="fas fa-trash icon"></i>
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row tab_details <?php echo e((session('active_tab') && session('active_tab') == 'sbanner') ? '' :'d-none'); ?>" id="sbanner_tab">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-image me-2"></i>Single Banners
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="bg-light">
                                <tr>
                                    <th>Package</th>
                                    <th>Title</th>
                                    <th>Image</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $static_banners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <strong class="text-primary d-block"><?php echo e($b->package->title); ?> <?php echo e($b->package->details->duration_days.' D/'.$b->package->details->duration_nights.' N'); ?></strong>
                                        <small class="text-muted"><?php echo e($b->package->category->name); ?> (<?php echo e($b->package->source_location->name.', '.$b->package->source_location->country->name.' -> '.$b->package->location->name.', '.$b->package->location->country->name); ?>)</small>
                                    </td>
                                    <td>
                                        <div>
                                            <small class="d-block"><?php echo e($b->title); ?></small>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="card mb-3">
                                            <img id="page-banner-image" src="<?php echo e(storage_link($b->banner_image)); ?>" class="card-img-top img-fluid" style="height:50px; object-fit:cover;">
                                        </div>
                                    </td>
                                    <td>
                                        <input id="status_<?php echo e($b->id); ?>" type="checkbox" data-id="<?php echo e($b->id); ?>" data-url="<?php echo e(route('admin.banners.update',$b->id)); ?>" class="js-switch banner-status" <?php echo $b->is_active == 1 ? 'checked' : '' ?>>
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary edit-banner" data-id="<?php echo e($b->id); ?>" data-url="<?php echo e(route('admin.banners.edit',$b->id)); ?>">
                                            <i class="fas fa-edit icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                        <button class="btn btn-sm btn-outline-danger delete-banner" data-id="<?php echo e($b->id); ?>" data-url="<?php echo e(route('admin.banners.destroy',$b->id)); ?>">
                                            <i class="fas fa-trash icon"></i>
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row tab_details <?php echo e((session('active_tab') && session('active_tab') == 'spackage') ? '' :'d-none'); ?>" id="spackage_tab">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-warning text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-image me-2"></i>Special Packages
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="bg-light">
                                <tr>
                                    <th>Package</th>
                                    <th>Title</th>
                                    <th>Image</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $special_packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <strong class="text-primary d-block"><?php echo e($b->package->title); ?> <?php echo e($b->package->details->duration_days.' D/'.$b->package->details->duration_nights.' N'); ?></strong>
                                        <small class="text-muted"><?php echo e($b->package->category->name); ?> (<?php echo e($b->package->source_location->name.', '.$b->package->source_location->country->name.' -> '.$b->package->location->name.', '.$b->package->location->country->name); ?>)</small>
                                    </td>
                                    <td>
                                        <div>
                                            <small class="d-block"><?php echo e($b->title); ?></small>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="card mb-3">
                                            <img id="page-banner-image" src="<?php echo e(storage_link($b->banner_image)); ?>" class="card-img-top img-fluid" style="height:50px; object-fit:cover;">
                                        </div>
                                    </td>
                                    <td>
                                        <input id="status_<?php echo e($b->id); ?>" type="checkbox" data-id="<?php echo e($b->id); ?>" data-url="<?php echo e(route('admin.spackages.update',$b->id)); ?>" class="js-switch banner-status" <?php echo $b->is_active == 1 ? 'checked' : '' ?>>
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary edit-banner" data-id="<?php echo e($b->id); ?>" data-url="<?php echo e(route('admin.spackages.edit',$b->id)); ?>">
                                            <i class="fas fa-edit icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                        <button class="btn btn-sm btn-outline-danger delete-banner" data-id="<?php echo e($b->id); ?>" data-url="<?php echo e(route('admin.spackages.destroy',$b->id)); ?>">
                                            <i class="fas fa-trash icon"></i>
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row tab_details <?php echo e((session('active_tab') && session('active_tab') == 'tservice') ? '' :'d-none'); ?>" id="tservice_tab">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-danger text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-cog me-2"></i>Tour Services
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="bg-light">
                                <tr>
                                    <th>Title</th>
                                    <th>Link</th>
                                    <th>Image</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <strong class="text-primary d-block"><?php echo e($s->title); ?></strong>
                                    </td>
                                    <td>
                                        <div>
                                            <small class="d-block"><?php echo e($s->link); ?></small>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="card mb-3">
                                            <img id="page-service-image" src="<?php echo e(storage_link($s->banner_image)); ?>" class="card-img-top img-fluid" style="height:50px; object-fit:cover;">
                                        </div>
                                    </td>
                                    <td>
                                        <input id="service_status_<?php echo e($s->id); ?>" type="checkbox" data-id="<?php echo e($s->id); ?>" data-url="<?php echo e(route('admin.tour-services.update',$s->id)); ?>" class="js-switch service-status" <?php echo $s->is_active == 1 ? 'checked' : '' ?>>
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary edit-service" data-id="<?php echo e($s->id); ?>" data-url="<?php echo e(route('admin.tour-services.edit',$s->id)); ?>" data-upurl="<?php echo e(route('admin.tour-services.update',$s->id)); ?>">
                                            <i class="fas fa-edit icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                        <button class="btn btn-sm btn-outline-danger delete-service" data-id="<?php echo e($s->id); ?>" data-url="<?php echo e(route('admin.tour-services.destroy',$s->id)); ?>">
                                            <i class="fas fa-trash icon"></i>
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('modal'); ?>
<div class="modal fade" id="addBannerModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title">
                    <i class="fas fa-plus me-2"></i><span id="modal-header-text">Add New Banner</span>
                </h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="addBanner">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="banner_title" class="form-label">Title</label>
                        <input type="text" class="form-control" id="banner_title" name="title" required>
                        <div class="text-danger d-none" id="banner-title-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="banner_package_id" class="form-label">Select Package</label>
                        <select class="form-select" id="banner_package_id" name="package_id" required>
                            <option value="">Choose a package...</option>
                            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($p->id); ?>"><?php echo e($p->title); ?>(<?php echo e($p->details->duration_days.' D/'.$p->details->duration_nights.' N'); ?>)(<?php echo e($p->category->name); ?>)(<?php echo e($p->source_location->name.', '.$p->source_location->country->name.' -> '.$p->location->name.', '.$p->location->country->name); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <div class="text-danger d-none" id="banner-package-id-error"></div>
                    </div>
                    <div class="row" id="bannerPreview"></div>
                    <div class="mb-3">
                        <label for="banner_image" class="form-label">Image</label>
                        <input type="file" class="form-control mb-2" id="banner_image" name="banner_image" accept=".webp,image/webp" required>
                        <div class="text-danger d-none" id="banner-image-error"></div>

                        <input type="text" class="form-control" id="banner_image_alt" name="banner_image_alt" required placeholder="Banner Image Alt Text">
                        <div class="text-danger d-none" id="banner-image-alt-error"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning banner-submit-btn">
                        <i class="fas fa-save me-2"></i>Save Banner
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="editBannerModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title">
                    <i class="fas fa-pencil me-2"></i>Edit Banner
                </h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="editBanner" data-url="">
                <?php echo csrf_field(); ?> 
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="edit_banner_title" class="form-label">Title</label>
                        <input type="text" class="form-control" id="edit_banner_title" name="title" required>
                        <div class="text-danger d-none" id="edit-banner-title-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="edit_banner_package_id" class="form-label">Select Package</label>
                        <select class="form-select" id="edit_banner_package_id" name="package_id" required>
                            <option value="">Choose a package...</option>
                            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($p->id); ?>"><?php echo e($p->title); ?>(<?php echo e($p->details->duration_days.' D/'.$p->details->duration_nights.' N'); ?>)(<?php echo e($p->category->name); ?>)(<?php echo e($p->source_location->name.', '.$p->source_location->country->name.' -> '.$p->location->name.', '.$p->location->country->name); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <div class="text-danger d-none" id="edit-banner-package-id-error"></div>
                    </div>
                    <div class="row" id="bannerPreviewEdit">
                        <div class="col-md-12">
                            <div class="card mb-3">
                                <img id="edit-banner-image" src="" class="card-img-top img-fluid" style="height:150px; object-fit:cover;">
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="edit_banner_image" class="form-label">Image</label>
                        <input type="file" class="form-control mb-2" id="edit_banner_image" name="banner_image" accept=".webp,image/webp">
                        <div class="text-danger d-none" id="edit-banner-image-error"></div>

                        <input type="text" class="form-control" id="edit_banner_image_alt" name="banner_image_alt" required placeholder="Banner Image Alt Text">
                        <div class="text-danger d-none" id="edit-banner-image-alt-error"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning edit-banner-submit-btn">
                        <i class="fas fa-save me-2"></i>Save Banner
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="addServiceModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title">
                    <i class="fas fa-plus me-2"></i><span id="modal-header-text">Add Tour Service</span>
                </h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="addService" action="<?php echo e(route('admin.tour-services.store')); ?>" method="POST">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="service_title" class="form-label">Title</label>
                        <input type="text" class="form-control" id="service_title" name="title" required>
                        <div class="text-danger d-none" id="service-title-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="service_link" class="form-label">Navigate Link</label>
                        <input type="text" class="form-control" id="service_link" name="link" required>
                        <div class="text-danger d-none" id="service-link-error"></div>
                    </div>
                    <div class="row" id="servicePreview"></div>
                    <div class="mb-3">
                        <label for="service_image" class="form-label">Image</label>
                        <input type="file" class="form-control mb-2" id="service_image" name="banner_image" accept=".webp,image/webp" required>
                        <div class="text-danger d-none" id="service-image-error"></div>

                        <input type="text" class="form-control" id="service_image_alt" name="banner_image_alt" required placeholder="Image Alt Text">
                        <div class="text-danger d-none" id="service-image-alt-error"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning service-submit-btn">
                        <i class="fas fa-save me-2"></i>Save Tour Service
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="editServiceModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title">
                    <i class="fas fa-pencil me-2"></i>Edit Tour Service
                </h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="editService" data-url="" method="POST">
                <?php echo csrf_field(); ?> 
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="edit_service_title" class="form-label">Title</label>
                        <input type="text" class="form-control" id="edit_service_title" name="title" required>
                        <div class="text-danger d-none" id="edit-service-title-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="edit_service_link" class="form-label">Navigate Link</label>
                        <input type="text" class="form-control" id="edit_service_link" name="link" required>
                        <div class="text-danger d-none" id="edit-service-link-error"></div>
                    </div>
                    <div class="row" id="servicePreviewEdit">
                        <div class="col-md-12">
                            <div class="card mb-3">
                                <img id="edit-service-image" src="" class="card-img-top img-fluid" style="height:150px; object-fit:cover;">
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="edit_service_image" class="form-label">Image</label>
                        <input type="file" class="form-control mb-2" id="edit_service_image" name="banner_image" accept=".webp,image/webp">
                        <div class="text-danger d-none" id="edit-service-image-error"></div>

                        <input type="text" class="form-control" id="edit_service_image_alt" name="banner_image_alt" required placeholder="Image Alt Text">
                        <div class="text-danger d-none" id="edit_service-image-alt-error"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning edit-service-submit-btn">
                        <i class="fas fa-save me-2"></i>Save Tour Service
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<div class="modal fade" id="pageMetaModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title" id="page-title">Edit Meta Info</h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="pageMeta" method="POST" action="<?php echo e(route('admin.page.update',$page_details->id)); ?>" enctype="multipart/form-data">
            <?php echo csrf_field(); ?> 
            <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <input type="hidden" name="meta_setting">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="page_meta_title" class="form-label">Meta Title<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="page_meta_title" name="meta_title" required>
                                <div class="text-danger d-none" id="page-meta-title-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="page_meta_description" class="form-label">Meta Description<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="page_meta_description" name="meta_description" required>
                                <div class="text-danger d-none" id="page-meta-description-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="page_meta_keywords" class="form-label">Meta Keywords<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="page_meta_keywords" name="meta_keywords" required>
                                <div class="text-danger d-none" id="page-meta-keyords-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="page_h1_heading" class="form-label">H1 Heading<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="page_h1_heading" name="h1_heading" required>
                                <div class="text-danger d-none" id="page-meta-keyords-error"></div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="mb-3">
                            <label for="page_meta_details" class="form-label">Extra Meta Tag<span class="required-text">*</span></label>
                            <textarea class="form-control"  name="meta_details" id="page_meta_details" rows="5" id="meta_details"></textarea>
                            <div class="text-danger d-none" id="page-meta-details-error"></div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning" id="update-page-meta-btn">
                        <i class="fas fa-save me-2"></i>Update Meta Setting
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    function activeTab(ele){
        // Remove active from all nav links
        let nav = document.querySelectorAll('.tab_link');
        nav.forEach(function(element) {
            element.classList.remove('active');
            if (element.getAttribute('data-tab') === ele) {
                element.classList.add('active');
            }
        });

        // Hide all tabs
        let tab = document.querySelectorAll('.tab_details');
        tab.forEach(function(element) {
            element.classList.add('d-none');
        });

        let selectTab = document.getElementById(ele);
        if (selectTab) {
            selectTab.classList.remove('d-none');
        }
    }

    function addBanner() {
        activeTab('banner_tab');
        let oldInput = document.querySelector('.static-input');
        if (oldInput) {
            oldInput.remove();
        }

        let addBanner = document.getElementById('addBanner');
        addBanner.action = "<?php echo e(route('admin.banners.store')); ?>";

        let headerText = document.getElementById('modal-header-text');
        headerText.innerText  = 'Add New Banner';

        let bannerModal = new bootstrap.Modal(document.getElementById('addBannerModal'));
        bannerModal.show();
    }


    function addStaticBanner() {
        activeTab('sbanner_tab');
        let addBanner = document.getElementById('addBanner');
        addBanner.action = "<?php echo e(route('admin.banners.store')); ?>";
        let hiddenInput = document.createElement('input');
        hiddenInput.type = 'hidden';
        hiddenInput.name = 'is_static';
        hiddenInput.value = '1';
        hiddenInput.classList.add('static-input');
        addBanner.appendChild(hiddenInput);

        let headerText = document.getElementById('modal-header-text');
        headerText.innerText  = 'Add New Banner';

        let bannerModal = new bootstrap.Modal(document.getElementById('addBannerModal'));
        bannerModal.show();
    }

    function addSpecialPackage() {
        activeTab('spackage_tab');
        let oldInput = document.querySelector('.static-input');
        if (oldInput) {
            oldInput.remove();
        }

        let headerText = document.getElementById('modal-header-text');
        headerText.innerText  = 'Add New Special Package';

        let addBanner = document.getElementById('addBanner');
        addBanner.action = "<?php echo e(route('admin.spackages.store')); ?>";

        let bannerModal = new bootstrap.Modal(document.getElementById('addBannerModal'));
        bannerModal.show();
    }

    function addTourService() {
        activeTab('tservice_tab');
        let oldInput = document.querySelector('.static-input');
        if (oldInput) {
            oldInput.remove();
        }

        let serviceModal = new bootstrap.Modal(document.getElementById('addServiceModal'));
        serviceModal.show();
    }

    

    $(document).ready(function () {
        <?php if(session('success')): ?>
            toastr.success("<?php echo e(session('success')); ?>", 'Success');
        <?php endif; ?>

        $(document).on('click', '.tab_link', function() {
            $('.tab_link').removeClass('active');
            $(this).addClass('active');
            $('.tab_details').addClass('d-none');
            let ele = $(this).data('tab');
            $('#'+ele).removeClass('d-none');
        });

        
        $(document).on('change', '.banner-status', function() {
            let checkbox = $(this);
            let package_status = checkbox.prop('checked') === true ? 1 : 0;
            $.ajax({
                type: "PUT",
                dataType: "json",
                url: $(this).data('url'),
                data: {
                    'status': package_status
                },
                success: function(data) {
                    Swal.fire({
                        icon: data.status,
                        title: data.status,
                        text: data.message
                    }).then(() => {
                        location.reload();
                    });
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    checkbox.prop('checked', !package_status);
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while processing your request.'
                    });
                }

            });
        });

        document.getElementById('banner_image').addEventListener('change', function(event) {
            let input = event.target;
            let file = event.target.files[0];
            let preview = document.getElementById('bannerPreview');
            

            if (file && file.type === 'image/webp') {
                let reader = new FileReader();
                reader.onload = function(e) {
                    let col = document.createElement('div');
                    col.classList.add('col-md-12', 'mb-3');
                    col.innerHTML = `
                        <div class="card">
                            <img src="${e.target.result}" class="card-img-top img-fluid" 
                                style="height:150px; object-fit:cover;">
                        </div>
                    `;
                    preview.innerHTML = ""; // Clear old preview
                    preview.appendChild(col);
                };
                reader.readAsDataURL(file);
            } else {
                toastr.error("Only .webp images are allowed!", 'Error');
                input.value = ""; // reset invalid file
                preview.innerHTML = ""; // Clear old preview
            }
        });

        $('#addBanner').on('submit', function(e) {
            e.preventDefault();
            $('.banner-submit-btn').attr('disabled',true);
            $('.text-danger').addClass('d-none');
            let formData = new FormData(this);
            $.ajax({
                type: "POST",
                url: $(this).attr('action'),
                data: formData,
                contentType: false,  // must be false for FormData
                processData: false,
                success: function(response) {
                    $('#addBanner')[0].reset();
                    $('.banner-submit-btn').removeAttr('disabled');
                    $('#addBannerModal').modal('hide');
                    toastr.success('Banner added successfully!', 'Success');
                    $('.text-danger').addClass('d-none');
                    setTimeout(function(){
                        location.reload();
                    }, 1000);
                },
                error: function(xhr) {
                    $('.banner-submit-btn').removeAttr('disabled');
                    if(xhr.status === 422) {
                        let errors = xhr.responseJSON.errors;
                        if (errors.title) $('#banner-title-error').text(errors.title[0]);
                        if (errors.package_id) $('#banner-package-id-error').text(errors.package_id[0]);
                        if (errors.banner_image) $('#banner-image-error').text(errors.banner_image[0]);
                        $('.text-danger').removeClass('d-none');
                    }
                }
            });
        });

        $(document).on('click', '.edit-banner', function () {
            let btn = $(this);
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            let dataUrl = $(this).data('url');
            $.ajax({
                url: dataUrl,
                type: 'GET',
                success: function (data) {
                    $('#edit_banner_package_id').val(data.package_id);
                    $('#edit_banner_title').val(data.title);
                    $('#edit_banner_image_alt').val(data.banner_image_alt);
                    $('#edit-banner-image').attr('src',s3BaseUrl+data.banner_image);
                    $('#editBanner').attr('data-url',dataUrl.replace('/edit',''));
                    $('#editBannerModal').modal('show');
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while fetching category details.'
                    });
                },
                complete: function () {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                }
            });
        });

        $('#editBanner').on('submit', function(e) {
            e.preventDefault();
            $('.edit-banner-submit-btn').attr('disabled',true);
            $('.text-danger').addClass('d-none');
            let formData = new FormData(this);
            $.ajax({
                type: "POST",
                url: $(this).data('url'),
                data: formData,
                contentType: false,  // must be false for FormData
                processData: false,
                success: function(response) {
                    $('#editBanner')[0].reset();
                    $('.edit-banner-submit-btn').removeAttr('disabled');
                    $('#editBannerModal').modal('hide');
                    toastr.success('Banner updated successfully!', 'Success');
                    $('.text-danger').addClass('d-none');
                    setTimeout(function(){
                        location.reload();
                    }, 1000);
                },
                error: function(xhr) {
                    $('.edit-banner-submit-btn').removeAttr('disabled');
                    if(xhr.status === 422) {
                        let errors = xhr.responseJSON.errors;
                        if (errors.title) $('#edit-banner-title-error').text(errors.title[0]);
                        if (errors.package_id) $('#edit-banner-package-id-error').text(errors.package_id[0]);
                        if (errors.banner_image) $('#edit-banner-image-error').text(errors.package_id[0]);
                        $('.text-danger').removeClass('d-none');
                    }
                }
            });
        });

        $(document).on("click", ".delete-banner", function(e) {
            e.preventDefault();
            let itemId = $(this).data("id");
            let itemUrl = $(this).data("url");
            let row = $(this).closest("tr"); // parent <tr>
            Swal.fire({
                title: "Are you sure?",
                text: "This item will be deleted!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#e3342f",
                cancelButtonColor: "#6c757d",
                confirmButtonText: "Yes, delete it",
                cancelButtonText: "Cancel",
                customClass: {
                    popup: 'rounded-2xl shadow-lg',  // Rounded + shadow
                    confirmButton: 'px-4 py-2 text-white',
                    cancelButton: 'px-4 py-2 text-white'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: itemUrl,
                        success: function(res) {
                            if(res.success){
                                row.remove();
                                Swal.fire(
                                    "Deleted!",
                                    "The item has been deleted successfully.",
                                    "success"
                                );
                            }
                        },
                        error: function(xhr) {
                            toastr.error('Banner not deleted!', 'Failed');
                        }
                    });
                    
                }
            });
        });

        document.getElementById('edit_banner_image').addEventListener('change', function(event) {
            let input = event.target;
            let file = event.target.files[0];
            let preview = document.getElementById('bannerPreviewEdit');
            

            if (file && file.type === 'image/webp') {
                let reader = new FileReader();
                reader.onload = function(e) {
                    let col = document.createElement('div');
                    col.classList.add('col-md-12', 'mb-3');
                    col.innerHTML = `
                        <div class="card">
                            <img src="${e.target.result}" class="card-img-top img-fluid" 
                                style="height:150px; object-fit:cover;">
                        </div>
                    `;
                    preview.innerHTML = ""; // Clear old preview
                    preview.appendChild(col);
                };
                reader.readAsDataURL(file);
            } else {
                toastr.error("Only .webp images are allowed!", 'Error');
                input.value = ""; // reset invalid file
            }
        });


        $(document).on('change', '.service-status', function() {
            let checkbox = $(this);
            let service_status = checkbox.prop('checked') === true ? 1 : 0;
            $.ajax({
                type: "PUT",
                dataType: "json",
                url: $(this).data('url'),
                data: {
                    'status': service_status
                },
                success: function(data) {
                    Swal.fire({
                        icon: data.status,
                        title: data.status,
                        text: data.message
                    });
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    checkbox.prop('checked', !service_status);
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while processing your request.'
                    });
                }

            });
        });

        document.getElementById('service_image').addEventListener('change', function(event) {
            let input = event.target;
            let file = event.target.files[0];
            let preview = document.getElementById('servicePreview');
            

            if (file && file.type === 'image/webp') {
                let reader = new FileReader();
                reader.onload = function(e) {
                    let col = document.createElement('div');
                    col.classList.add('col-md-12', 'mb-3');
                    col.innerHTML = `
                        <div class="card">
                            <img src="${e.target.result}" class="card-img-top img-fluid" 
                                style="height:150px; object-fit:cover;">
                        </div>
                    `;
                    preview.innerHTML = ""; // Clear old preview
                    preview.appendChild(col);
                };
                reader.readAsDataURL(file);
            } else {
                toastr.error("Only .webp images are allowed!", 'Error');
                input.value = ""; // reset invalid 
                preview.innerHTML = ""; // Clear old preview
            }
        });

        $('#addService').on('submit', function(e) {
            e.preventDefault();
            $('.service-submit-btn').attr('disabled',true);
            $('.text-danger').addClass('d-none');
            let formData = new FormData(this);
            $.ajax({
                type: "POST",
                url: $(this).attr('action'),
                data: formData,
                contentType: false,  // must be false for FormData
                processData: false,
                success: function(response) {
                    $('#addService')[0].reset();
                    $('.service-submit-btn').removeAttr('disabled');
                    $('#addServiceModal').modal('hide');
                    toastr.success('Tour Service added successfully!', 'Success');
                    $('.text-danger').addClass('d-none');
                    setTimeout(function(){
                        location.reload();
                    }, 1000);
                },
                error: function(xhr) {
                    $('.service-submit-btn').removeAttr('disabled');
                    if(xhr.status === 422) {
                        let errors = xhr.responseJSON.errors;
                        if (errors.title) $('#service-title-error').text(errors.title[0]);
                        if (errors.link) $('#service-link-error').text(errors.link[0]);
                        if (errors.banner_image) $('#service-image-error').text(errors.banner_image[0]);
                        $('.text-danger').removeClass('d-none');
                    }
                }
            });
        });

        $(document).on('click', '.edit-service', function () {
            let btn = $(this);
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            let dataUrl = $(this).data('url');
            let dataupUrl = $(this).data('upurl');
            $.ajax({
                url: dataUrl,
                type: 'GET',
                success: function (data) {
                    $('#edit_service_link').val(data.link);
                    $('#edit_service_title').val(data.title);
                    $('#edit_service_image_alt').val(data.banner_image_alt);
                    $('#edit-service-image').attr('src',s3BaseUrl+data.banner_image);
                    $('#editService').attr('data-url',dataupUrl);
                    $('#editServiceModal').modal('show');
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while fetching service details.'
                    });
                },
                complete: function () {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                }
            });
        });

        $('#editService').on('submit', function(e) {
            e.preventDefault();
            $('.edit-service-submit-btn').attr('disabled',true);
            $('.text-danger').addClass('d-none');
            let formData = new FormData(this);
            $.ajax({
                type: "POST",
                url: $(this).data('url'),
                data: formData,
                contentType: false,  // must be false for FormData
                processData: false,
                success: function(response) {
                    $('#editService')[0].reset();
                    $('.edit-service-submit-btn').removeAttr('disabled');
                    $('#editServiceModal').modal('hide');
                    toastr.success('Service updated successfully!', 'Success');
                    $('.text-danger').addClass('d-none');
                    setTimeout(function(){
                        location.reload();
                    }, 1000);
                },
                error: function(xhr) {
                    $('.edit-service-submit-btn').removeAttr('disabled');
                    if(xhr.status === 422) {
                        let errors = xhr.responseJSON.errors;
                        if (errors.title) $('#edit-service-title-error').text(errors.title[0]);
                        if (errors.link) $('#edit-service-package-id-error').text(errors.link[0]);
                        if (errors.banner_image) $('#edit-service-image-error').text(errors.package_id[0]);
                        $('.text-danger').removeClass('d-none');
                    }
                }
            });
        });

        $(document).on("click", ".delete-service", function(e) {
            e.preventDefault();
            let itemId = $(this).data("id");
            let itemUrl = $(this).data("url");
            let row = $(this).closest("tr"); // parent <tr>
            Swal.fire({
                title: "Are you sure?",
                text: "This item will be deleted!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#e3342f",
                cancelButtonColor: "#6c757d",
                confirmButtonText: "Yes, delete it",
                cancelButtonText: "Cancel",
                customClass: {
                    popup: 'rounded-2xl shadow-lg',  // Rounded + shadow
                    confirmButton: 'px-4 py-2 text-white',
                    cancelButton: 'px-4 py-2 text-white'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: itemUrl,
                        success: function(res) {
                            if(res.success){
                                row.remove();
                                Swal.fire(
                                    "Deleted!",
                                    "The item has been deleted successfully.",
                                    "success"
                                );
                            }
                        },
                        error: function(xhr) {
                            toastr.error('Service not deleted!', 'Failed');
                        }
                    });
                    
                }
            });
        });

        document.getElementById('edit_service_image').addEventListener('change', function(event) {
            let input = event.target;
            let file = event.target.files[0];
            let preview = document.getElementById('servicePreviewEdit');
            

            if (file && file.type === 'image/webp') {
                let reader = new FileReader();
                reader.onload = function(e) {
                    let col = document.createElement('div');
                    col.classList.add('col-md-12', 'mb-3');
                    col.innerHTML = `
                        <div class="card">
                            <img src="${e.target.result}" class="card-img-top img-fluid" 
                                style="height:150px; object-fit:cover;">
                        </div>
                    `;
                    preview.innerHTML = ""; // Clear old preview
                    preview.appendChild(col);
                };
                reader.readAsDataURL(file);
            } else {
                toastr.error("Only .webp images are allowed!", 'Error');
                input.value = ""; // reset invalid file
            }
        });


        $(document).on('click', '.page-meta', function() {
            let btn = $(this);
            let id = $(this).data('id');
            let dataUrl = $(this).data('url').trim();
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            $.ajax({
                type: "GET",
                dataType: "json",
                url: dataUrl,
                success: function(data) {
                    $('#page-title').text('# '+data.title+'-Meta Info');
                    if(data.meta != null){
                        $('#page_meta_title').val(data.meta.meta_title);
                        $('#page_meta_description').val(data.meta.meta_description);
                        $('#page_meta_keywords').val(data.meta.meta_keywords);
                        $('#page_h1_heading').val(data.meta.h1_heading);
                        $('#page_meta_details').val(data.meta.meta_details);
                    }
                    $('#pageMetaModal').modal('show');
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while fetching city details.'
                    });
                },
                complete: function () {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                }
            });
        });

    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/cholantravels/backend/resources/views/admin/settings/home.blade.php ENDPATH**/ ?>